/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.rename;

import com.scenari.m.bdp.module.rename.HRenamingPlan;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.uris.SrcFeatureUris;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;

public class HRenamingPlanSpace
extends HRenamingPlan {
    protected ISrcNode fOldSrc = null;
    protected ISrcNode fNewSrc = null;

    public HRenamingPlanSpace(ISrcNode pOldSrc, ISrcNode pNewSrc) {
        this.fOldSrc = pOldSrc;
        this.fNewSrc = pNewSrc;
    }

    public String getNewRefUri(String pOldRefUri) {
        try {
            String vOldUri;
            if (pOldRefUri == null || pOldRefUri.length() == 0) {
                return "";
            }
            boolean vRefById = SrcFeatureIds.isSrcId(pOldRefUri);
            String string = vOldUri = vRefById ? SrcFeatureIds.findUriById(this.fOldSrc, pOldRefUri) : pOldRefUri;
            if (vOldUri != null && SrcFeatureUris.isAncestorOrSameUri(this.fOldSrc.getSrcUri(), vOldUri)) {
                StringBuilder vBuf = PoolBuffers.popStringBuilder();
                vBuf.append(this.fNewSrc.getSrcUri());
                vBuf.append(vOldUri, this.fOldSrc.getSrcUri().length(), vOldUri.length());
                String vNewUri = PoolBuffers.getStringAndFreeStringBuilder(vBuf);
                if (vRefById) {
                    String vNewId = SrcFeatureIds.getOrCreateSrcId(this.fNewSrc.findNodeByUri(vNewUri));
                    if (vNewId != null) {
                        return vNewId;
                    }
                    return vNewUri;
                }
                return vNewUri;
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        return pOldRefUri;
    }

    public boolean isInPlan(String pUri) {
        return SrcFeatureUris.isAncestorOrSameUri(this.fOldSrc.getSrcUri(), pUri);
    }
}

