/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.rename.multi;

import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.HModule;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.identif.HTreatIdentif;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.m.co.user.IUser;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class HModuleRenameMulti
extends HModule
implements IHModuleRename {
    protected boolean fRenameMainUriResAsItem = true;
    protected List<RenameRes> fListRenamings = new ArrayList<RenameRes>();

    public HModuleRenameMulti(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
    }

    public IByteStream renameStream(IHRenamingPlan pRenamingPlan, ISrcNode pSrcFrom, ISrcNode pSrcTarget) throws Exception {
        String vUriRes = WspSrcUtil.extractItemUriRes(pSrcFrom.getSrcUri());
        for (int i = 0; i < this.fListRenamings.size(); ++i) {
            RenameRes vRenameRes = this.fListRenamings.get(i);
            if (vRenameRes.fModule == null || !vRenameRes.fUriResPattern.matcher(vUriRes).matches()) continue;
            return vRenameRes.fModule.renameStream(pRenamingPlan, pSrcFrom, pSrcTarget);
        }
        return null;
    }

    public IHItem hRenameItem(IHRenamingPlan pRenamingPlan, IHItemDef pItemSrc, IHItemDef pItemDst, IUser pUser, int pClientId, IHTransaction pTransaction) throws Exception {
        IHWorkspace vDestWsp = pItemDst.hGetWorkspace();
        IHItemType vItemType = pItemSrc == pItemDst ? vDestWsp.hGetItemType(pItemSrc.getUriSs()) : HTreatIdentif.findItemType(vDestWsp, pItemDst.getUri(), null, null);
        ISrcNode vSrcFrom = pItemSrc.getSrcNode().getSubSrcNode();
        ISrcNode vSrcTarget = pItemSrc != pItemDst ? pItemDst.getSrcNode().getSubSrcNode() : vSrcFrom;
        List<ISrcNode> vChildren = vSrcFrom.listChildrenNodes(null);
        if (vChildren == null || vChildren.size() == 0) {
            if (vSrcFrom != vSrcTarget) {
                vSrcTarget.createAsFolder();
            }
        } else if (this.fRenameMainUriResAsItem && !vSrcFrom.getSrcName().equals(vSrcTarget.getSrcName())) {
            String vItemNameFrom = vSrcFrom.getSrcName();
            for (ISrcNode vChild : vChildren) {
                if (vChild.getSrcName().equals(vItemNameFrom)) {
                    this.xApplyRenameOnRes(pRenamingPlan, vChild, vSrcTarget.findNodeChild(vSrcTarget.getSrcName()));
                    continue;
                }
                this.xApplyRenameOnRes(pRenamingPlan, vChild, vSrcTarget.findNodeChild(vChild.getSrcName()));
            }
        } else if (vSrcFrom != vSrcTarget) {
            for (ISrcNode vChild : vChildren) {
                this.xApplyRenameOnRes(pRenamingPlan, vChild, vSrcTarget.findNodeChild(vChild.getSrcName()));
            }
        } else {
            for (ISrcNode vChild : vChildren) {
                this.xApplyRenameOnRes(pRenamingPlan, vChild, vChild);
            }
        }
        return vItemType.hGetModuleSave().hValidateItem(pItemDst, null, pUser != null ? pUser.getAccount() : null, pClientId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void xApplyRenameOnRes(IHRenamingPlan pRenamingPlan, ISrcNode pSrc, ISrcNode pDst) throws Exception {
        block22: {
            block23: {
                block21: {
                    block20: {
                        if (pSrc.getContentStatus() != 1) break block23;
                        vStreamSrc = null;
                        vStream = null;
                        vRenameDone = false;
                        vUriRes = WspSrcUtil.extractItemUriRes(pSrc.getSrcUri());
                        for (i = 0; i < this.fListRenamings.size(); ++i) {
                            vRenameRes = this.fListRenamings.get(i);
                            if (vRenameRes.fModule == null || !vRenameRes.fUriResPattern.matcher(vUriRes).matches()) continue;
                            vRenamedStream = vRenameRes.fModule.renameStream(pRenamingPlan, pSrc, pDst);
                            if (vRenamedStream == null) break;
                            try {
                                vOut = pDst.newOutputStream(false);
                                try {
                                    vRenamedStream.writeIn(vOut);
                                    vRenameDone = true;
                                    var13_17 = null;
                                    ** if (vOut == null) goto lbl-1000
                                }
                                catch (Throwable var12_19) {
                                    var13_18 = null;
                                    if (vOut != null) {
                                        vOut.close();
                                    }
                                    throw var12_19;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    vOut.close();
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                                var15_20 = null;
                                vRenamedStream.closeStream();
                                break;
                            }
                            catch (Throwable var14_22) {
                                var15_21 = null;
                                vRenamedStream.closeStream();
                                throw var14_22;
                            }
                        }
                        if (vRenameDone || pSrc == pDst) break block20;
                        SrcFeatureCopyMove.copy(pSrc, pDst);
                    }
                    var17_23 = null;
                    if (vStreamSrc == null) break block21;
                    try {
                        vStreamSrc.close();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                if (vStream == null) break block22;
                vStream.close();
                {
                    break block22;
                    catch (Exception e) {
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Renaming failed : " + pSrc, new String[0]);
                    }
                }
                catch (Throwable var16_27) {
                    var17_24 = null;
                    if (vStreamSrc != null) {
                        try {
                            vStreamSrc.close();
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    if (vStream != null) {
                        vStream.close();
                    }
                    throw var16_27;
                }
            }
            if (pSrc != pDst) {
                pDst.createAsFolder();
                for (ISrcNode vChild : pSrc.listChildrenNodes(null)) {
                    this.xApplyRenameOnRes(pRenamingPlan, vChild, pDst.findNodeChild(vChild.getSrcName()));
                }
            } else {
                for (ISrcNode vChild : pSrc.listChildrenNodes(null)) {
                    this.xApplyRenameOnRes(pRenamingPlan, vChild, vChild);
                }
            }
        }
    }

    public void wLinkModules() {
        try {
            for (int i = 0; i < this.fListRenamings.size(); ++i) {
                RenameRes vRenameRes = this.fListRenamings.get(i);
                IHModule vModule = this.fItemType.hGetModule(vRenameRes.fCodeModule);
                if (vModule == null) {
                    this.fItemType.wAddCompilProblem(new HProblem("Warning", "system.module.renameMulti", "Module '" + vRenameRes.fCodeModule + "' used in module '" + this.hGetCodeModule() + "' is undefined.", null));
                    continue;
                }
                if (!(vModule instanceof IHModuleRename)) {
                    this.fItemType.wAddCompilProblem(new HProblem("Warning", "system.module.renameMulti", "Module '" + vRenameRes.fCodeModule + "' used in module '" + this.hGetCodeModule() + "' is not a Rename module.", null));
                    continue;
                }
                vRenameRes.fModule = (IHModuleRename)vModule;
            }
        }
        catch (Exception e) {
            this.fItemType.wAddCompilProblem(new HProblem("Error", "system.module.renameMulti", e.getMessage(), null));
        }
    }

    public void wAddRenameRes(RenameRes pRenameRes) {
        this.fListRenamings.add(pRenameRes);
    }

    public void wSetRenameMainUriResAsItem(boolean pRenameMainUriResAsItem) {
        this.fRenameMainUriResAsItem = pRenameMainUriResAsItem;
    }

    public static class RenameRes {
        public Pattern fUriResPattern;
        public String fCodeModule;
        public IHModuleRename fModule = null;

        public RenameRes(Pattern pUriResPattern, String pCodeModule) {
            this.fUriResPattern = pUriResPattern;
            this.fCodeModule = pCodeModule;
        }
    }
}

