/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.save;

import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.base.HProblem;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.HModule;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.genitem.IHModuleGenItem;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.m.bdp.module.save.IHModuleSave;
import com.scenari.m.bdp.transaction.IHTransaction;
import com.scenari.xsldtm.xml.dtm.DTM;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;
import java.util.List;

public class HModuleSave
extends HModule
implements IHModuleSave {
    protected List fGenItemList = null;

    public HModuleSave(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
    }

    public IHItem hSaveItem(IHItemDef pPreviousItemDef, String pUriRes, HStreamHandler pStreamHandler, String pUsr, int pClientId, IHTransaction pTrans) throws Exception {
        IHWorkspace vWsp = pPreviousItemDef.hGetWorkspace();
        IHItem vResult = vWsp.createItem(this.fItemType, pPreviousItemDef.getUri());
        vResult.hSetUser(pUsr);
        this.xFillItem(vResult, pPreviousItemDef, pUriRes, false, pStreamHandler);
        IHTransaction vTrans = pTrans != null ? pTrans : vWsp.hTransactionOpen();
        try {
            vWsp.hGetContentAccess().hWrite(vResult, pUriRes, pStreamHandler != null ? pStreamHandler.hGetLastInputStream() : null, vTrans);
            vWsp.hSaveItem(vResult, vTrans, pClientId);
            if (pTrans == null) {
                vWsp.hTransactionCommit(vTrans);
            }
        }
        catch (Exception e) {
            if (pTrans == null) {
                vWsp.hTransactionRollback(vTrans);
            }
            throw e;
        }
        catch (Throwable e) {
            if (pTrans == null) {
                vWsp.hTransactionRollback(vTrans);
            }
            throw LogMgr.newException(LogMgr.getMessage(e));
        }
        return vResult;
    }

    public IHItem hFillItem(IHItemDef pPreviousItemDef, String pUriRes, HStreamHandler pStreamHandler, String pUsr) throws Exception {
        IHItem vResult = pPreviousItemDef.hGetWorkspace().createItem(this.fItemType, pPreviousItemDef.getUri());
        vResult.hSetUser(pUsr);
        this.xFillItem(vResult, pPreviousItemDef, pUriRes, false, pStreamHandler);
        return vResult;
    }

    public void xFillItem(IHItem pItem, IHItemDef pPreviousItemDef, String pUriRes, boolean pIsRemoveRes, HStreamHandler pStreamHandler) throws Exception {
        if (this.fGenItemList != null) {
            for (int i = 0; i < this.fGenItemList.size(); ++i) {
                IHModuleGenItem vModule = ((GenItem)this.fGenItemList.get((int)i)).fModule;
                this.xCallGenItemModule(pItem, vModule, pUriRes, pStreamHandler);
            }
        }
    }

    protected void xCallGenItemModule(IHItem pItem, IHModuleGenItem pModule, String pUriRes, HStreamHandler pStreamHandler) throws Exception {
        if (pModule.hGetParametersType() == 2) {
            if (pStreamHandler == null) {
                if (pItem.hGetContentProblemByCode("system.nocontent") == null) {
                    pItem.hAddContentError("system.nocontent", pUriRes == null || pUriRes.length() == 0 ? "Cette ressource XML est vide." : "La ressource '" + pUriRes + "' est vide.", null);
                }
                return;
            }
            DTM vXml = pStreamHandler.getDtm(pItem.getUri());
            if (vXml == null) {
                if (pStreamHandler.isLoadXmlFailed() && pItem.hGetContentProblemByCode("system.xmlnotwellformed") == null) {
                    pItem.hAddContentError("system.xmlnotwellformed", pUriRes == null || pUriRes.length() == 0 ? "Cette ressource n'est pas du XML bien form\u00e9." : "La ressource '" + pUriRes + "' n'est pas du XML bien form\u00e9.", null);
                }
            } else {
                pModule.hFillItem(pItem, pStreamHandler.getXPathContext(), vXml);
            }
        } else if (pStreamHandler != null) {
            pModule.hFillItem(pItem, pStreamHandler.hGetCachedInputStream());
        } else {
            pModule.hFillItem(pItem, null);
        }
    }

    public IHItem hValidateItem(IHItemDef pPreviousItemDef, HStreamHandler pStreamHandler, String pUsr, int pClientId, IHTransaction pTransaction) throws Exception {
        IHWorkspace vWsp = pPreviousItemDef.hGetWorkspace();
        IHItem vResult = vWsp.createItem(this.fItemType, pPreviousItemDef.getUri());
        vResult.hSetUser(pUsr);
        this.xFillItem(vResult, pPreviousItemDef, null, false, pStreamHandler);
        vWsp.hSaveItem(vResult, pTransaction, pClientId);
        return vResult;
    }

    public void xAddModuleGenItem(String pCodeModule, boolean pOptional) {
        if (this.fGenItemList == null) {
            this.fGenItemList = new ArrayList(3);
        }
        GenItem vNewGenItem = new GenItem();
        vNewGenItem.fCdModule = pCodeModule;
        vNewGenItem.fOptional = pOptional;
        if (!this.fGenItemList.contains(vNewGenItem)) {
            this.fGenItemList.add(vNewGenItem);
        }
    }

    public void xRemoveModuleGenItem(String pCodeModule) {
        if (this.fGenItemList != null) {
            for (int i = 0; i < this.fGenItemList.size(); ++i) {
                if (!((GenItem)this.fGenItemList.get((int)i)).fCdModule.equals(pCodeModule)) continue;
                this.fGenItemList.remove(i);
                return;
            }
        }
    }

    public void wLinkModules() {
        if (this.fGenItemList != null) {
            for (int i = 0; i < this.fGenItemList.size(); ++i) {
                GenItem vGenItem = (GenItem)this.fGenItemList.get(i);
                try {
                    if (vGenItem.fCdModule == null) continue;
                    IHModule vModule = this.fItemType.hGetModule(vGenItem.fCdModule);
                    if (vModule == null) {
                        if (vGenItem.fOptional) continue;
                        this.fItemType.wAddCompilProblem(new HProblem("Error", "system.modulesave.missingmodule", "Le module de code '" + vGenItem.fCdModule + "' utilis\u00e9 dans le module '" + this.hGetCodeModule() + "' n'existe pas.", null));
                        continue;
                    }
                    if (!(vModule instanceof IHModuleGenItem)) {
                        this.fItemType.wAddCompilProblem(new HProblem("Error", "system.modulesave.wrongmoduletype", "Le module de code '" + vGenItem.fCdModule + "' utilis\u00e9 dans le module '" + this.hGetCodeModule() + "' n'est pas du bon type (g\u00e9n\u00e9ration d'item).", null));
                        continue;
                    }
                    vGenItem.fModule = (IHModuleGenItem)vModule;
                    continue;
                }
                catch (Exception e) {
                    this.fItemType.wAddCompilProblem(new HProblem("Error", "system.modulesave.missingmodule", "Le module de code '" + vGenItem.fCdModule + "' utilis\u00e9 dans le module '" + this.hGetCodeModule() + "' n'existe pas.", null));
                }
            }
        }
    }

    public static class GenItem {
        public String fCdModule = null;
        public boolean fOptional = false;
        public IHModuleGenItem fModule = null;

        public boolean equals(Object pObj) {
            if (this.fCdModule == null || !(pObj instanceof GenItem)) {
                return false;
            }
            if (((GenItem)pObj).fCdModule == null) {
                return false;
            }
            return ((GenItem)pObj).fCdModule.equals(this.fCdModule);
        }
    }
}

