/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.save;

import com.scenari.m.bdp.module.identif.HTreatIdentif;
import com.scenari.s.fw.util.xml.HXPathContextDyn;
import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.FullBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class HStreamHandler {
    protected InputStream fStream = null;
    protected FullBufferedInputStream fCachedStream = null;
    protected DTM fDtm = null;
    protected HXPathContextDyn fXPathCtx = null;
    protected boolean fLoadXmlFailed = false;

    public HStreamHandler(InputStream pStreamSrc) {
        this.fStream = pStreamSrc;
    }

    public InputStream hGetCachedInputStream() throws Exception {
        if (this.fCachedStream == null) {
            this.fCachedStream = new FullBufferedInputStream(this.fStream);
        } else {
            this.fCachedStream.rewind();
        }
        return this.fCachedStream;
    }

    public InputStream hGetLastInputStream() throws Exception {
        InputStream vStream = this.fStream;
        if (this.fCachedStream != null) {
            InputStream vRest = this.fCachedStream.disconnectSubInputStream();
            this.fCachedStream.rewindForLastRead();
            vStream = vRest != null ? new SequenceInputStream(this.fCachedStream, vRest) : this.fCachedStream;
        }
        return vStream;
    }

    public void hCloseAndPurgeCache() {
        if (this.fCachedStream != null) {
            this.fCachedStream.destroy();
            this.fCachedStream = null;
        }
        if (this.fStream != null) {
            try {
                this.fStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fStream = null;
        }
        if (this.fDtm != null) {
            this.fDtm.documentRelease();
            this.fDtm = null;
            this.fXPathCtx = null;
        }
    }

    public DTM getDtm(String pUri) throws Exception {
        if (this.fDtm == null && !this.fLoadXmlFailed) {
            this.fXPathCtx = new HXPathContextDyn();
            try {
                this.fDtm = this.fXPathCtx.hGetDtm(this.hGetCachedInputStream(), null, false);
            }
            catch (WrappedRuntimeException e) {
                this.fLoadXmlFailed = true;
                if (e.getException() instanceof IOException) {
                    this.hCloseAndPurgeCache();
                    throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la r\u00e9cup\u00e9ration du stream complet de " + pUri, new String[0]);
                }
                if (HTreatIdentif.sTrace.isEnabled()) {
                    LogMgr.addMessage(e, LogMgr.getMessage(e.getException()));
                    LogMgr.publishException((Throwable)e, "Echec au parsing XML du fichier " + pUri, new String[0]);
                }
                this.fDtm = null;
            }
            catch (Exception e) {
                this.fLoadXmlFailed = true;
                if (HTreatIdentif.sTrace.isEnabled()) {
                    LogMgr.publishException((Throwable)e, "Echec au parsing XML du fichier " + pUri, new String[0]);
                }
                this.fDtm = null;
            }
        }
        return this.fDtm;
    }

    public HXPathContextDyn getXPathContext() {
        return this.fXPathCtx;
    }

    public boolean isLoadXmlFailed() {
        return this.fLoadXmlFailed;
    }

    public void substituteStream(InputStream pStream) {
        this.hCloseAndPurgeCache();
        this.fLoadXmlFailed = false;
        this.fStream = pStream;
    }
}

