/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.save.automultires;

import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemcontent.IHContentAccess;
import com.scenari.m.bdp.itemcontent.IHResourceDef;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.save.HModuleSave;
import com.scenari.m.bdp.module.save.HStreamHandler;
import com.scenari.m.bdp.module.save.IHModuleSave;
import com.scenari.m.bdp.transaction.IHTransaction;
import eu.scenari.fw.log.LogMgr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class HModuleSaveAutoMultiRes
extends HModuleSave
implements IHModuleSave {
    protected boolean fCreateDefaultFile = true;

    public HModuleSaveAutoMultiRes(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
    }

    public IHItem hSaveItem(IHItemDef pPreviousItemDef, String pUriRes, HStreamHandler pStreamHandler, String pUsr, int pClientId, IHTransaction pTrans) throws Exception {
        IHWorkspace vWsp = pPreviousItemDef.hGetWorkspace();
        IHContentAccess vContentAccess = vWsp.hGetContentAccess();
        IHItem vResult = vWsp.createItem(this.fItemType, pPreviousItemDef.getUri());
        vResult.hSetUser(pUsr);
        IHTransaction vTrans = pTrans != null ? pTrans : vWsp.hTransactionOpen();
        try {
            vContentAccess.hTransformItem2MultiRes(pPreviousItemDef, vTrans, pPreviousItemDef.hGetCode());
            if (this.fCreateDefaultFile && pUriRes == null) {
                pUriRes = "/".concat(pPreviousItemDef.hGetCode());
            }
            this.xFillItem(vResult, pPreviousItemDef, pUriRes, false, pStreamHandler);
            vContentAccess.hWrite(vResult, pUriRes, pStreamHandler != null ? pStreamHandler.hGetLastInputStream() : null, vTrans);
            vWsp.hSaveItem(vResult, vTrans, pClientId);
            if (pTrans == null) {
                vWsp.hTransactionCommit(vTrans);
            }
        }
        catch (Exception e) {
            if (pTrans == null) {
                vWsp.hTransactionRollback(vTrans);
            }
            throw e;
        }
        catch (Throwable e) {
            if (pTrans == null) {
                vWsp.hTransactionRollback(vTrans);
            }
            throw LogMgr.newException(LogMgr.getMessage(e));
        }
        return vResult;
    }

    public void xAddModuleGenItem(String pCodeModule, String pUriResRegExp, String pErrorIfLength0, String pWarningIfLength0, String pErrorIfNotExist, String pWarningIfNotExist) {
        if (this.fGenItemList == null) {
            this.fGenItemList = new ArrayList(3);
        }
        GenItemUriRes vNewGenItem = new GenItemUriRes();
        vNewGenItem.fCdModule = pCodeModule;
        if (!this.fGenItemList.contains(vNewGenItem)) {
            vNewGenItem.fUriRes = pUriResRegExp != null && pUriResRegExp.length() > 0 ? Pattern.compile(pUriResRegExp) : null;
            vNewGenItem.fErrorIfLength0 = pErrorIfLength0;
            vNewGenItem.fWarningIfLength0 = pWarningIfLength0;
            vNewGenItem.fErrorIfNotExist = pErrorIfNotExist;
            vNewGenItem.fWarningIfNotExist = pWarningIfNotExist;
            this.fGenItemList.add(vNewGenItem);
        }
    }

    public void xFillItem(IHItem pItem, IHItemDef pPreviousItemDef, String pUriRes, boolean pIsRemoveRes, HStreamHandler pStreamHandler) throws Exception {
        IHContentAccess vContentAccess = pItem.hGetWorkspace().hGetContentAccess();
        if (this.fGenItemList != null) {
            ArrayList<Res> vListRes = new ArrayList<Res>();
            Res vCurrRes = new Res();
            String string = vCurrRes.fUriRes = pUriRes == null ? "" : pUriRes;
            if (pUriRes != null && pUriRes.length() - 1 == pItem.hGetCode().length() && pUriRes.regionMatches(true, 1, pItem.hGetCode(), 0, pItem.hGetCode().length())) {
                vCurrRes.fUriRes = "";
            }
            if (pIsRemoveRes) {
                vCurrRes.fDoesNotExist = true;
            } else {
                IHResourceDef vResDef;
                vCurrRes.fStream = pStreamHandler;
                if (vCurrRes.fStream == null && vCurrRes.fUriRes.length() == 0 && (vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, null, null, null)).hIsFolder()) {
                    vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, "/".concat(pPreviousItemDef.hGetCode()), null, null);
                    vCurrRes.fDoesNotExist = vResDef == null;
                }
            }
            vListRes.add(vCurrRes);
            ArrayList vListUriRes = null;
            for (int i = 0; i < this.fGenItemList.size(); ++i) {
                Res vRes;
                int j;
                GenItemUriRes vGenItem = (GenItemUriRes)this.fGenItemList.get(i);
                IHResourceDef vResDef = null;
                vCurrRes = null;
                if (vGenItem.fUriRes != null) {
                    for (j = 0; j < vListRes.size(); ++j) {
                        vRes = (Res)vListRes.get(j);
                        if (!vGenItem.fUriRes.matcher(vRes.fUriRes).matches()) continue;
                        vCurrRes = vRes;
                        break;
                    }
                } else {
                    for (j = 0; j < vListRes.size(); ++j) {
                        vRes = (Res)vListRes.get(j);
                        if (vRes.fUriRes.length() != 0) continue;
                        vCurrRes = vRes;
                        break;
                    }
                }
                if (vCurrRes == null) {
                    vCurrRes = new Res();
                    if (vGenItem.fUriRes == null) {
                        vCurrRes.fUriRes = "";
                        vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, null, null, null);
                        if (vResDef.hIsFolder()) {
                            vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, "/".concat(pPreviousItemDef.hGetCode()), null, null);
                            vCurrRes.fDoesNotExist = vResDef == null;
                        }
                        vListRes.add(vCurrRes);
                    } else {
                        if (vListUriRes == null) {
                            vListUriRes = new ArrayList();
                            if (pPreviousItemDef.getUri() != IHItemDef.URI_NULL) {
                                vContentAccess.hListUriRes(vListUriRes, pPreviousItemDef, null, false, null);
                            }
                        }
                        vCurrRes.fDoesNotExist = true;
                        for (j = 0; j < vListUriRes.size(); ++j) {
                            String vUriRes = (String)vListUriRes.get(j);
                            if (!vGenItem.fUriRes.matcher(vUriRes).matches()) continue;
                            vCurrRes.fUriRes = vUriRes;
                            vCurrRes.fDoesNotExist = false;
                            vListRes.add(vCurrRes);
                            break;
                        }
                    }
                }
                if (vCurrRes.fDoesNotExist) {
                    if (vGenItem.fErrorIfNotExist != null) {
                        pItem.hAddContentError("system.missingfile", vGenItem.fErrorIfNotExist, null);
                    }
                    if (vGenItem.fWarningIfNotExist == null) continue;
                    pItem.hAddContentError("system.missingfile", vGenItem.fWarningIfNotExist, null);
                    continue;
                }
                if (vGenItem.fErrorIfLength0 != null || vGenItem.fWarningIfLength0 != null) {
                    boolean vIsLen0 = true;
                    if (vCurrRes.fStream != null) {
                        InputStream vStr = vCurrRes.fStream.hGetCachedInputStream();
                        if (vStr.read() >= 0) {
                            vIsLen0 = false;
                        }
                        vStr.close();
                    } else {
                        if (vResDef == null && (vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, vCurrRes.fUriRes, null, null)).hIsFolder()) {
                            vResDef = vContentAccess.hGetResourceDef(pPreviousItemDef, "/".concat(pPreviousItemDef.hGetCode()), null, null);
                        }
                        if (vResDef != null && vResDef.hGetLength() > 0) {
                            vIsLen0 = false;
                        }
                    }
                    if (vIsLen0) {
                        if (vGenItem.fErrorIfLength0 != null) {
                            pItem.hAddContentError("system.emptyfile", vGenItem.fErrorIfLength0, null);
                        }
                        if (vGenItem.fWarningIfLength0 != null) {
                            pItem.hAddContentError("system.emptyfile", vGenItem.fWarningIfLength0, null);
                        }
                    }
                }
                if (vGenItem.fModule == null) continue;
                this.xCallGenItemModule(pItem, vGenItem.fModule, vCurrRes.fUriRes, vCurrRes.getStreamHandler(this.fItemType, pPreviousItemDef));
            }
        }
    }

    public boolean isCreateDefaultFile() {
        return this.fCreateDefaultFile;
    }

    public void setCreateDefaultFile(boolean pCreateDefaultFile) {
        this.fCreateDefaultFile = pCreateDefaultFile;
    }

    public static class Res {
        public String fUriRes = null;
        public boolean fDoesNotExist = false;
        private HStreamHandler fStream = null;

        public HStreamHandler getStreamHandler(IHItemType pItemType, IHItemDef pPreviousItemDef) throws Exception {
            if (this.fDoesNotExist) {
                return null;
            }
            if (this.fStream != null) {
                return this.fStream;
            }
            IHContentAccess vContentAccess = pPreviousItemDef.hGetWorkspace().hGetContentAccess();
            InputStream vInputStream = vContentAccess.hReadStream(pPreviousItemDef, this.fUriRes, null, null);
            if (vInputStream != null) {
                this.fStream = new HStreamHandler(vInputStream);
            } else {
                if (this.fUriRes.length() == 0) {
                    vInputStream = vContentAccess.hReadStream(pPreviousItemDef, "/".concat(pPreviousItemDef.hGetCode()), null, null);
                }
                if (vInputStream != null) {
                    this.fStream = new HStreamHandler(vInputStream);
                } else {
                    this.fDoesNotExist = true;
                }
            }
            return this.fStream;
        }
    }

    public static class GenItemUriRes
    extends HModuleSave.GenItem {
        public Pattern fUriRes = null;
        public String fErrorIfNotExist = null;
        public String fWarningIfNotExist = null;
        public String fErrorIfLength0 = null;
        public String fWarningIfLength0 = null;
    }
}

