/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewdeflatedzip;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.itemcontent.IHResourceDef;
import com.scenari.m.bdp.module.viewdeflatedzip.HModuleViewDeflatedZip;
import com.scenari.m.bdp.module.viewsource.HModuleViewSourceCache;
import com.scenari.m.bdp.module.viewsource.WViewSourceCache;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcContent;
import com.scenari.src.helpers.base.SrcContentFileBase;
import com.scenari.src.helpers.base.SrcContentFolderBase;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HZipTree
extends WViewSourceCache {
    public static TracePoint sTrace = TraceMgr.register(HZipTree.class.getName(), "Trace du refresh d'un ZipTree");
    protected IHItemDef fItemDef = null;
    protected XSourceFolder fSourceRoot = null;

    public HZipTree(HItemDefVers pItemFolder, HModuleViewSourceCache pModule) {
        super(pItemFolder, pModule);
    }

    public ISrcContent findContentByUri(String pUri) throws Exception {
        assert (pUri != null);
        this.wLoadEntries();
        if (this.fSourceRoot != null) {
            if (pUri == null) {
                return ISrcContent.NULL;
            }
            if (pUri.length() == 0) {
                return this.fSourceRoot;
            }
            return this.fSourceRoot.findUri(pUri, 1, false);
        }
        return ISrcContent.NULL;
    }

    protected synchronized void wLoadEntries() throws Exception {
        try {
            if (this.fItemDef == null) {
                this.fItemDef = this.fWsp.hGetItemDef(this.fItemViewSource.getUri(), null);
                if (this.fItemDef.hGetStatus() == 1) {
                    HModuleViewDeflatedZip vModule = (HModuleViewDeflatedZip)this.fModule;
                    this.fSourceRoot = new XSourceFolder(null).init(vModule.fZipFileName != null, vModule.fFolderName != null);
                }
            }
        }
        catch (Exception e) {
            this.fItemDef = null;
            throw e;
        }
    }

    public boolean refresh() throws Exception {
        super.refresh();
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("Refresh Zip tree : " + this.fItemViewSource.getUri(), new String[0]);
        }
        return true;
    }

    protected final synchronized void wRemove() {
        super.wRemove();
        this.fItemDef = null;
    }

    public class XZipMapParser
    extends DefaultHandler {
        protected XSourceFolder fFolderRootContent = null;

        public XZipMapParser(XSourceFolder pRoot) {
            this.fFolderRootContent = pRoot;
        }

        public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            block7: {
                try {
                    if (pLocalName != "entry") break block7;
                    String vPathName = pAtts.getValue("name");
                    if (!vPathName.endsWith("/")) {
                        long vSize = 0L;
                        try {
                            vSize = Long.parseLong(pAtts.getValue("size"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        XSourceFolder vParent = this.fFolderRootContent;
                        int vIdx = vPathName.lastIndexOf(47);
                        if (vIdx >= 0) {
                            vParent = (XSourceFolder)this.fFolderRootContent.findUri(vPathName.substring(0, vIdx), 0, true);
                        }
                        vParent.fChilds.add(new XSourceFile(vPathName, (int)vSize));
                        break block7;
                    }
                    String vName = vPathName;
                    XSourceFolder vParent = this.fFolderRootContent;
                    int vEnd = vPathName.length() - 1;
                    int vIdx = vPathName.lastIndexOf(47, vEnd - 1);
                    vName = vPathName.substring(vIdx + 1, vEnd);
                    if (vIdx >= 0) {
                        vParent = (XSourceFolder)this.fFolderRootContent.findUri(vPathName.substring(0, vIdx), 0, true);
                    }
                    vParent.fChilds.add(new XSourceFolder(vName));
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                    throw new SAXException(e);
                }
            }
        }
    }

    public class XSourceFile
    extends SrcContentFileBase {
        int fSize = -1;
        protected String fName = null;
        HTransformParams fParams = null;

        public XSourceFile(String pZipName, int pSize) throws Exception {
            this.fSize = pSize;
            if (pZipName != null) {
                this.fParams = HTransformParams.hNewParamsTransformOfType(((HModuleViewDeflatedZip)HZipTree.this.fModule).fZipTransformType);
                this.fParams.hPut("path", pZipName);
                int vIdx = pZipName.lastIndexOf(47);
                this.fName = pZipName.substring(vIdx + 1);
            } else {
                this.fName = ((HModuleViewDeflatedZip)HZipTree.this.fModule).fZipFileName;
            }
        }

        public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
            HZipTree.this.wLoadEntries();
            return HZipTree.this.fWsp.hGetContentAccess().hReadStream(HZipTree.this.fItemDef, null, this.fParams, null);
        }

        public int getContentSize() throws Exception {
            if (this.fSize < 0) {
                HZipTree.this.wLoadEntries();
                IHResourceDef vDef = HZipTree.this.fWsp.hGetContentAccess().hGetResourceDef(HZipTree.this.fItemDef, null, this.fParams, null);
                this.fSize = vDef != null ? vDef.hGetLength() : 0;
            }
            return this.fSize;
        }

        public long getLastModifWithChildren() throws Exception {
            return HZipTree.this.fLastUpdate;
        }
    }

    public class XSourceFolder
    extends SrcContentFolderBase {
        protected String fName = null;
        protected List fChilds = new ArrayList();

        public XSourceFolder(String pName) {
            this.fName = pName;
        }

        public long getLastModifWithChildren() throws Exception {
            return HZipTree.this.fLastUpdate;
        }

        public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
            ArrayList<String> vResult = null;
            vResult = new ArrayList<String>();
            if (pStatusChilds == 0) {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    String vName = vCh instanceof XSourceFolder ? ((XSourceFolder)vCh).fName : ((XSourceFile)vCh).fName;
                    vResult.add(vName);
                }
            } else if (pStatusChilds == 1) {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    if (!(vCh instanceof XSourceFile)) continue;
                    String vName = ((XSourceFile)vCh).fName;
                    vResult.add(vName);
                }
            } else {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    if (!(vCh instanceof XSourceFolder)) continue;
                    String vName = ((XSourceFolder)vCh).fName;
                    vResult.add(vName);
                }
            }
            return vResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected XSourceFolder init(boolean pWithZipFile, boolean pWithContentFolder) throws Exception {
            if (pWithZipFile) {
                this.fChilds.add(new XSourceFile(null, -1));
            }
            if (pWithContentFolder) {
                this.fChilds.add(new XSourceFolder(((HModuleViewDeflatedZip)HZipTree.this.fModule).fFolderName).init(false, false));
                return this;
            }
            String vTypTransform = ((HModuleViewDeflatedZip)HZipTree.this.fModule).fZipTransformType;
            InputStream vInputStream = HZipTree.this.fWsp.hGetContentAccess().hReadStream(HZipTree.this.fItemDef, null, HTransformParams.hNewParamsTransformOfType(vTypTransform), null);
            try {
                XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                vXmlReader.setContentHandler(new XZipMapParser(this));
                vXmlReader.parse(new InputSource(vInputStream));
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
                Object var7_6 = null;
                if (vInputStream == null) return this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (vInputStream == null) throw throwable;
                vInputStream.close();
                throw throwable;
            }
            vInputStream.close();
            return this;
        }

        protected ISrcContent findUri(String pUri, int pStart, boolean pCreate) {
            for (int i = 0; i < this.fChilds.size(); ++i) {
                String vName;
                Object vCh = this.fChilds.get(i);
                if (vCh instanceof XSourceFolder) {
                    vName = ((XSourceFolder)vCh).fName;
                    if (!pUri.regionMatches(pStart, vName, 0, vName.length())) continue;
                    int vEnd = pStart + vName.length();
                    if (pUri.length() == vEnd) {
                        return (ISrcContent)vCh;
                    }
                    if (pUri.charAt(vEnd) != '/') continue;
                    return ((XSourceFolder)vCh).findUri(pUri, vEnd + 1, pCreate);
                }
                vName = ((XSourceFile)vCh).fName;
                if (pUri.length() != pStart + vName.length() || !pUri.regionMatches(pStart, vName, 0, vName.length())) continue;
                return (ISrcContent)vCh;
            }
            if (pCreate) {
                int vIdx = pUri.indexOf(47, pStart);
                String vName = vIdx > 0 ? pUri.substring(pStart, vIdx) : pUri.substring(pStart);
                XSourceFolder vResult = new XSourceFolder(vName);
                this.fChilds.add(vResult);
                if (vIdx > 0) {
                    return vResult.findUri(pUri, vIdx + 1, true);
                }
                return vResult;
            }
            return ISrcContent.NULL;
        }
    }
}

