/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewsource;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HItemUpdatesEvent;
import com.scenari.m.bdp.item.IHItemUpdatesListener;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.HModule;
import com.scenari.m.bdp.module.viewsource.IHModuleViewSource;
import com.scenari.m.bdp.module.viewsource.IHViewSource;
import com.scenari.m.bdp.module.viewsource.WViewSourceCache;
import com.scenari.src.ISrcServer;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.mem.MemoryMgr;
import java.util.ArrayList;

public abstract class HModuleViewSourceCache
extends HModule
implements IHModuleViewSource,
IHItemUpdatesListener,
IMemoryOwner {
    protected ArrayList<WViewSourceCache> fCache = new ArrayList();

    public HModuleViewSourceCache(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule);
        MemoryMgr.registerMemoryOwner(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wRemove() {
        MemoryMgr.unregisterMemoryOwner(this);
        ArrayList<WViewSourceCache> arrayList = this.fCache;
        synchronized (arrayList) {
            for (int i = 0; i < this.fCache.size(); ++i) {
                this.fCache.get(i).wRemove();
            }
            this.fCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISrcServer hGetSourceServer(HItemDefVers pItem, boolean pModeAutoRefresh) throws Exception {
        WViewSourceCache vResult = null;
        ArrayList<WViewSourceCache> arrayList = this.fCache;
        synchronized (arrayList) {
            for (int i = 0; i < this.fCache.size(); ++i) {
                WViewSourceCache vViewSource = this.fCache.get(i);
                if (vViewSource.fItemViewSource.fUri != pItem.fUri) continue;
                if (pModeAutoRefresh && vViewSource.fViewSourceMain == null) {
                    vViewSource.wRemove();
                    vResult = this.wNewViewSource(pItem);
                    vResult.hSetViewSourceMain(vResult);
                    this.fCache.set(i, vResult);
                    continue;
                }
                if (!vViewSource.fItemViewSource.hGetModifDt().equals(pItem.hGetModifDt())) {
                    SrcFeatureRefresh.refresh(vViewSource);
                }
                return vViewSource;
            }
            vResult = this.wNewViewSource(pItem);
            if (pModeAutoRefresh) {
                vResult.hSetViewSourceMain(vResult);
            }
            pItem.hGetWorkspace().addItemUpdatesListener(pItem.fUri, this);
            this.fCache.add(vResult);
        }
        return vResult;
    }

    public final ISrcServer wCreateSubSourceServer(HItemDefVers pItem, String pCodeModuleDelegation, IHViewSource pParent) throws Exception {
        WViewSourceCache vResult = this.wNewViewSource(pItem);
        vResult.hSetViewSourceMain(pParent);
        vResult.hSetCodeModuleDeleg(pCodeModuleDelegation);
        return vResult;
    }

    public abstract WViewSourceCache wNewViewSource(HItemDefVers var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void hItemUpdated(HItemUpdatesEvent pEvent) {
        ArrayList<WViewSourceCache> arrayList = this.fCache;
        synchronized (arrayList) {
            for (int i = 0; i < this.fCache.size(); ++i) {
                WViewSourceCache vViewSource = this.fCache.get(i);
                if (vViewSource.fItemViewSource.fUri != pEvent.fUriItem) continue;
                vViewSource.wRemove();
                this.fCache.remove(i);
                if (pEvent.fTypeEvent != 1) break;
                vViewSource.fWsp.removeItemUpdatesListener(pEvent.fUriItem, this);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long freeMemory(int pPriority) throws Exception {
        int vCountToRemove = 0;
        ArrayList<WViewSourceCache> arrayList = this.fCache;
        synchronized (arrayList) {
            int vSize = this.fCache.size();
            if (vSize > 0) {
                vCountToRemove = Math.min(Math.max(vSize * pPriority / 10, 1), vSize);
                for (int i = 0; i < vCountToRemove; ++i) {
                    this.fCache.get(i).wRemove();
                }
                if (vCountToRemove == 1) {
                    this.fCache.remove(0);
                } else {
                    ArrayList<WViewSourceCache> vNewCache = new ArrayList<WViewSourceCache>(vSize - vCountToRemove + 10);
                    for (int i = vCountToRemove; i < vSize; ++i) {
                        vNewCache.add(this.fCache.get(i));
                    }
                    this.fCache = vNewCache;
                }
            }
        }
        return vCountToRemove * 10000;
    }
}

