/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewsource;

import com.scenari.m.bdp.facet.IFacet;
import com.scenari.m.bdp.item.HItemDefVersRes;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.ISgnModule;
import com.scenari.m.bdp.module.viewsource.HSourceItemMono;
import com.scenari.m.bdp.module.viewsource.HSourceItemMulti;
import com.scenari.m.bdp.module.viewsource.IHModuleViewSource;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.helpers.base.SrcContentBase;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.InputStreamByteStream;
import java.io.InputStream;

public abstract class HSourceItem {
    public static ISrcServer hGetSourceServer(HItemDefVersRes pItem, IHWorkspace pWsp, String pCodeModuleDelegation, boolean pModeAutoRefresh, boolean pOnlyIfDeleg) throws Exception {
        if (pItem.fStatus < 0) {
            return null;
        }
        SrcContentBase vResult = null;
        IHItemType vItemType = pWsp.hGetItemType(pItem.fUriSs);
        if (vItemType != null) {
            IHModule vModule;
            if (pCodeModuleDelegation != null && (vModule = vItemType.hGetModule(pCodeModuleDelegation)) != null && vModule instanceof IHModuleViewSource) {
                IHModuleViewSource vModuleView = (IHModuleViewSource)vModule;
                return vModuleView.hGetSourceServer(pItem, pModeAutoRefresh);
            }
            if (pOnlyIfDeleg) {
                return ISrcServer.NULL;
            }
            vResult = pItem.fIsFolder ? new HSourceItemMulti(pItem, pWsp) : new HSourceItemMono(pItem, pWsp);
        }
        return vResult;
    }

    public static IByteStream wTransform(HTransformParams pTransform, IHItemDef pItemDef, String pUriResDef) throws Exception {
        if (pTransform.hGetTransformType().equals("facet")) {
            ISrcNode vSrc;
            IHItemType vItemType = pItemDef.hGetWorkspace().hGetItemType(pItemDef.getUriSs());
            ISgnModule vModule = vItemType.hGetSgnModule(pTransform.hGetValueParam("facet"), pItemDef.hGetSignature());
            if (vModule != null && vModule instanceof IFacet && (vSrc = ((IFacet)vModule).getFacet(pItemDef.getSrcNode(), null, pTransform)) != null && vSrc.getContentStatus() == 1) {
                return new InputStreamByteStream(vSrc.newInputStream(false));
            }
            return null;
        }
        InputStream vInput = pItemDef.hGetWorkspace().hGetContentAccess().hReadStream(pItemDef, pUriResDef, pTransform, null);
        return vInput != null ? new InputStreamByteStream(vInput) : null;
    }
}

