/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewsource;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HItemDefVersRes;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemcontent.IHResourceDef;
import com.scenari.m.bdp.module.viewsource.HSourceItem;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.cachedobjects.ICachedObjectAspect;
import com.scenari.src.feature.cachedobjects.SrcFeatureCachedObjects;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.helpers.base.SrcContentFileBase;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSourceItemMono
extends SrcContentFileBase
implements ITransformAspect,
ISrcServer,
ICachedObjectAspect {
    public IHWorkspace fWsp = null;
    public HItemDefVers fItem = null;
    protected int fSize = -1;

    public HSourceItemMono(HItemDefVers pItem, IHWorkspace pWsp) {
        this.fItem = pItem;
        this.fWsp = pWsp;
        if (pItem instanceof HItemDefVersRes) {
            this.fSize = ((HItemDefVersRes)pItem).fLength;
        }
    }

    @Override
    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ITransformAspect.TYPE) {
            return this;
        }
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
            return this.fWsp.hGetContentAccess().hGetUrlFileFormat(this.fItem, null, null, null);
        }
        if (pDefinition == SrcFeatureCachedObjects.DOM_ASPECT_TYPE) {
            return this;
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this.fItem.getSrcNode().getAspect(IFieldsProviderAspect.TYPE);
        }
        return super.getAspect(pDefinition);
    }

    @Override
    public final ISrcContent findContentByUri(String pUri) throws Exception {
        assert (pUri != null);
        if (pUri != null && pUri.length() == 0) {
            return this;
        }
        return ISrcContent.NULL;
    }

    @Override
    public final InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        return this.fWsp.hGetContentAccess().hReadStream(this.fItem, null, null, null);
    }

    @Override
    public final int getContentSize() throws Exception {
        if (this.fSize < 0) {
            IHResourceDef vDef = this.fWsp.hGetContentAccess().hGetResourceDef(this.fItem, null, null, null);
            this.fSize = vDef != null ? vDef.hGetLength() : 0;
        }
        return this.fSize;
    }

    @Override
    public IByteStream transform(HTransformParams pTransform) throws Exception {
        return HSourceItem.wTransform(pTransform, this.fItem, null);
    }

    @Override
    public Object getCachedObject(ISrcAspectDef<ICachedObjectAspect> pCacheDef, boolean pCheckUpdates) throws Exception {
        return SrcFeatureCachedObjects.getDom(this.fWsp.findNodeByUri(this.fItem.getUri()), false);
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        return this.fItem.fModifDt.getTime();
    }
}

