/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewsource;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemcontent.IHResourceDef;
import com.scenari.m.bdp.module.viewsource.HSourceItem;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.helpers.base.SrcContentFileBase;
import com.scenari.src.helpers.base.SrcContentFolderBase;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class HSourceItemMulti
extends SrcContentFolderBase
implements ISrcServer,
ITransformAspect {
    protected IHWorkspace fWsp = null;
    protected HItemDefVers fItem = null;

    public HSourceItemMulti(HItemDefVers pItem, IHWorkspace pWsp) {
        this.fWsp = pWsp;
        this.fItem = pItem;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ITransformAspect.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
            return this.fWsp.hGetContentAccess().hGetUrlFileFormat(this.fItem, null, null, null);
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this.fItem.getSrcNode().getAspect(IFieldsProviderAspect.TYPE);
        }
        return super.getAspect(pDefinition);
    }

    public ISrcContent findContentByUri(String pUri) throws Exception {
        assert (pUri != null);
        if (pUri == null) {
            return ISrcContent.NULL;
        }
        if (pUri.length() == 0) {
            return this;
        }
        IHResourceDef vResDef = this.fWsp.hGetContentAccess().hGetResourceDef(this.fItem, pUri, null, null);
        if (vResDef == null) {
            vResDef = pUri.endsWith("/") ? this.fWsp.hGetContentAccess().hGetResourceDef(this.fItem, pUri.substring(0, pUri.length() - 1), null, null) : this.fWsp.hGetContentAccess().hGetResourceDef(this.fItem, pUri.concat("/"), null, null);
        }
        if (vResDef == null) {
            return ISrcContent.NULL;
        }
        if (vResDef.hGetUriRes().endsWith("/")) {
            return new XSourceItemFolder(vResDef);
        }
        return new XSourceItemFile(vResDef);
    }

    public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        ArrayList<String> vResult = new ArrayList<String>();
        this.fWsp.hGetContentAccess().hListUriRes(vResult, this.fItem, null, true, null);
        int i = 0;
        while (i < vResult.size()) {
            String vName;
            String vUri = (String)vResult.get(i);
            int vStatus = vUri.charAt(vUri.length() - 1) == '/' ? 2 : 1;
            String string = vName = vStatus == 1 ? vUri.substring(1) : vUri.substring(1, vUri.length() - 1);
            if (pStatusChilds == 0 || pStatusChilds == vStatus) {
                vResult.set(i++, vName);
                continue;
            }
            vResult.remove(i);
        }
        return vResult;
    }

    public IByteStream transform(HTransformParams pTransform) throws Exception {
        return HSourceItem.wTransform(pTransform, this.fItem, null);
    }

    public long getLastModifWithChildren() throws Exception {
        return this.fItem.fModifDt.getTime();
    }

    public class XSourceItemFolder
    extends SrcContentFolderBase
    implements ITransformAspect {
        IHResourceDef fResDef = null;

        public XSourceItemFolder(IHResourceDef pResDef) {
            this.fResDef = pResDef;
        }

        public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition == ITransformAspect.TYPE) {
                return this;
            }
            if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
                return HSourceItemMulti.this.fWsp.hGetContentAccess().hGetUrlFileFormat(HSourceItemMulti.this.fItem, this.fResDef.hGetUriRes(), null, null);
            }
            return super.getAspect(pDefinition);
        }

        public final List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
            ArrayList<String> vResult = new ArrayList<String>();
            String vUriParent = this.fResDef.hGetUriRes();
            HSourceItemMulti.this.fWsp.hGetContentAccess().hListUriRes(vResult, HSourceItemMulti.this.fItem, vUriParent, true, null);
            int i = 0;
            while (i < vResult.size()) {
                String vName;
                String vUri = (String)vResult.get(i);
                int vStatus = vUri.charAt(vUri.length() - 1) == '/' ? 2 : 1;
                String string = vName = vStatus == 1 ? vUri.substring(vUriParent.length()) : vUri.substring(vUriParent.length(), vUri.length() - 1);
                if (pStatusChilds == 0 || pStatusChilds == vStatus) {
                    vResult.set(i++, vName);
                    continue;
                }
                vResult.remove(i);
            }
            return vResult;
        }

        public final IByteStream transform(HTransformParams pTransform) throws Exception {
            return HSourceItem.wTransform(pTransform, HSourceItemMulti.this.fItem, this.fResDef.hGetUriRes());
        }
    }

    public class XSourceItemFile
    extends SrcContentFileBase
    implements ITransformAspect {
        IHResourceDef fResDef = null;

        public XSourceItemFile(IHResourceDef pResDef) {
            this.fResDef = pResDef;
        }

        public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition == ITransformAspect.TYPE) {
                return this;
            }
            if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
                return HSourceItemMulti.this.fWsp.hGetContentAccess().hGetUrlFileFormat(HSourceItemMulti.this.fItem, this.fResDef.hGetUriRes(), null, null);
            }
            return super.getAspect(pDefinition);
        }

        public final InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
            return HSourceItemMulti.this.fWsp.hGetContentAccess().hReadStream(HSourceItemMulti.this.fItem, this.fResDef.hGetUriRes(), null, null);
        }

        public final int getContentSize() throws Exception {
            return this.fResDef.hGetLength();
        }

        public final IByteStream transform(HTransformParams pTransform) throws Exception {
            return HSourceItem.wTransform(pTransform, HSourceItemMulti.this.fItem, this.fResDef.hGetUriRes());
        }

        public final long getLastModifWithChildren() throws Exception {
            return this.fResDef.hGetLastModif().getTime();
        }
    }
}

