/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.module.viewsource;

import com.scenari.m.bdp.item.HItemDefVers;
import com.scenari.m.bdp.item.HItemUpdatesEvent;
import com.scenari.m.bdp.item.IHItemUpdatesListener;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.module.viewsource.HModuleViewSourceCache;
import com.scenari.m.bdp.module.viewsource.IHViewSource;
import com.scenari.s.fw.utils.HIntArrayList;
import com.scenari.src.ISrcServer;
import com.scenari.src.NotAllowedException;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.refresh.IRefreshAspect;
import java.util.List;

public abstract class WViewSourceCache
implements IHItemUpdatesListener,
IHViewSource,
IRefreshAspect {
    public HItemDefVers fItemViewSource = null;
    public HModuleViewSourceCache fModule = null;
    public IHViewSource fViewSourceMain = null;
    public long fLastUpdate = 0L;
    public IHWorkspace fWsp = null;
    public String fCodeModuleDeleg = null;
    protected List<String> fListItemsInUse = null;

    public WViewSourceCache(HItemDefVers pItemFolder, HModuleViewSourceCache pModule) {
        this.fWsp = pItemFolder.hGetWorkspace();
        this.fItemViewSource = pItemFolder;
        this.fModule = pModule;
        this.fCodeModuleDeleg = this.fModule.hGetCodeModule();
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception, NotAllowedException {
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        return null;
    }

    public void hSetViewSourceMain(IHViewSource pViewSourceMain) {
        this.fViewSourceMain = pViewSourceMain;
        if (this.fViewSourceMain == this) {
            this.fLastUpdate = System.currentTimeMillis();
            this.fListItemsInUse = new HIntArrayList();
        }
    }

    public void hSetCodeModuleDeleg(String pCodeModuleDeleg) {
        this.fCodeModuleDeleg = pCodeModuleDeleg;
    }

    protected synchronized void wRemove() {
        if (this.fViewSourceMain == this) {
            for (int i = 1; i < this.fListItemsInUse.size(); ++i) {
                this.fWsp.removeItemUpdatesListener(this.fListItemsInUse.get(i), this);
            }
            this.fListItemsInUse.clear();
        }
        this.fLastUpdate = -1L;
    }

    public final void wAddItemInUse(String pUri) {
        if (this.fViewSourceMain == this) {
            if (!this.fListItemsInUse.contains(pUri)) {
                this.fListItemsInUse.add(pUri);
                this.fWsp.addItemUpdatesListener(pUri, this);
            }
        } else if (this.fViewSourceMain != null) {
            this.fViewSourceMain.wAddItemInUse(pUri);
        }
    }

    public final synchronized void hItemUpdated(HItemUpdatesEvent pEvent) {
        this.wRemove();
        this.fLastUpdate = System.currentTimeMillis();
    }

    public boolean refresh() throws Exception {
        if (this.fViewSourceMain == this) {
            this.wRemove();
            this.fLastUpdate = System.currentTimeMillis();
        }
        return true;
    }
}

