/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.batch;

import com.scenari.m.bdp.service.batch.ITask;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.serializer.simple.XmlWriterAppendable;
import eu.scenari.fw.main.ServletBase;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.universe.execframe.httpservlet.ISenderHttpResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResultBatch
implements ISenderHttpResponse {
    protected ITask fTask;

    public ResultBatch(ITask pTask) {
        this.fTask = pTask;
    }

    public void sendDialogResult(IHDialog pDialog, HttpServletRequest pRequest, HttpServletResponse pResponse) throws Exception {
        ServletBase.setHeaderNoCache(pResponse);
        ITask.StatusTask vSt = this.fTask.getStatus();
        if (vSt == ITask.StatusTask.Finished || vSt == ITask.StatusTask.Failed) {
            pResponse.setStatus(200);
            OutputStreamBlob vBuf = new OutputStreamBlob();
            XmlWriterAppendable vXmlWriter = new XmlWriterAppendable(new OutputStreamWriter((OutputStream)vBuf, "UTF-8"));
            vXmlWriter.writeHeaderXml("UTF-8");
            this.fTask.buildRichStatus(vXmlWriter);
            vXmlWriter.close();
            int vLen = vBuf.getLength();
            pResponse.setContentLength(vLen);
            pResponse.setContentType("text/xml");
            long vLastUpdt = System.currentTimeMillis();
            pResponse.setDateHeader("Last-Modified", vLastUpdt);
            pResponse.setHeader("ETag", this.xGetETag(vLen, vLastUpdt));
            vBuf.writeIn((OutputStream)pResponse.getOutputStream());
            vBuf.closeStream();
        } else {
            pResponse.setStatus(202);
            pResponse.addHeader("Content-Type", "text/plain");
            String vId = this.fTask.getId();
            int vLen = vId.length();
            pResponse.setContentLength(vLen);
            for (int i = 0; i < vLen; ++i) {
                pResponse.getOutputStream().write((int)((byte)vId.charAt(i)));
            }
        }
    }

    protected String xGetETag(int pLen, long pLastUpdate) {
        return "\"" + pLen + "-" + pLastUpdate + "\"";
    }
}

