/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.batch;

import com.scenari.m.bdp.module.genpresc.ThreadGen;
import com.scenari.m.bdp.service.batch.HSDialogBatch;
import com.scenari.m.bdp.service.batch.ITask;
import com.scenari.m.bdp.service.repos.WServiceRepos;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.IServiceData;
import com.scenari.m.co.service.IWSDialog;
import com.scenari.m.co.service.WService;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.mem.MemoryMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.wsp.repos.IRepository;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WServiceBatch
extends WService
implements IMemoryOwner {
    public static long sClearTaskTimeout = 120000L;
    protected static Random sRandom = new Random(System.currentTimeMillis());
    protected Executor fExecutor = null;
    protected IServiceData fCodeServiceRepos = IServiceData.NULL;
    protected IRepository fRepos = null;
    protected long fClearTaskTimeout = sClearTaskTimeout;
    protected Map<String, TaskDef> fTasksDef = new HashMap<String, TaskDef>();
    protected Map<String, ITask> fTasksInUse = new HashMap<String, ITask>();

    public WServiceBatch() {
        MemoryMgr.registerMemoryOwner(this);
    }

    @Override
    public final IWSDialog hNewDialog() {
        return new HSDialogBatch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITask createAndExecuteTask(HSDialogBatch pDialog, Object pStreamTask, boolean pSynchronous) throws Exception {
        TaskSaxHandler vTaskSaxHandler = new TaskSaxHandler(pDialog);
        XMLReader vXMLReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            vTaskSaxHandler.initSaxHandlerForRoot(vXMLReader);
            InputSource vSource = pStreamTask instanceof InputStream ? new InputSource((InputStream)pStreamTask) : new InputSource((Reader)pStreamTask);
            vXMLReader.parse(vSource);
            Object var8_7 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXMLReader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXMLReader);
            throw throwable;
        }
        ITask vTask = vTaskSaxHandler.fTask;
        if (vTask != null) {
            if (pSynchronous || vTask.isSynchPrefered()) {
                vTask.run();
            } else {
                Map<String, ITask> map = this.fTasksInUse;
                synchronized (map) {
                    String vId = Long.toHexString(sRandom.nextLong());
                    while (this.fTasksInUse.containsKey(vId)) {
                        vId = Long.toHexString(sRandom.nextLong());
                    }
                    vTask.setId(vId);
                    this.fTasksInUse.put(vId, vTask);
                }
                this.fExecutor.execute(vTask);
            }
        }
        return vTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITask getTask(String pId) {
        Map<String, ITask> map = this.fTasksInUse;
        synchronized (map) {
            return this.fTasksInUse.get(pId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITask> getTasksByClass(Class pClassTask) {
        ArrayList<ITask> vResult = new ArrayList<ITask>();
        Map<String, ITask> map = this.fTasksInUse;
        synchronized (map) {
            for (ITask vTask : this.fTasksInUse.values()) {
                if (!pClassTask.isAssignableFrom(vTask.getClass())) continue;
                vResult.add(vTask);
            }
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITask closeTask(String pId) throws Exception {
        Map<String, ITask> map = this.fTasksInUse;
        synchronized (map) {
            ITask vTask = this.fTasksInUse.remove(pId);
            return vTask;
        }
    }

    public synchronized IRepository getRepository(IHDialog pDialog) throws Exception {
        if (this.fRepos == null) {
            String vCode = null;
            try {
                vCode = this.fCodeServiceRepos.getString(pDialog, this, null);
                this.fRepos = ((WServiceRepos)this.hGetUnivers().hGetService(vCode)).getRepository();
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Getting repository in '%1$s' service via '%2$s' service failed.", vCode, this.hGetCode());
            }
            if (this.fRepos == null) {
                throw LogMgr.newException("Service code '%1$s' defined in service '%2$s' is missing.", vCode, this.hGetCode());
            }
        }
        return this.fRepos;
    }

    public ITask startTask(FragmentSaxHandlerBase pParentSaxHanlder, HSDialogBatch pDialog, String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        TaskDef vTaskDef = this.fTasksDef.get(pLocalName);
        if (vTaskDef != null) {
            ITask vTask = vTaskDef.getClassTask().newInstance();
            FragmentSaxHandlerBase vSubSaxHandler = vTask.initTask(vTaskDef, pDialog, pAttributes);
            if (vSubSaxHandler != null) {
                vSubSaxHandler.initSaxHandlerForChildren(pParentSaxHanlder.getXMLReader());
            }
            return vTask;
        }
        return null;
    }

    public void wSetCodeServiceRepository(IServiceData pCodeServiceRepos) throws Exception {
        this.fCodeServiceRepos = pCodeServiceRepos;
    }

    public void wAddTaskDef(TaskDef pTaskDef) throws Exception {
        this.fTasksDef.put(pTaskDef.getLocalName(), pTaskDef);
    }

    public void wSetThreadPoolSize(int pSize) {
        this.fExecutor = pSize == -2 ? ThreadGen.getExecutorService() : (pSize <= 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(pSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wRemoveService() throws Exception {
        super.wRemoveService();
        Map<String, ITask> map = this.fTasksInUse;
        synchronized (map) {
            this.fTasksInUse.clear();
        }
        MemoryMgr.unregisterMemoryOwner(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long freeMemory(int pPriority) throws Exception {
        long vCleaned = 0L;
        Map<String, ITask> map = this.fTasksInUse;
        synchronized (map) {
            long vLimit = System.currentTimeMillis() - this.fClearTaskTimeout;
            Iterator<Map.Entry<String, ITask>> vIt = this.fTasksInUse.entrySet().iterator();
            while (vIt.hasNext()) {
                Map.Entry<String, ITask> vEntry = vIt.next();
                long vEndTime = vEntry.getValue().getEndTime();
                if (vEndTime <= 0L || vEndTime >= vLimit) continue;
                vIt.remove();
                vCleaned += 500L;
            }
        }
        return vCleaned;
    }

    public class TaskSaxHandler
    extends FragmentSaxHandlerBase {
        HSDialogBatch fDialog;
        ITask fTask = null;

        public TaskSaxHandler(HSDialogBatch pDialog) {
            this.fDialog = pDialog;
        }

        protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
            this.fTask = WServiceBatch.this.startTask(this, this.fDialog, pUri, pLocalName, pQName, pAttributes);
            if (this.fTask == null) {
                throw new Exception("Task unknown : " + pLocalName);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskDef {
        protected String fLocalName = null;
        protected String fClassName = null;
        protected Class<ITask> fClassTask = null;
        protected Map<String, IServiceData> fStaticProps = null;

        public Class<ITask> getClassTask() throws Exception {
            if (this.fClassTask == null) {
                this.fClassTask = Class.forName(this.fClassName);
            }
            return this.fClassTask;
        }

        public void setClassTask(Class pClass) {
            this.fClassTask = pClass;
        }

        public String getClassName() {
            return this.fClassName;
        }

        public void setClassName(String pClassName) {
            this.fClassName = pClassName;
        }

        public String getLocalName() {
            return this.fLocalName;
        }

        public void setLocalName(String pLocalName) {
            this.fLocalName = pLocalName;
        }

        public Map getStaticProps() {
            return this.fStaticProps;
        }

        public IServiceData getStaticProps(String pKey) {
            if (this.fStaticProps == null) {
                return null;
            }
            return this.fStaticProps.get(pKey);
        }

        public void addStaticProps(String pKey, IServiceData pData) {
            if (this.fStaticProps == null) {
                this.fStaticProps = new HashMap<String, IServiceData>();
            }
            this.fStaticProps.put(pKey, pData);
        }
    }
}

