/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.batch.tasks;

import com.scenari.m.bdp.service.batch.HSDialogBatch;
import com.scenari.m.bdp.service.batch.ITask;
import com.scenari.m.bdp.service.batch.WServiceBatch;
import com.scenari.m.bdp.service.batch.tasks.TaskBase;
import com.scenari.serializer.simple.IXmlWriter;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wspfs.FsWspProvider;
import org.xml.sax.Attributes;

public class CreateWspTask
extends TaskBase {
    protected String fWspCode;
    protected String fErrorMessage = null;
    protected Exception fException = null;

    public FragmentSaxHandlerBase initTask(WServiceBatch.TaskDef pTaskDef, HSDialogBatch pBatchDialog, Attributes pAtts) {
        this.fTaskDef = pTaskDef;
        this.fDialog = pBatchDialog;
        this.fWspCode = pAtts.getValue("wspCode");
        return null;
    }

    public boolean isSynchPrefered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.xSetStatus(ITask.StatusTask.Pending);
        ITask.StatusTask vEndStatus = ITask.StatusTask.Finished;
        try {
            WServiceBatch vService = (WServiceBatch)this.fDialog.hGetService();
            IRepository vRepos = vService.getRepository(this.fDialog);
            FsWspProvider vWspProv = (FsWspProvider)vRepos.getWspProvider();
            vWspProv.hCreateWsp(this.fWspCode, null, null, null);
        }
        catch (Exception e) {
            this.fException = e;
            if (this.fErrorMessage == null) {
                this.fErrorMessage = e.getMessage();
            }
            LogMgr.publishException(e);
            vEndStatus = ITask.StatusTask.Failed;
        }
        finally {
            this.xSetStatus(vEndStatus);
        }
    }

    public void buildRichStatus(IXmlWriter pXmlWriter) throws Exception {
        pXmlWriter.writeStartTag(this.fTaskDef.getLocalName());
        pXmlWriter.writeAttribute("taskId", this.fId);
        pXmlWriter.writeAttribute("wspCode", this.fWspCode);
        pXmlWriter.writeAttribute("status", this.getStatus().name());
        if (this.fStatus == ITask.StatusTask.Failed) {
            pXmlWriter.writeEndOpenTag();
            this.xWriteError(pXmlWriter);
            pXmlWriter.writeCloseTag(this.fTaskDef.getLocalName());
        } else {
            pXmlWriter.writeEndEmptyTag();
        }
    }

    protected void xWriteError(IXmlWriter pXmlWriter) throws Exception {
        if (this.fErrorMessage != null || this.fException != null) {
            pXmlWriter.writeStartTag("error");
            if (this.fErrorMessage != null) {
                pXmlWriter.writeAttribute("message", this.fErrorMessage);
            }
            if (this.fException == null) {
                pXmlWriter.writeEndEmptyTag();
            } else {
                pXmlWriter.writeEndOpenTag();
                pXmlWriter.writeText(this.fException.toString());
                pXmlWriter.writeCloseTag("error");
            }
        }
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        return false;
    }
}

