/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.batch.tasks;

import com.scenari.m.bdp.item.HItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.genpresc.IHModuleGenPresc;
import com.scenari.m.bdp.module.genpresc.ThreadGen;
import com.scenari.m.bdp.service.batch.HSDialogBatch;
import com.scenari.m.bdp.service.batch.ITask;
import com.scenari.m.bdp.service.batch.WServiceBatch;
import com.scenari.m.bdp.service.batch.tasks.TaskBase;
import com.scenari.m.bdp.univers.support.HInstanceDefBase;
import com.scenari.m.bdp.univers.support.WInstancesMgrBdp;
import com.scenari.m.ge.generator.DestLockMgr;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.fs.mini.FsMiniFactory;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.wsp.repos.IRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class GenerateTask
extends TaskBase
implements Cloneable {
    public static final String PROP_DESTPATHROOT = "destPathRoot";
    protected String fWspCode;
    protected String fRootItemUri;
    protected String fDestPath;
    protected String fType = null;
    protected boolean fCoalesceIfPending = false;
    protected GenerateTask fParent = null;
    protected volatile GenerateTask fRedirectTask = null;
    protected List<GenerateTask> fSubGenList = null;
    protected volatile ThreadGen fThreadGen = null;
    protected String fErrorMessage = null;
    protected Exception fException = null;

    public FragmentSaxHandlerBase initTask(WServiceBatch.TaskDef pTaskDef, HSDialogBatch pBatchDialog, Attributes pAtts) {
        this.fTaskDef = pTaskDef;
        this.fDialog = pBatchDialog;
        this.fWspCode = pAtts.getValue("wspCode");
        this.fRootItemUri = pAtts.getValue("rootItemUri");
        this.fDestPath = pAtts.getValue("destPath");
        this.fType = pAtts.getValue("type");
        String vCoalesce = pAtts.getValue("coalesceIfPending");
        this.fCoalesceIfPending = vCoalesce != null && Boolean.parseBoolean(vCoalesce);
        return this.fType == null ? this : null;
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if (pLocalName == "type") {
            GenerateTask vSubGen = (GenerateTask)this.clone();
            vSubGen.fType = pAttributes.getValue("code");
            vSubGen.fParent = this;
            if (this.fSubGenList == null) {
                this.fSubGenList = new ArrayList<GenerateTask>();
            }
            this.fSubGenList.add(vSubGen);
            vSubGen.initSaxHandlerForChildren(this.getXMLReader());
        }
        return false;
    }

    public boolean isSynchPrefered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ITask.StatusTask vEndStatus;
        block20: {
            block19: {
                this.xSetStatus(ITask.StatusTask.Pending);
                vEndStatus = ITask.StatusTask.Finished;
                try {
                    try {
                        if (this.fType != null) {
                            WServiceBatch vService = (WServiceBatch)this.fDialog.hGetService();
                            IRepository vRepos = vService.getRepository(this.fDialog);
                            IHWorkspace vWsp = vRepos.getWsp(this.fWspCode, true);
                            if (vWsp == null) {
                                throw new Exception("Workspace '" + this.fWspCode + "' unknown.");
                            }
                            String vUri = SrcFeaturePaths.findUriByPath(vWsp.findNodeByUri(""), this.fRootItemUri, "", false);
                            HItemDef vItem = vWsp.hGetItemDef(vUri, null);
                            if (vItem == null) {
                                throw new Exception("Root item " + this.fRootItemUri + " in Workspace " + this.fWspCode + " is unknown.");
                            }
                            IHItemType vItemType = vWsp.hGetItemType(vItem.getUriSs());
                            IHModuleGenPresc vModulePresc = (IHModuleGenPresc)vItemType.hGetModule(this.fType);
                            if (vModulePresc == null) {
                                throw new Exception("Generator type '" + this.fType + "' for root item " + this.fRootItemUri + " in Workspace " + this.fWspCode + " is unknown.");
                            }
                            String vTypeGen = this.fType;
                            String vUriSubInst = null;
                            if (this.fParent != null) {
                                vUriSubInst = this.xBuildUriSubInst(new StringBuilder()).toString();
                            }
                            HInstanceDefBase vInstDef = vModulePresc.hIsItemInstance() ? ((WInstancesMgrBdp)vService.hGetUnivers().hGetInstancesMgr()).hCreateInstanceDefDataInItem(vWsp, vItem, vUriSubInst, true) : ((WInstancesMgrBdp)vService.hGetUnivers().hGetInstancesMgr()).hCreateInstanceDefNoData(vWsp, vItem, vTypeGen, vUriSubInst, true);
                            ISrcNode vFolderDest = this.xCreateFolderDest(vTypeGen, vUriSubInst);
                            if (DestLockMgr.get().isDestWriteLocked(vFolderDest)) {
                                if (!this.fCoalesceIfPending) throw new Exception("Generation already working in this folder destination.");
                                List<ITask> vTasks = vService.getTasksByClass(GenerateTask.class);
                                for (ITask vTask : vTasks) {
                                    GenerateTask vSame;
                                    if (vTask == this || (vSame = ((GenerateTask)vTask).lookForSameGen(this)) == null) continue;
                                    this.fRedirectTask = vSame;
                                    Object var18_20 = null;
                                    break block19;
                                }
                                if (DestLockMgr.get().isDestWriteLocked(vFolderDest)) {
                                    throw new Exception("This folder destination is locked and coalescing generators is unvailable.");
                                }
                            }
                            IGenerator vGen = vModulePresc.popGenerator();
                            vGen.setDestRoot(vFolderDest);
                            try {
                                if (vGen.initDestination()) {
                                    vGen.setProperty("callerDialog", this.fDialog);
                                    ThreadGen vThreadGen = new ThreadGen();
                                    vThreadGen.setProps(vModulePresc, vInstDef.hGetInstance(), vGen, this.fDialog.hGetUser(), null, null, null);
                                    this.fThreadGen = vThreadGen;
                                    vThreadGen.run();
                                }
                            }
                            catch (Exception e) {
                                vGen.addTrace(ILogMsg.LogType.FatalError, LogMgr.getMessage(e));
                                vGen.closeDestination(true);
                                this.fErrorMessage = "Generation failed.";
                                throw e;
                            }
                        }
                        if (this.fSubGenList != null) {
                            for (int i = 0; i < this.fSubGenList.size(); ++i) {
                                GenerateTask vSubGen = this.fSubGenList.get(i);
                                vSubGen.run();
                                if (vEndStatus != ITask.StatusTask.Finished || vSubGen.getStatus() != ITask.StatusTask.Failed) continue;
                                vEndStatus = ITask.StatusTask.Failed;
                            }
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        this.fException = e;
                        if (this.fErrorMessage == null) {
                            this.fErrorMessage = e.getMessage();
                        }
                        LogMgr.publishException(e);
                        vEndStatus = ITask.StatusTask.Failed;
                        Object var18_22 = null;
                        this.xSetStatus(vEndStatus);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_23 = null;
                    this.xSetStatus(vEndStatus);
                    throw throwable;
                }
            }
            this.xSetStatus(vEndStatus);
            return;
        }
        Object var18_21 = null;
        this.xSetStatus(vEndStatus);
    }

    protected GenerateTask lookForSameGen(GenerateTask pGenerateTask) {
        if (pGenerateTask.fRootItemUri.equals(this.fRootItemUri) && pGenerateTask.fType.equals(this.fType) && pGenerateTask.fDestPath.equals(this.fDestPath) && pGenerateTask.fWspCode.equals(this.fWspCode)) {
            return this;
        }
        if (this.fSubGenList != null) {
            for (GenerateTask vTask : this.fSubGenList) {
                GenerateTask vSame = vTask.lookForSameGen(pGenerateTask);
                if (vSame == null) continue;
                return vSame;
            }
        }
        return null;
    }

    protected StringBuilder xBuildUriSubInst(StringBuilder pBuilder) {
        if (this.fParent != null && this.fParent.fType != null) {
            this.fParent.xBuildUriSubInst(pBuilder);
            pBuilder.append("_");
        }
        if (this.fType != null) {
            pBuilder.append(this.fType);
        }
        return pBuilder;
    }

    public ITask.StatusTask getStatus() {
        if (this.fRedirectTask != null) {
            return this.fRedirectTask.getStatus();
        }
        return super.getStatus();
    }

    public void buildRichStatus(IXmlWriter pXmlWriter) throws Exception {
        if (this.fRedirectTask != null) {
            this.fRedirectTask.xBuildRichStatus(pXmlWriter, this.fId);
        } else {
            this.xBuildRichStatus(pXmlWriter, this.fId);
        }
    }

    protected void xBuildRichStatus(IXmlWriter pXmlWriter, String pIdTask) throws Exception {
        if (this.fRedirectTask != null) {
            this.fRedirectTask.xBuildRichStatus(pXmlWriter, pIdTask);
            return;
        }
        if (this.fParent == null) {
            pXmlWriter.writeStartTag(this.fTaskDef.getLocalName());
            pXmlWriter.writeAttribute("taskId", pIdTask);
            pXmlWriter.writeAttribute("wspCode", this.fWspCode);
            pXmlWriter.writeAttribute("rootItemUri", this.fRootItemUri);
            if (this.fType != null) {
                pXmlWriter.writeAttribute("type", this.fType);
            }
            pXmlWriter.writeAttribute("status", this.getStatus().name());
        } else if (this.fType != null) {
            pXmlWriter.writeStartTag("type");
            pXmlWriter.writeAttribute("code", this.fType);
            ITask.StatusTask vStatus = this.fStatus;
            pXmlWriter.writeAttribute("status", vStatus.name());
        }
        if (this.fSubGenList != null && this.fSubGenList.size() > 0) {
            pXmlWriter.writeEndOpenTag();
            this.xWriteError(pXmlWriter);
            for (int i = 0; i < this.fSubGenList.size(); ++i) {
                this.fSubGenList.get(i).buildRichStatus(pXmlWriter);
            }
            if (this.fParent == null) {
                pXmlWriter.writeCloseTag(this.fTaskDef.getLocalName());
            } else if (this.fType != null) {
                pXmlWriter.writeCloseTag("type");
            }
        } else if (this.fStatus == ITask.StatusTask.Failed) {
            pXmlWriter.writeEndOpenTag();
            this.xWriteError(pXmlWriter);
            if (this.fParent == null) {
                pXmlWriter.writeCloseTag(this.fTaskDef.getLocalName());
            } else if (this.fType != null) {
                pXmlWriter.writeCloseTag("type");
            }
        } else {
            pXmlWriter.writeEndEmptyTag();
        }
    }

    protected void xWriteError(IXmlWriter pXmlWriter) throws Exception {
        if (this.fErrorMessage != null || this.fException != null) {
            pXmlWriter.writeStartTag("error");
            if (this.fErrorMessage != null) {
                pXmlWriter.writeAttribute("message", this.fErrorMessage);
            }
            if (this.fException == null) {
                pXmlWriter.writeEndEmptyTag();
            } else {
                pXmlWriter.writeEndOpenTag();
                pXmlWriter.writeText(this.fException.toString());
                pXmlWriter.writeCloseTag("error");
            }
        }
    }

    protected ISrcNode xCreateFolderDest(String pGenType, String pUriSubInst) throws Exception {
        String vPathRoot = this.fTaskDef.getStaticProps(PROP_DESTPATHROOT).getString(this.fDialog, this.fDialog.hGetService(), null);
        File vRoot = vPathRoot.length() > 0 ? new File(vPathRoot).getCanonicalFile() : null;
        File vDest = vRoot != null ? new File(vRoot, this.fDestPath) : new File(this.fDestPath);
        vDest = pUriSubInst == null ? new File(vDest, pGenType) : new File(vDest, pUriSubInst);
        vDest = vDest.getCanonicalFile();
        if (vRoot != null && !vDest.getPath().startsWith(vRoot.getPath())) {
            throw LogMgr.newException("Destination folder is not in the destPathRoot declared in the task definition.", new String[0]);
        }
        return FsMiniFactory.newNodeFromCanonicalFile(vDest, true);
    }

    protected Object clone() throws CloneNotSupportedException {
        GenerateTask vSubTask = (GenerateTask)super.clone();
        vSubTask.fSubGenList = null;
        return vSubTask;
    }
}

