/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.batch.tasks;

import com.scenari.m.bdp.service.batch.HSDialogBatch;
import com.scenari.m.bdp.service.batch.ITask;
import com.scenari.m.bdp.service.batch.WServiceBatch;
import com.scenari.m.bdp.service.batch.tasks.TaskBase;
import com.scenari.serializer.simple.IXmlWriter;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class SequenceTask
extends TaskBase {
    protected boolean fHaltOnError = true;
    protected List<ITask> fSubGen = new ArrayList<ITask>();

    public FragmentSaxHandlerBase initTask(WServiceBatch.TaskDef pTaskDef, HSDialogBatch pBatchDialog, Attributes pAtts) {
        this.fTaskDef = pTaskDef;
        this.fDialog = pBatchDialog;
        String vStop = pAtts.getValue("haltOnError");
        this.fHaltOnError = vStop == null || !vStop.equals("false");
        return this;
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        ITask vTask = ((WServiceBatch)this.fDialog.hGetService()).startTask(this, this.fDialog, pUri, pLocalName, pQName, pAttributes);
        if (vTask != null) {
            this.fSubGen.add(vTask);
        }
        return false;
    }

    public boolean isSynchPrefered() {
        for (int i = 0; i < this.fSubGen.size(); ++i) {
            if (this.fSubGen.get(i).isSynchPrefered()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.xSetStatus(ITask.StatusTask.Pending);
        ITask.StatusTask vEndStatus = ITask.StatusTask.Finished;
        try {
            try {
                for (int i = 0; i < this.fSubGen.size(); ++i) {
                    ITask vSubGen = this.fSubGen.get(i);
                    vSubGen.run();
                    if (vEndStatus != ITask.StatusTask.Finished || vSubGen.getStatus() != ITask.StatusTask.Failed) continue;
                    vEndStatus = ITask.StatusTask.Failed;
                    if (this.fHaltOnError) break;
                }
                Object var5_5 = null;
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                vEndStatus = ITask.StatusTask.Failed;
                Object var5_6 = null;
                this.xSetStatus(vEndStatus);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.xSetStatus(vEndStatus);
            throw throwable;
        }
        this.xSetStatus(vEndStatus);
    }

    public void buildRichStatus(IXmlWriter pXmlWriter) throws Exception {
        pXmlWriter.writeStartTag(this.fTaskDef.getLocalName());
        pXmlWriter.writeAttribute("taskId", this.fId);
        pXmlWriter.writeAttribute("status", this.getStatus().name());
        pXmlWriter.writeEndOpenTag();
        for (int i = 0; i < this.fSubGen.size(); ++i) {
            this.fSubGen.get(i).buildRichStatus(pXmlWriter);
        }
        pXmlWriter.writeCloseTag(this.fTaskDef.getLocalName());
    }

    public boolean isHaltOnError() {
        return this.fHaltOnError;
    }

    public void setHaltOnError(boolean pHaltOnError) {
        this.fHaltOnError = pHaltOnError;
    }
}

