/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.service.viewdav;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.service.viewdav.ServiceViewDav;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.WResultatError;
import com.scenari.m.co.dialog.webdav.WResultatGet;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.service.sourcedav.HSDialogSourceDav;
import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.util.ZipperSrcFreeEncoding;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.wsp.repos.IRepository;

public class DialogViewDav
extends HSDialogSourceDav {
    public static final String CDACTION_GETASZIP = "GetAsZip";
    public static String sPage = "/serv/viewdav.jsp";

    public DialogViewDav(IWService pService) {
        super(pService);
        this.fPageResultatNonDav = sPage;
    }

    public ISrcNode getSource() {
        return this.fSource;
    }

    public boolean hNeedAuthentification() {
        return true;
    }

    protected int xLoadSource() throws Exception {
        if (this.fSource == null) {
            this.fSource = this.xParseUrl(this.fParamEntree.fPathRessource);
        }
        return this.fSource.getContentStatus();
    }

    protected ISrcNode xGetRoot() throws Exception {
        if (this.fSource == null) {
            this.fSource = this.xParseUrl(this.fParamEntree.fPathRessource);
        }
        return this.fSource.findNodeByUri("");
    }

    protected String xGetPathFromRoot() throws Exception {
        if (this.fSource == null) {
            this.fSource = this.xParseUrl(this.fParamEntree.fPathRessource);
        }
        return this.fSource.getSrcUri();
    }

    protected String xGetPublicRootUrl() throws Exception {
        return ((ServiceViewDav)this.fService).hGetUrlService(this);
    }

    protected IHDialog xExecute() throws Exception {
        if (CDACTION_GETASZIP.equals(this.hGetCdAction())) {
            this.fSource = this.xParseUrl(this.fParamEntree.fPathRessource);
            int vStatus = this.fSource.getContentStatus();
            if (vStatus == 1 || vStatus == 2) {
                WResultatGet vResult = new WResultatGet();
                String vRootFolder = this.fSource.getSrcUri().length() == 0 ? null : this.fSource.getSrcName();
                vResult.hSetStream(new ZipperSrcFreeEncoding(this.fSource, vRootFolder, null));
                vResult.hSetDownloadNameFile(this.fSource.getSrcName().concat(".zip"));
                vResult.hSetContentType("application/zip");
                long vDate = this.fSource.getLastModif();
                vResult.hSetLastModifDate(vDate > 0L ? vDate : 0L);
                this.fPageResultatDav = vResult;
            } else {
                this.fPageResultatDav = new WResultatError(409);
            }
            return this;
        }
        return super.xExecute();
    }

    protected String xGetPageResultatErreur() {
        return sPage;
    }

    protected ISrcNode xParseUrl(String pUrl) throws Exception {
        String vUrl = pUrl;
        IRepository vRepos = ((ServiceViewDav)this.fService).hGetRepository(this);
        if (vUrl == null || vUrl.length() == 0 || vUrl.length() == 1 && vUrl.charAt(0) == '/') {
            throw LogMgr.newException("No workspace defined in url.", new String[0]);
        }
        if (vUrl.charAt(vUrl.length() - 1) == '/') {
            vUrl = vUrl.substring(0, vUrl.length() - 1);
        }
        int vOffStart = vUrl.charAt(0) == '/' ? 1 : 0;
        int vOffs = vUrl.indexOf(47, vOffStart);
        String vCodeWsp = null;
        if (vOffs > 0) {
            vCodeWsp = vUrl.substring(vOffStart, vOffs);
            vOffStart = vOffs;
        } else {
            vCodeWsp = vOffStart > 0 ? vUrl.substring(vOffStart) : vUrl;
            vOffStart = vUrl.length();
        }
        IHWorkspace vWorkspace = vRepos.getWsp(vCodeWsp, true);
        if (vWorkspace == null) {
            throw LogMgr.newException("Workspace '" + vCodeWsp + "' unknown.", new String[0]);
        }
        if (vOffStart >= vUrl.length()) {
            return vWorkspace.findNodeByUri("");
        }
        return vWorkspace.findNodeByUri(vUrl.substring(vOffStart));
    }

    protected ISrcNode xGetDst(String pDstPath) throws Exception {
        return this.xParseUrl(pDstPath);
    }

    protected boolean xIsDstInSrc(ISrcNode pDst, ISrcNode pSource) {
        if (((IWspSrc)pDst).getWorkspace() != ((IWspSrc)pSource).getWorkspace()) {
            return false;
        }
        return super.xIsDstInSrc(pDst, pSource);
    }
}

