/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.source;

import com.scenari.m.bdp.item.HItemDefVersRes;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.module.viewsource.HSourceItem;
import com.scenari.m.bdp.source.WSourceBdp;
import com.scenari.m.bdp.source.XSourceBdpParams;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import com.scenari.src.helpers.lnk.ISrcNodeLnk;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;
import java.util.List;

public class WSourceBdpItem
extends WSourceBdp
implements ITransformAspect,
IRefreshAspect,
IFieldsProviderAspect {
    protected String fSpace = null;
    protected String fCode = null;
    protected String fSubUri;
    protected ISrcContent fElem = null;
    protected HItemDefVersRes fItem = null;

    public WSourceBdpItem(XSourceBdpParams pParams, IHWorkspace pWsp, String pSpace, String pCode, String pSubUri) throws Exception {
        super(pParams);
        this.fWsp = pWsp;
        this.fSpace = pSpace;
        this.fCode = pCode;
        this.fSubUri = pSubUri == null ? "" : pSubUri;
    }

    public WSourceBdpItem(XSourceBdpParams pParams, IHWorkspace pWsp, String pSpace, String pCode, String pSubUri, HItemDefVersRes pItem) throws Exception {
        super(pParams);
        this.fWsp = pWsp;
        this.fSpace = pSpace;
        this.fCode = pCode;
        this.fSubUri = pSubUri == null ? "" : pSubUri;
        this.fItem = pItem;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        Object vResult = super.getAspect(pDefinition);
        if (vResult != null) {
            return vResult;
        }
        if (pDefinition == ITransformAspect.TYPE) {
            return this;
        }
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this;
        }
        if (!pDefinition.isBijection()) {
            this.xLoadElem();
            return this.fElem.getAspect(pDefinition);
        }
        return null;
    }

    public boolean refresh() throws Exception {
        this.fElem = null;
        if (this.fSubUri == "" || !this.fParams.fRefreshOnItemOnly) {
            this.fItem = null;
        } else {
            WSourceBdpItem vSourceItem = this;
            while (vSourceItem.fParent != null && vSourceItem.fParent instanceof WSourceBdpItem) {
                vSourceItem = (WSourceBdpItem)vSourceItem.fParent;
            }
            vSourceItem.xLoadElem();
            this.fItem = vSourceItem.fItem;
        }
        if (this.fItem == null || !this.fParams.fModeRefreshAuto) {
            if (this.fItem == null) {
                this.fItem = this.fWsp.hGetItemDefVersRes(this.fSpace, this.fCode, null);
            }
            if (this.fItem == null) {
                this.fElem = ISrcContent.NULL;
            } else {
                ISrcServer vServer = HSourceItem.hGetSourceServer(this.fItem, this.fWsp, this.fParams.fCodeModuleDeleg, this.fParams.fModeRefreshAuto, this.fParams.fShowOnlyItemWithModuleDeleg);
                if (vServer == null) {
                    this.fElem = ISrcContent.NULL;
                } else {
                    SrcFeatureRefresh.refresh(vServer);
                    this.fElem = vServer.findContentByUri(this.fSubUri);
                }
            }
        }
        return true;
    }

    protected final void xLoadElem() throws Exception {
        if (this.fElem == null) {
            ISrcServer vServer;
            if (this.fItem == null) {
                this.fItem = this.fWsp.hGetItemDefVersRes(this.fSpace, this.fCode, null);
            }
            this.fElem = this.fItem == null ? ISrcContent.NULL : ((vServer = HSourceItem.hGetSourceServer(this.fItem, this.fWsp, this.fParams.fCodeModuleDeleg, this.fParams.fModeRefreshAuto, this.fParams.fShowOnlyItemWithModuleDeleg)) == null ? ISrcContent.NULL : vServer.findContentByUri(this.fSubUri));
        }
    }

    protected final ISrcNodeLnk findChild(String pName) throws Exception {
        String vSubUri = this.fSubUri == "" ? "/".concat(pName) : new StringBuilder(this.fSubUri.length() + 1 + pName.length()).append(this.fSubUri).append('/').append(pName).toString();
        return new WSourceBdpItem(this.fParams, this.fWsp, this.fSpace, this.fCode, vSubUri, this.fItem).setNodeLnkParent(this);
    }

    protected final String getOriginalSrcName() {
        if (this.fSubUri == "") {
            return this.fCode;
        }
        int vOffs = this.fSubUri.lastIndexOf(47);
        return vOffs >= 0 ? this.fSubUri.substring(vOffs + 1) : this.fSubUri;
    }

    public final InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        this.xLoadElem();
        return this.fElem.newInputStream(pEnsureBuffered);
    }

    public final List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        this.xLoadElem();
        return this.fElem.listChildrenNames(null, pStatusChilds);
    }

    public final long getLastModif() throws Exception {
        this.xLoadElem();
        return this.fElem.getLastModif();
    }

    public final long getLastModifWithChildren() throws Exception {
        this.xLoadElem();
        return this.fElem.getLastModifWithChildren();
    }

    public final int getContentSize() throws Exception {
        this.xLoadElem();
        return this.fElem.getContentSize();
    }

    public final int getContentStatus() throws Exception {
        this.xLoadElem();
        return this.fElem.getContentStatus();
    }

    public final IByteStream transform(HTransformParams pTransform) throws Exception {
        this.xLoadElem();
        return SrcFeatureTransform.transformContent(this.fElem, pTransform);
    }

    public void fillFields(IFieldsCollector pFieldsToCollect) throws Exception {
        this.xLoadElem();
        SrcFeatureAlternateUrl.fillFields(this.fElem, pFieldsToCollect);
        IFieldsProviderAspect vFieldsProvider = this.fElem.getAspect(IFieldsProviderAspect.TYPE);
        if (vFieldsProvider != null) {
            vFieldsProvider.fillFields(pFieldsToCollect);
        }
    }
}

