/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.source.pub.fs2;

import com.scenari.m.bdp.item.fs.HRepositoryFs2;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.s.co.sourcerel.fs.HSourceRelFsWithRights;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.helpers.lnk.ISrcNodeLnk;
import com.scenari.src.helpers.lnk.SrcNodeLnkBase;
import com.scenari.src.helpers.lnk.SrcNodeLnkFrontEndRestrictRights;
import com.scenari.src.system.ISrcSystem;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.repos.IRepositoryHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSourcePubFs2Root
extends SrcNodeLnkBase
implements Cloneable,
ISrcSystem {
    protected String fCdServiceRepos = null;
    protected IWUnivers fUniverse = null;
    protected HRepositoryFs2 fRepository = null;
    protected String fNameFolder = null;

    public WSourcePubFs2Root(String pNameFolder) {
        this.fNameFolder = pNameFolder == null || pNameFolder.length() == 0 ? "" : pNameFolder;
    }

    protected final synchronized HRepositoryFs2 wGetRepository() throws Exception {
        if (this.fRepository == null) {
            IWService vService = this.fUniverse.hGetService(this.fCdServiceRepos);
            if (vService == null) {
                throw LogMgr.newException("Le code du service de repository '" + this.fCdServiceRepos + "' d\u00e9fini dans l'espace source n'est pas d\u00e9clar\u00e9.", new String[0]);
            }
            if (!(vService instanceof IRepositoryHandler)) {
                throw LogMgr.newException("Le code du service de repository '" + this.fCdServiceRepos + "' d\u00e9fini dans l'espace source n'est pas du type '" + IRepositoryHandler.class.getName() + "'.", new String[0]);
            }
            this.fRepository = (HRepositoryFs2)((IRepositoryHandler)((Object)vService)).getRepository();
        }
        return this.fRepository;
    }

    @Override
    protected final ISrcNodeLnk findChild(String pName) throws Exception {
        IWspDefinition vWspDef = this.wGetRepository().getWspProvider().getWspDefinition(pName);
        if (vWspDef != null) {
            ISrcNode vSrc = vWspDef.getSrcRootGen();
            String vFilePath = SrcFeatureAlternateUrl.getFilePath(vSrc);
            if (vFilePath != null) {
                return new HSourceRelFsWithRights(vFilePath, vWspDef.getWspCode(), 3).setNodeLnkParent(this);
            }
            return new SrcNodeLnkFrontEndRestrictRights(vSrc, vWspDef.getWspCode(), 3).setNodeLnkParent(this);
        }
        return ISrcNodeLnk.NULL;
    }

    protected final int wGetStatus() throws Exception {
        return 2;
    }

    @Override
    protected final String getOriginalSrcName() {
        return this.fNameFolder;
    }

    @Override
    public final List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        for (IWspDefinition vWspDef : this.wGetRepository().getWspProvider()) {
            ISrcNode vSrc;
            String vFilePath;
            if (pListToAppend == null) {
                pListToAppend = new ArrayList<ISrcNode>();
            }
            if ((vFilePath = SrcFeatureAlternateUrl.getFilePath(vSrc = vWspDef.getSrcRootGen())) != null) {
                pListToAppend.add(new HSourceRelFsWithRights(vFilePath, vWspDef.getWspCode(), 3).setNodeLnkParent(this));
                continue;
            }
            pListToAppend.add(new SrcNodeLnkFrontEndRestrictRights(vSrc, vWspDef.getWspCode(), 3).setNodeLnkParent(this));
        }
        return pListToAppend;
    }

    @Override
    public final InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        return null;
    }

    public final List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        if (pStatusChilds == 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> vList = new ArrayList<String>();
        for (IWspDefinition vWspDef : this.wGetRepository().getWspProvider()) {
            vList.add(vWspDef.getWspCode());
        }
        return vList;
    }

    @Override
    public final long getLastModifWithChildren() throws Exception {
        return -1L;
    }

    @Override
    public final int getContentSize() throws Exception {
        return 0;
    }

    @Override
    public final int getContentStatus() throws Exception {
        return 2;
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        return null;
    }

    @Override
    public boolean createAsFile() throws Exception {
        return false;
    }

    @Override
    public boolean createAsFolder() throws Exception {
        return false;
    }

    @Override
    public boolean removeSrc() throws Exception {
        return false;
    }

    @Override
    public Object getOwner() {
        return this.fUniverse;
    }

    @Override
    public ISrcNode getStartSrcNode() {
        return this;
    }

    @Override
    public ISrcServer getSrcServer() throws Exception {
        return this;
    }

    @Override
    public void publishDefinition(ContentHandler pHandler) throws SAXException {
        throw new SAXException("not implemented");
    }

    @Override
    public void setOwner(Object pOwner) {
        this.fUniverse = (IWUnivers)pOwner;
    }
}

