/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.univers.support;

import com.scenari.m.bdp.item.HItemUpdatesEvent;
import com.scenari.m.bdp.item.HQCode;
import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHItemUpdatesListener;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.genpresc.IHModuleGenPresc;
import com.scenari.m.bdp.module.prop.HModuleProp;
import com.scenari.m.bdp.univers.support.HInstanceDefBase;
import com.scenari.m.bdp.univers.support.WInstancesMgrBdp;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.InputStream;

public class HInstanceDefDataInItem
extends HInstanceDefBase
implements IHItemUpdatesListener {
    protected ISrcNode fDataItemNode;
    protected volatile Thread fSavePending = null;
    private static final long serialVersionUID = 8467661411788102226L;

    public HInstanceDefDataInItem(WInstancesMgrBdp pInstancesMgr, String pIdInst) throws Exception {
        super(pInstancesMgr, pIdInst);
        this.xLoad(true);
        this.fWsp.addItemUpdatesListener(this.fDataItemNode.getSrcUri(), this);
    }

    public HInstanceDefDataInItem(WInstancesMgrBdp pInstancesMgr, String pIdInst, IHWorkspace pWsp, IHItemDef pItemDef, String pUriSubInst, int pType) throws Exception {
        super(pInstancesMgr);
        this.fIdInst = pIdInst;
        this.fWsp = pWsp;
        this.fDataItemNode = pItemDef.getSrcNode();
        this.fUriSubInst = pUriSubInst;
        this.xLoad(pType > 1);
        if (pType == 3) {
            this.fWsp.addItemUpdatesListener(this.fDataItemNode.getSrcUri(), this);
        }
    }

    protected final void xSetIdInst(String pId) throws Exception {
        if (this.fIdInst == null) {
            try {
                String vCd;
                this.fIdInst = pId;
                int vBegin = this.fIdInst.indexOf(42, 0) + 1;
                int vEnd = this.fIdInst.indexOf(42, vBegin + 1);
                String vWspCd = this.fIdInst.substring(vBegin, vEnd);
                this.fWsp = this.fInstancesMgr.fRepos.getWsp(vWspCd, true);
                vBegin = vEnd + 1;
                vEnd = this.fIdInst.indexOf(42, vBegin);
                String vSp = this.fIdInst.substring(vBegin, vEnd).replace('.', '/');
                vBegin = vEnd + 1;
                vEnd = this.fIdInst.indexOf(42, vBegin);
                if (vEnd > 0) {
                    vCd = this.fIdInst.substring(vBegin, vEnd);
                    this.fUriSubInst = this.fIdInst.substring(vEnd + 1);
                } else {
                    vCd = this.fIdInst.substring(vBegin);
                    this.fUriSubInst = null;
                }
                this.fDataItemNode = this.fWsp.findNodeByUri(HQCode.hGetUri(vSp, vCd));
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la r\u00e9cup\u00e9ration de l'instance : " + pId, new String[0]);
            }
        } else {
            throw LogMgr.newException("L'instance \u00e0 g\u00e9n\u00e9rer d'id " + this.fIdInst + " a d\u00e9j\u00e0 \u00e9t\u00e9 cr\u00e9\u00e9e. Il est impossible de modifier son ID (nouvelle valeur='" + pId + "')", new String[0]);
        }
    }

    public final void wSetPrescription(String pSpPresc, String pCdPresc, String pCdGen) throws Exception {
        if (this.fInst != null) {
            throw LogMgr.newException("Impossible de modifier la prescription d'un support dont l'instance a \u00e9t\u00e9 charg\u00e9e.", new String[0]);
        }
        IHItemDef vItemDef = this.fDataItemNode.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
        this.fSpPresc = pSpPresc;
        if (this.fSpPresc == null || this.fSpPresc.length() == 0) {
            this.fSpPresc = HQCode.hGetSpaceFromUri(vItemDef.getUri());
        }
        this.fCdPresc = pCdPresc;
        if (pCdGen != null) {
            this.fCdGenPresc = pCdGen;
        }
        this.fItemDefPresc = this.fSpPresc != null && this.fCdPresc != null ? this.fWsp.hGetItemDef(HQCode.hGetUri(this.fSpPresc, this.fCdPresc), null) : null;
        if (this.fItemDefPresc != null) {
            this.fModuleGen = null;
            if (this.fUriSubInst != null) {
                IHItemType vItemType = this.fWsp.hGetItemType(vItemDef.getUriSs());
                if (vItemType != null) {
                    this.fModuleGen = (IHModuleGenPresc)vItemType.hGetModule(HInstanceDefDataInItem.getCdGenFromUriSubInst(this.fUriSubInst));
                }
            } else if (this.fCdGenPresc != null) {
                LogMgr.publishException("fCdGenPresc in HInstanceDefDataInItem always in use : " + this.fCdGenPresc, ILogMsg.LogType.Info, new String[0]);
                IHItemType vItemTypePresc = this.fWsp.hGetItemType(this.fItemDefPresc.getUriSs());
                if (vItemTypePresc != null) {
                    this.fModuleGen = (IHModuleGenPresc)vItemTypePresc.hGetModule(this.fCdGenPresc);
                }
            } else {
                IHItemType vItemType = this.fWsp.hGetItemType(vItemDef.getUriSs());
                if (vItemType != null) {
                    IHModule vModuleCd = vItemType.hGetModule("mainGeneratorCd");
                    if (vModuleCd != null && vModuleCd instanceof HModuleProp) {
                        this.fModuleGen = (IHModuleGenPresc)vItemType.hGetModule(((HModuleProp)vModuleCd).getValue());
                    } else if (this.fCdGenSupport != null) {
                        this.fModuleGen = (IHModuleGenPresc)vItemType.hGetModule(this.fCdGenSupport);
                    }
                }
            }
        }
    }

    protected final synchronized void xLoad(boolean pLoadInstance) throws Exception {
        try {
            this.xLoadStream(this.xGetOriginalData(), pLoadInstance);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec au chargement de l'instance.", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void hSave(IHDialog pDialog) throws Exception {
        OutputStreamBlob vBuf = new OutputStreamBlob();
        try {
            this.fSavePending = Thread.currentThread();
            this.xWriteData(vBuf);
            SrcFeatureStreams.writeFrom(this.fDataItemNode, vBuf.getInputStream(false));
            Object var4_3 = null;
            this.fSavePending = null;
            vBuf.closeStream();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fSavePending = null;
            vBuf.closeStream();
            throw throwable;
        }
    }

    protected InputStream xGetOriginalData() throws Exception {
        return this.fDataItemNode.newInputStream(true);
    }

    protected final void xUnload() {
        if (this.fDataItemNode != null) {
            this.fWsp.removeItemUpdatesListener(this.fDataItemNode.getSrcUri(), this);
        }
    }

    public void hItemUpdated(HItemUpdatesEvent pEvent) {
        Thread vSavePending = this.fSavePending;
        if (vSavePending == null || vSavePending != Thread.currentThread()) {
            try {
                this.fInstancesMgr.hPurgeInstanceById(this.fIdInst);
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }
}

