/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.bdp.univers.support;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.instance.IHAgentSaxHandler;
import com.scenari.m.co.instance.IWInstFormation;
import com.scenari.serializer.simple.IXmlWriter;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.DomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HInstanceSaxHandlerWsp
extends DefaultHandler {
    public static String TAG_AGENT = "agent";
    public static String TAG_AGENT_ATT_PATH = "_path";
    public static String TAG_AGENT_ATT_SRC = "_src";
    public static String TAG_AGENT_ATT_SUFFIX = "_suffix";
    private IWInstFormation fInst = null;
    private IHAgentSaxHandler fCurrentSaxHandlerDelegue = null;
    private int fHierInAgent = 0;
    private Element fCurrentElement = null;

    public static void hSerialize(IWInstFormation pInst, IXmlWriter pWriter) throws Exception {
        Element vElemCo;
        NamedNodeMap vAtts;
        int vNbAtts;
        Document vDoc = (Document)((Object)pInst);
        Element vRoot = vDoc.getDocumentElement();
        Element vElemEtat = DomHelper.getFirstElementChild(vRoot, "etat");
        pWriter.writeOpenTag("in");
        if (vElemEtat != null && (vNbAtts = (vAtts = vElemEtat.getAttributes()).getLength()) > 0) {
            pWriter.writeStartTag("etat");
            for (int i = 0; i < vNbAtts; ++i) {
                Node vAtt = vAtts.item(i);
                pWriter.writeAttribute(vAtt.getNodeName(), vAtt.getNodeValue());
            }
            pWriter.writeEndEmptyTag();
        }
        if ((vElemCo = DomHelper.getFirstElementChild(vRoot, "co")) != null) {
            for (Node vNode = vElemCo.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (!(vNode instanceof IWAgent)) continue;
                HInstanceSaxHandlerWsp.xSerializeAgent(vNode, pWriter);
            }
        }
        pWriter.writeCloseTag("in");
    }

    private static void xSerializeAgent(Node pAgent, IXmlWriter pWriter) throws Exception {
        boolean vHasProduction = false;
        for (Node vChild = pAgent.getFirstChild(); vChild != null; vChild = vChild.getNextSibling()) {
            if (vChild instanceof IWAgent) {
                HInstanceSaxHandlerWsp.xSerializeAgent(vChild, pWriter);
                continue;
            }
            vHasProduction = true;
        }
        if (vHasProduction || pAgent.hasAttributes()) {
            pWriter.writeStartTag(TAG_AGENT);
            IWAgent vAgt = (IWAgent)((Object)pAgent);
            String vPath = vAgt.hGetAgentPath();
            if (vPath.startsWith("@@")) {
                pWriter.writeAttribute(TAG_AGENT_ATT_PATH, vPath);
            } else {
                String vUri = vAgt.hGetComposant().hGetDocSource().getSrcUri();
                String vIdAgt = vAgt.hGetComposant().hGetUnivers().hGetContenuMgr().hGetIdSrcFromUri(vUri, vAgt);
                int vLenIdAgt = vIdAgt.length();
                String vCdAgtPrinc = vAgt.hGetAgentPrinc().hGetCode();
                if (vCdAgtPrinc.startsWith(vIdAgt) && (vLenIdAgt == vCdAgtPrinc.length() || vCdAgtPrinc.charAt(vLenIdAgt) == '_')) {
                    int vRelPath;
                    int vRelUri = vUri.indexOf(47, 1);
                    pWriter.writeAttribute(TAG_AGENT_ATT_SRC, vUri.substring(vRelUri));
                    if (vCdAgtPrinc.length() > vLenIdAgt) {
                        pWriter.writeAttribute(TAG_AGENT_ATT_SUFFIX, vCdAgtPrinc.substring(vLenIdAgt));
                    }
                    if ((vRelPath = vPath.indexOf(47)) > 0) {
                        pWriter.writeAttribute(TAG_AGENT_ATT_PATH, vPath.substring(vRelPath + 1));
                    }
                } else {
                    pWriter.writeAttribute(TAG_AGENT_ATT_PATH, vPath);
                }
            }
            NamedNodeMap vAtts = ((Element)pAgent).getAttributes();
            for (int i = 0; i < vAtts.getLength(); ++i) {
                Node vAtt = vAtts.item(i);
                if (!vAtt.getNodeName().startsWith("_")) {
                    pWriter.writeAttribute(vAtt.getNodeName(), vAtt.getNodeValue());
                    continue;
                }
                LogMgr.publishException("Un attribut d'un agent commence par un '_' (" + vAtt.getNodeName() + ") : il ne peut \u00eatre s\u00e9rialis\u00e9.", new String[0]);
            }
            if (!vHasProduction) {
                pWriter.writeEndEmptyTag();
            } else {
                for (Node vProd = pAgent.getFirstChild(); vProd != null; vProd = vProd.getNextSibling()) {
                    if (vProd instanceof IWAgent) continue;
                    HInstanceSaxHandlerWsp.xWriteNode(vProd, pWriter);
                }
                pWriter.writeCloseTag(TAG_AGENT);
            }
        }
    }

    private static void xWriteNode(Node pNode, IXmlWriter pWriter) throws Exception {
        switch (pNode.getNodeType()) {
            case 3: 
            case 4: {
                pWriter.writeText(pNode.getNodeValue());
                break;
            }
            case 1: {
                Node vChild;
                NamedNodeMap vAtts = pNode.getAttributes();
                pWriter.writeStartTag(pNode.getNodeName());
                if (vAtts.getLength() > 0) {
                    for (int i = 0; i < vAtts.getLength(); ++i) {
                        Node vNode = vAtts.item(i);
                        pWriter.writeAttribute(vNode.getNodeName(), vNode.getNodeValue());
                    }
                }
                if ((vChild = pNode.getFirstChild()) != null) {
                    pWriter.writeEndOpenTag();
                    while (vChild != null) {
                        HInstanceSaxHandlerWsp.xWriteNode(vChild, pWriter);
                        vChild = vChild.getNextSibling();
                    }
                    pWriter.writeCloseTag(pNode.getNodeName());
                    break;
                }
                pWriter.writeEndEmptyTag();
                break;
            }
            default: {
                LogMgr.publishException("Alerte : le type de noeud '" + pNode.getNodeType() + "' n'est pas g\u00e9r\u00e9 dans la s\u00e9rialisation de l'instance.", new String[0]);
            }
        }
    }

    public HInstanceSaxHandlerWsp(IWInstFormation pDoc) {
        this.fInst = pDoc;
    }

    public void characters(char[] pChars, int pStart, int pLength) throws SAXException {
        if (this.fHierInAgent > 0) {
            if (this.fCurrentSaxHandlerDelegue != null) {
                this.fCurrentSaxHandlerDelegue.characters(pChars, pStart, pLength);
            } else if (this.fCurrentElement != null) {
                Text vText = this.fCurrentElement.getOwnerDocument().createTextNode(new String(pChars, pStart, pLength));
                this.fCurrentElement.appendChild(vText);
            }
        }
    }

    public void endElement(String pNs, String pLocalName, String pQName) throws SAXException {
        if (this.fHierInAgent > 0) {
            if (this.fCurrentSaxHandlerDelegue != null) {
                this.fCurrentSaxHandlerDelegue.endElement(pNs, pLocalName, pQName);
            } else if (this.fCurrentElement != null) {
                this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
            }
            --this.fHierInAgent;
        }
    }

    public void startElement(String pNs, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
        block17: {
            block18: {
                int vNbAtts;
                block15: {
                    block16: {
                        if (this.fHierInAgent <= 0) break block15;
                        if (this.fCurrentSaxHandlerDelegue == null) break block16;
                        this.fCurrentSaxHandlerDelegue.startElement(pNs, pLocalName, pQName, pAtts);
                        break block17;
                    }
                    if (this.fCurrentElement == null) break block17;
                    Element vChild = this.fCurrentElement.getOwnerDocument().createElement(pLocalName);
                    this.fCurrentElement.appendChild(vChild);
                    this.fCurrentElement = vChild;
                    ++this.fHierInAgent;
                    int vNbAtts2 = pAtts.getLength();
                    for (int i = 0; i < vNbAtts2; ++i) {
                        this.fCurrentElement.setAttribute(pAtts.getLocalName(i), pAtts.getValue(i));
                    }
                    break block17;
                }
                if (!TAG_AGENT.equals(pLocalName)) break block18;
                this.fHierInAgent = 1;
                String vSrc = pAtts.getValue(TAG_AGENT_ATT_SRC);
                String vPath = pAtts.getValue(TAG_AGENT_ATT_PATH);
                this.fCurrentElement = null;
                IWAgent vAgent = null;
                if (vSrc != null) {
                    try {
                        IWAgent vAgtRoot = this.fInst.hGetAgentRoot();
                        String vUri = vAgtRoot.hGetComposant().hGetDocSource().getSrcUri();
                        vUri = vUri.substring(0, vUri.indexOf(47, 1)).concat(vSrc);
                        String vId = this.fInst.hGetPrescription().hGetUnivers().hGetContenuMgr().hGetIdSrcFromUri(vUri, vAgtRoot);
                        String vSuffix = pAtts.getValue(TAG_AGENT_ATT_SUFFIX);
                        if (vSuffix != null) {
                            vId = vId.concat(vSuffix);
                        }
                        if ((vAgent = this.fInst.hGetAgentPrinc(vId)) != null && vPath != null) {
                            vAgent = vAgent.hGetAgentParRef(vPath);
                        }
                    }
                    catch (Exception e) {
                        vAgent = null;
                    }
                } else if (vPath != null) {
                    try {
                        vAgent = this.fInst.hGetAgentParRef(vPath);
                    }
                    catch (Exception e) {
                        vAgent = null;
                    }
                }
                if (vAgent == null) break block17;
                this.fCurrentElement = vAgent.hGetElementRoot();
                this.fCurrentSaxHandlerDelegue = vAgent.wPersonalizeAgentSaxHandler(pAtts);
                if (this.fCurrentSaxHandlerDelegue == null && (vNbAtts = pAtts.getLength()) > 1) {
                    for (int i = 0; i < vNbAtts; ++i) {
                        if (pAtts.getLocalName(i).startsWith("_")) continue;
                        this.fCurrentElement.setAttribute(pAtts.getLocalName(i), pAtts.getValue(i));
                    }
                }
                break block17;
            }
            if (!"in".equals(pLocalName) && "etat".equals(pLocalName)) {
                for (int i = 0; i < pAtts.getLength(); ++i) {
                    this.fInst.hSetEtat(pAtts.getLocalName(i), pAtts.getValue(i));
                }
            }
        }
    }
}

