/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.ant;

import com.scenari.s.fw.util.xml.HPrefixResolverNull;
import com.scenari.s.fw.util.xml.HPrefixResolverStatic;
import com.scenari.s.fw.util.xml.HTransformerXalanDyn;
import com.scenari.s.fw.util.xml.HXPathContextDyn;
import com.scenari.xsldtm.xalan.processor.TransformerFactoryImpl;
import com.scenari.xsldtm.xalan.templates.StylesheetRoot;
import com.scenari.xsldtm.xalan.transformer.TransformerImpl;
import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.utils.PrefixResolver;
import com.scenari.xsldtm.xpath.XPath;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.objects.XObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MigrateXslTask
extends XSLTProcess {
    protected File fBaseDir = null;
    protected String fStyle = null;
    protected Vector fParams = new Vector();
    protected Vector fOutputProperties = new Vector();
    protected String fFilterXPath = null;
    protected String fFilterXPathNs = null;
    protected XPath fXPath = null;
    protected StylesheetRoot fStylesheet;
    protected Vector fFilesets = new Vector();

    public static String replaceExtension(String pUrl, String pNewExtension) {
        int vIdx = pUrl.lastIndexOf(46);
        if (vIdx >= 0) {
            if (pNewExtension.startsWith(".")) {
                return pUrl.substring(0, vIdx).concat(pNewExtension);
            }
            return pUrl.substring(0, vIdx + 1).concat(pNewExtension);
        }
        if (pNewExtension.startsWith(".")) {
            return pUrl.concat(pNewExtension);
        }
        return pUrl + "." + pNewExtension;
    }

    protected void validate() {
        if (this.fFilesets.size() < 1) {
            throw new BuildException("Fileset not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Project vProject = this.getProject();
        try {
            this.validate();
            if (this.fStyle == null) {
                throw new BuildException("no stylesheet specified");
            }
            if (this.fBaseDir == null) {
                this.fBaseDir = vProject.resolveFile(".");
            }
            vProject.log("- Execute XSL '" + this.fStyle + "'", 2);
            for (FileSet fs : this.fFilesets) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] includedFiles = ds.getIncludedFiles();
                for (int i = 0; i < includedFiles.length; ++i) {
                    if (!this.process(ds.getBasedir(), includedFiles[i])) continue;
                    vProject.log("migrateXsl on '" + includedFiles[i] + "'", 2);
                }
            }
        }
        catch (Exception e) {
            vProject.log(e.getMessage(), 0);
            e.printStackTrace();
        }
        finally {
            this.fStylesheet = null;
            this.fXPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(File baseDir, String xmlFile) throws BuildException {
        block16: {
            Project vProject = this.getProject();
            File outFile = null;
            File inFile = null;
            try {
                inFile = new File(baseDir, xmlFile);
                if (inFile.isDirectory()) {
                    vProject.log("Skipping " + inFile + " it is a directory.", 3);
                    boolean bl = false;
                    return bl;
                }
                if (inFile.exists()) {
                    XObject vRes;
                    HXPathContextDyn vXPathCtx = new HXPathContextDyn();
                    DTM vDtm = vXPathCtx.hGetDtm(new FileInputStream(inFile), null, false);
                    XPath vXPath = this.getXPath();
                    if (vXPath != null && !(vRes = this.getXPath().execute((XPathContext)vXPathCtx, vDtm.getDocument(), vXPathCtx.getNamespaceContext())).bool()) {
                        boolean bl = false;
                        return bl;
                    }
                    outFile = File.createTempFile(inFile.getName(), ".tmp.xml");
                    TransformerImpl vTransf = this.createTransformer(vXPathCtx);
                    vTransf.setParameter("pCurrentItemUri", xmlFile);
                    vTransf.transformNode(vDtm.getDocument(), new StreamResult(outFile.getCanonicalPath()));
                    inFile.delete();
                    if (outFile.renameTo(inFile)) break block16;
                    AbstractInterruptibleChannel vSrc = null;
                    AbstractInterruptibleChannel vDst = null;
                    try {
                        vSrc = new FileInputStream(outFile).getChannel();
                        vDst = new FileOutputStream(inFile).getChannel();
                        ((FileChannel)vDst).transferFrom((ReadableByteChannel)((Object)vSrc), 0L, ((FileChannel)vSrc).size());
                    }
                    finally {
                        vSrc.close();
                        vDst.close();
                    }
                    outFile.delete();
                    break block16;
                }
                vProject.log("File '" + inFile.getPath() + " does not exist. Ignored", 2);
            }
            catch (Exception ex) {
                vProject.log("Failed to process " + inFile, 2);
                throw new BuildException((Throwable)ex);
            }
            finally {
                if (outFile != null) {
                    outFile.delete();
                }
            }
        }
        return true;
    }

    protected TransformerImpl createTransformer(HXPathContextDyn pXpathCtx) throws Exception {
        if (this.fStylesheet == null) {
            Project vProject = this.getProject();
            File vStylesheetFile = vProject.resolveFile(this.fStyle);
            this.fStylesheet = (StylesheetRoot)new TransformerFactoryImpl().newTemplates(new StreamSource(vStylesheetFile));
        }
        HTransformerXalanDyn vTransformer = new HTransformerXalanDyn(this.fStylesheet, pXpathCtx);
        Enumeration e = this.fParams.elements();
        while (e.hasMoreElements()) {
            XSLTProcess.Param p = (XSLTProcess.Param)e.nextElement();
            vTransformer.setParameter(p.getName(), p.getExpression());
        }
        for (int i = 0; i < this.fOutputProperties.size(); ++i) {
            XSLTProcess.OutputProperty vProperty = (XSLTProcess.OutputProperty)this.fOutputProperties.elementAt(i);
            vTransformer.setOutputProperty(vProperty.getName(), vProperty.getValue());
        }
        return vTransformer;
    }

    protected XPath getXPath() throws Exception {
        if (this.fXPath == null && this.fFilterXPath != null && this.fFilterXPath.length() > 0) {
            PrefixResolver vResolver;
            if (this.fFilterXPathNs != null && this.fFilterXPathNs.length() > 0) {
                vResolver = new HPrefixResolverStatic();
                ((HPrefixResolverStatic)vResolver).parseNsDecl(this.fFilterXPathNs);
            } else {
                vResolver = HPrefixResolverNull.hGet();
            }
            this.fXPath = new XPath(this.fFilterXPath, null, vResolver, 0);
        }
        return this.fXPath;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param p = new XSLTProcess.Param();
        this.fParams.addElement(p);
        return p;
    }

    public XSLTProcess.OutputProperty createOutputProperty() {
        XSLTProcess.OutputProperty p = new XSLTProcess.OutputProperty();
        this.fOutputProperties.addElement(p);
        return p;
    }

    public void setBasedir(File pDir) {
        this.fBaseDir = pDir;
    }

    public void addFileset(FileSet pFileset) {
        this.fFilesets.add(pFileset);
    }

    public void setStyle(String pStyle) {
        this.fStyle = pStyle;
    }

    public void setFilterXPath(String pFilterXpath) {
        this.fFilterXPath = pFilterXpath;
    }

    public void setFilterXPathNs(String pFilterXpathNs) {
        this.fFilterXPathNs = pFilterXpathNs;
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void warning(SAXParseException spe) throws SAXException {
            System.out.println("SAXParseException warning: " + spe.getMessage());
        }

        public void error(SAXParseException spe) throws SAXException {
            System.out.println("SAXParseException error: " + spe.getMessage());
        }
    }
}

