/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.composant;

import com.scenari.m.co.classecomp.IWClasseComposant;
import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.composant.WComposant;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.PrefixResolverDefault;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public abstract class HComposantType
implements IHComposantType,
ISrcAliasResolver {
    protected transient IWClasseComposant fClasseComposant = null;
    protected transient IWUnivers fUnivers = null;
    protected String fCode = null;
    protected IAgentData fDescriptif = IAgentData.NULL;
    protected IAgentData fIcone = IAgentData.NULL;
    protected IAgentData fActif = IAgentData.NULL;
    protected IAgentData fIntitule = IAgentData.NULL;
    protected XPath fXPathRoot = null;
    protected XPath fXPathCodeComposant = null;
    protected XPath fXPathIdComposant = null;
    protected String fUrlPublication = null;
    protected Object fContenuMgrInfo = null;
    protected boolean fIsOnlyRootDefinitionLoaded = false;
    protected IHComposantType fFirst = null;
    protected IHComposantType fNext = null;

    protected HComposantType() {
    }

    public void hCreateComposantAssoc(IWComposant pComposantPere, Element pRootPere, ISrcNode pDocSource, XPathContext pContext) throws Exception {
        this.hCreateComposantAssoc(pComposantPere, pRootPere, pDocSource, this.fXPathRoot, this.fXPathCodeComposant, pContext);
    }

    public void hCreateComposantAssoc(IWComposant pComposantPere, Element pRootPere, ISrcNode pDocSource, XPath pNodesRoot, XPath pXPathCodeComposant, XPathContext pContext) throws Exception {
        WComposant vComp = this.xCreateComposant(pDocSource);
        VariableStack vStack = pContext.getVarStack();
        vStack.reset();
        vStack.pushVariable(ZXPath.QNAME_VCOMP, new XObject(vComp));
        vStack.markGlobalStackFrame();
        ((PrefixResolverDefault)pContext.getPrefixResolver()).setContext(pRootPere);
        if (pNodesRoot == null) {
            XObject vRes;
            String vId = null;
            if (this.fXPathIdComposant != null && (vRes = this.fXPathIdComposant.execute(pContext, pRootPere)) != null) {
                vId = vRes.str();
            }
            String vCode = this.fCode;
            if (pXPathCodeComposant != null) {
                vCode = pXPathCodeComposant.execute(pContext, pRootPere).str();
            }
            vComp.wInitAssoc(pComposantPere, vCode, vId, pRootPere, pContext);
        } else {
            XNodeSet vRes = (XNodeSet)pNodesRoot.execute(pContext, pRootPere);
            NodeSet vNodeSet = vRes.mutableNodeset();
            if (this.fXPathCodeComposant == null) {
                if (vNodeSet.getLength() == 1) {
                    XObject vIdObj;
                    Element vNodeRoot = (Element)vNodeSet.item(0);
                    ((PrefixResolverDefault)pContext.getPrefixResolver()).setContext(vNodeRoot);
                    String vId = null;
                    if (this.fXPathIdComposant != null && (vIdObj = this.fXPathIdComposant.execute(pContext, vNodeRoot)) != null) {
                        vId = vIdObj.str();
                    }
                    String vCode = this.fCode;
                    if (pXPathCodeComposant != null) {
                        vCode = pXPathCodeComposant.execute(pContext, vNodeRoot).str();
                    }
                    vComp.wInitAssoc(pComposantPere, vCode, vId, vNodeRoot, pContext);
                } else if (vNodeSet.getLength() > 1) {
                    throw LogMgr.newException("Plusieurs composants associ\u00e9s de type '" + this + "' doivent \u00eatre cr\u00e9\u00e9s dans le composant p\u00e8re '" + pComposantPere + "'. Cependant, il n'existe pas d'attribut XPath dans la d\u00e9claration de ce composant associ\u00e9 permettant de construire un code unique.", new String[0]);
                }
            } else {
                for (int i = 0; i < vNodeSet.getLength(); ++i) {
                    XObject vIdObj;
                    Element vNodeRoot = (Element)vNodeSet.item(i);
                    ((PrefixResolverDefault)pContext.getPrefixResolver()).setContext(vNodeRoot);
                    String vId = null;
                    if (this.fXPathIdComposant != null && (vIdObj = this.fXPathIdComposant.execute(pContext, vNodeRoot)) != null) {
                        vId = vIdObj.str();
                    }
                    String vCode = this.fCode;
                    if (pXPathCodeComposant != null) {
                        vCode = pXPathCodeComposant.execute(pContext, vNodeRoot).str();
                    }
                    vComp.wInitAssoc(pComposantPere, vCode, vId, vNodeRoot, pContext);
                    if (i >= vNodeSet.getLength() - 1) continue;
                    vComp = this.xCreateComposant(pDocSource);
                }
            }
        }
    }

    public void hCreateComposantPrinc(Document pRootElement, ISrcNode pDocSource, Object pContextContenuMgr) throws Exception {
        XPathContext vPathContext = new XPathContext();
        vPathContext.setPrefixResolver(new PrefixResolverDefault(pRootElement.getDocumentElement()));
        if (this.fXPathRoot != null) {
            XNodeSet vRes = (XNodeSet)this.fXPathRoot.execute(vPathContext, pRootElement);
            NodeIterator vNodeIt = vRes.nodeset();
            Node vRootNode = vNodeIt.nextNode();
            while (vRootNode != null) {
                ((PrefixResolverDefault)vPathContext.getPrefixResolver()).setContext(vRootNode);
                this.xCreateComposantPrinc((Element)vRootNode, pDocSource, pContextContenuMgr, vPathContext);
                vRootNode = vNodeIt.nextNode();
            }
        } else {
            this.xCreateComposantPrinc(pRootElement.getDocumentElement(), pDocSource, pContextContenuMgr, vPathContext);
        }
    }

    public boolean hIsComposantPrincCreatable(Document pRootElement, ISrcNode pDocSource, Object pContextContenuMgr) throws Exception {
        if (this.fXPathRoot != null) {
            XPathContext vPathContext = new XPathContext();
            vPathContext.setPrefixResolver(new PrefixResolverDefault(pRootElement.getDocumentElement()));
            XNodeSet vRes = (XNodeSet)this.fXPathRoot.execute(vPathContext, pRootElement);
            NodeIterator vNodeIt = vRes.nodeset();
            Node vRootNode = vNodeIt.nextNode();
            vNodeIt.detach();
            return vRootNode != null;
        }
        return true;
    }

    public final IAgentData hGetActif() {
        return this.fActif;
    }

    public final IWClasseComposant hGetClasseComposant() {
        return this.fClasseComposant;
    }

    public final String hGetCode() {
        return this.fCode;
    }

    public final IHComposantType hGetCompTypeChild(String pCode) {
        for (IHComposantType vNext = this.fNext; vNext != null; vNext = vNext.wGetNextCompType()) {
            if (!vNext.hGetCode().equals(pCode)) continue;
            return vNext;
        }
        return null;
    }

    public final IAgentData hGetDescriptif() {
        return this.fDescriptif;
    }

    public final IAgentData hGetIcone() {
        return this.fIcone;
    }

    public final IAgentData hGetIntitule() {
        return this.fIntitule;
    }

    public final IWUnivers hGetUnivers() {
        return this.fUnivers;
    }

    public final String hGetXPathRoot() {
        return this.fXPathRoot != null ? this.fXPathRoot.getPatternString() : null;
    }

    public String resolveAlias(String pUrl) throws Exception {
        return this.hGetUnivers().hGetContenuMgr().hResolveUrl(pUrl, this);
    }

    public String toString() {
        return "<composanttype url=\"" + this.wGetUrlPublication() + "\" racinexpath=\"" + (this.fXPathRoot != null ? this.fXPathRoot.getPatternString() : "") + "\" classe=\"" + this.getClass().getName() + "\">" + this.hGetUnivers() + "</composanttype>";
    }

    public boolean wEqualsDefRoots(IHComposantType pCompTypes) {
        if (pCompTypes != null && pCompTypes instanceof HComposantType) {
            XPath vPath1 = ((HComposantType)pCompTypes).fXPathRoot;
            if (this.fXPathRoot == null && vPath1 == null) {
                return true;
            }
            if (this.fXPathRoot == null || vPath1 == null) {
                return false;
            }
            return this.fXPathRoot.getPatternString().equals(vPath1.getPatternString());
        }
        return false;
    }

    public final void wAddCompTypeChild(IHComposantType pCompTypeChild) {
        String vCode = pCompTypeChild.hGetCode();
        IHComposantType vPrev = null;
        for (IHComposantType vCh = this.fFirst; vCh != null; vCh = vCh.wGetNextCompType()) {
            if (vCh.hGetCode().equals(vCode)) {
                if (vPrev == null) {
                    this.fFirst = pCompTypeChild;
                } else {
                    vPrev.wSetNextCompType(pCompTypeChild);
                }
                pCompTypeChild.wSetNextCompType(vCh.wGetNextCompType());
                return;
            }
            vPrev = vCh;
        }
        pCompTypeChild.wSetNextCompType(this.fFirst);
        this.fFirst = pCompTypeChild;
    }

    public final Object wGetContenuMgrInfo() {
        return this.fContenuMgrInfo;
    }

    public final String wGetUrlPublication() {
        return this.fUrlPublication;
    }

    public final void wInit(IWUnivers pUnivers, IWClasseComposant pClasseComposant, String pCode) throws Exception {
        this.fUnivers = pUnivers;
        this.fClasseComposant = pClasseComposant;
        this.fCode = pCode;
    }

    public final void wSetContenuMgrInfo(Object pObject) {
        this.fContenuMgrInfo = pObject;
    }

    public final void wSetUrlPublication(String pUrlPublication) {
        this.fUrlPublication = pUrlPublication;
    }

    public final void wSetXPathCodeComposant(String pXPathCodeComposant, PrefixResolver pResolver) throws Exception {
        if (pXPathCodeComposant != null && pXPathCodeComposant.length() > 0) {
            this.fXPathCodeComposant = XPath.createXPath(pXPathCodeComposant, null, pResolver, 0);
        }
    }

    public final void wSetXPathIdComposant(String pXPathIdComposant, PrefixResolver pResolver) throws Exception {
        if (pXPathIdComposant != null && pXPathIdComposant.length() > 0) {
            this.fXPathIdComposant = XPath.createXPath(pXPathIdComposant, null, pResolver, 0);
        }
    }

    public final void wSetXPathRoot(String pXPathRoot, PrefixResolver pResolver) throws Exception {
        if (pXPathRoot != null && pXPathRoot.length() > 0) {
            this.fXPathRoot = XPath.createXPath(pXPathRoot, null, pResolver, 0);
        }
    }

    private final WComposant xCreateComposant(ISrcNode pDocSource) throws Exception {
        WComposant vComp = null;
        try {
            Class vClass = this.hGetClasseComposant().hGetComposantClasse();
            if (vClass == null) {
                vClass = this.xGetClassComposant();
            }
            vComp = (WComposant)vClass.newInstance();
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la cr\u00e9ation du composant associ\u00e9 \u00e0 partir du composant type : " + this, new String[0]);
        }
        vComp.wInitContext(this, pDocSource);
        return vComp;
    }

    private final void xCreateComposantPrinc(Element pNodeRoot, ISrcNode pDocSource, Object pContextContenuMgr, XPathContext pXPathContext) throws Exception {
        XObject vRes;
        String vCodeComposant = null;
        String vIdComposant = null;
        WComposant vComp = this.xCreateComposant(pDocSource);
        VariableStack vStack = pXPathContext.getVarStack();
        vStack.reset();
        vStack.pushVariable(ZXPath.QNAME_VCOMP, new XObject(vComp));
        vStack.markGlobalStackFrame();
        if (this.fXPathCodeComposant != null && (vRes = this.fXPathCodeComposant.execute(pXPathContext, pNodeRoot)) != null) {
            vCodeComposant = vRes.str();
        }
        if (vCodeComposant == null) {
            vCodeComposant = this.hGetUnivers().hGetContenuMgr().hGetIdSrcFromUri(pDocSource.getSrcUri(), pContextContenuMgr);
        }
        if (vCodeComposant != null && vCodeComposant.length() > 0) {
            if (this.fXPathIdComposant != null && (vRes = this.fXPathIdComposant.execute(pXPathContext, pNodeRoot)) != null) {
                vIdComposant = vRes.str();
            }
        } else {
            throw LogMgr.newException("L'ID est manquant pour cr\u00e9er un composant \u00e0 partir du composant type : " + this, new String[0]);
        }
        vComp.wInitPrinc(vCodeComposant, vIdComposant, pNodeRoot, pContextContenuMgr, pXPathContext);
    }

    protected abstract Class xGetClassComposant();

    public final void xSetActif(IAgentData pActif) {
        this.fActif = pActif;
    }

    public final void xSetDescriptif(IAgentData pDescriptif) {
        this.fDescriptif = pDescriptif;
    }

    public final void xSetIcone(IAgentData pIcone) {
        this.fIcone = pIcone;
    }

    public final void xSetIntitule(IAgentData pIntitule) {
        this.fIntitule = pIntitule;
    }

    public boolean isOnlyRootDefinitionLoaded() {
        return this.fIsOnlyRootDefinitionLoaded;
    }

    public IHComposantType wGetNextCompType() {
        return this.fNext;
    }

    public void wSetNextCompType(IHComposantType pCompType) {
        this.fNext = pCompType;
    }

    public IHComposantType wGetFirstChildCompType() {
        return this.fFirst;
    }
}

