/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.composant;

import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.xsldom.xpath.XPathContext;
import eu.scenari.fw.log.LogMgr;
import org.w3c.dom.Element;

public abstract class WComposant
implements IWComposant,
ISrcAliasResolver {
    protected transient IHComposantType fComposantType = null;
    protected String fCode = null;
    protected String fId = null;
    protected ISrcNode fDocSource = null;
    protected Element fElemSource = null;
    protected String fPath = null;
    protected IWComposant fCompPere = null;
    protected String fUrlPublication = null;
    protected IAgentData fIntitule = IAgentData.NULL;
    protected IAgentData fActif = IAgentData.NULL;
    protected IAgentData fDescriptif = IAgentData.NULL;
    protected Object fContenuMgrInfo = null;
    protected IWComposant fFirst = null;
    protected IWComposant fNext = null;

    protected WComposant() {
    }

    public final IAgentData hGetActif() {
        return this.fActif;
    }

    public final String hGetCode() {
        return this.fCode;
    }

    public final String hGetId() {
        return this.fId;
    }

    public final IWComposant hGetCompAssoc(String pCode) {
        for (IWComposant vNext = this.fNext; vNext != null; vNext = vNext.wGetNextComp()) {
            if (!vNext.hGetCode().equals(pCode)) continue;
            return vNext;
        }
        return null;
    }

    public final IWComposant hGetCompAssocParRef(String pRefComp) throws Exception {
        IWComposant vResult = null;
        String vUrleElem = pRefComp;
        int vBegin = 0;
        if (pRefComp.startsWith("/")) {
            vBegin = 1;
            vResult = this.hGetComposantPrincipal();
        } else {
            vResult = this;
        }
        int vEndRef = pRefComp.length() - 1;
        int vEnd = pRefComp.indexOf(47, vBegin);
        while (vResult != null && vEnd < vEndRef && vEnd > 0) {
            vUrleElem = pRefComp.substring(vBegin, vEnd);
            if (!vUrleElem.equals(".") && !vUrleElem.equals("")) {
                if (vUrleElem.equals("..")) {
                    if (!vResult.hIsComposantPrincipal()) {
                        vResult = vResult.hGetComposantPere();
                    }
                } else {
                    vResult = vResult.hGetCompAssoc(vUrleElem);
                }
            }
            vBegin = vEnd + 1;
            vEnd = pRefComp.indexOf(47, vBegin);
        }
        if (vBegin > 0 && vEnd < vEndRef && vResult != null) {
            vResult = vResult.hGetCompAssoc(pRefComp.substring(vBegin));
        }
        return vResult;
    }

    public final String hGetComposantPath() {
        return this.fPath;
    }

    public final IWComposant hGetComposantPere() {
        return this.fCompPere;
    }

    public final IWComposant hGetComposantPrincipal() {
        return this.fCompPere != null ? this.fCompPere.hGetComposantPrincipal() : this;
    }

    public final IHComposantType hGetComposantType() {
        return this.fComposantType;
    }

    public final IAgentData hGetDescriptif() {
        return this.fDescriptif;
    }

    public final IAgentData hGetIcone() {
        return IAgentData.NULL;
    }

    public final IAgentData hGetIntitule() {
        return this.fIntitule;
    }

    public final IWUnivers hGetUnivers() {
        return this.fComposantType.hGetUnivers();
    }

    public ISrcNode hGetDocSource() {
        return this.fDocSource;
    }

    public Element hGetElemSource() {
        return this.fElemSource;
    }

    public final boolean hIsComposantPrincipal() {
        return this.fCompPere == null;
    }

    public String resolveAlias(String pUrl) throws Exception {
        return this.hGetUnivers().hGetContenuMgr().hResolveUrl(pUrl, this);
    }

    public String toString() {
        return "<composant path=\"" + this.hGetComposantPath() + "\" class=\"" + this.getClass().getName() + "\" source=\"" + this.fDocSource.getSrcUri() + "\">" + this.fComposantType + "</composant>";
    }

    public String toXMLString() {
        String vResult = "";
        boolean vHasDetail = false;
        vResult = vResult + "<comp ";
        vResult = vResult + "code=\"";
        vResult = vResult + this.hGetCode();
        vResult = vResult + "\" type=\"";
        vResult = vResult + this.hGetComposantType().hGetCode();
        vResult = vResult + "\">";
        if (this.hGetIntitule() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<intitule>";
            vResult = vResult + this.hGetIntitule().toString();
            vResult = vResult + "</intitule>";
        }
        if (this.hGetIcone() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<icone>";
            vResult = vResult + this.hGetIcone().toString();
            vResult = vResult + "</icone>";
        }
        if (this.hGetDescriptif() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<descriptif>";
            vResult = vResult + this.hGetDescriptif().toString();
            vResult = vResult + "</descriptif>";
        }
        if (this.hGetActif() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<actif>";
            vResult = vResult + this.hGetActif().toString();
            vResult = vResult + "</actif>";
        }
        if (vHasDetail) {
            vResult = vResult + "</detail>";
        }
        vResult = vResult + "</comp>";
        return vResult;
    }

    public final synchronized void wAddComposant(IWComposant pComposant) {
        String vCode = pComposant.hGetCode();
        IWComposant vPrev = null;
        for (IWComposant vCh = this.fFirst; vCh != null; vCh = vCh.wGetNextComp()) {
            if (vCh.hGetCode().equals(vCode)) {
                if (vPrev == null) {
                    this.fFirst = pComposant;
                } else {
                    vPrev.wSetNextComp(pComposant);
                }
                pComposant.wSetNextComp(vCh.wGetNextComp());
                return;
            }
            vPrev = vCh;
        }
        pComposant.wSetNextComp(this.fFirst);
        this.fFirst = pComposant;
    }

    public final Object wGetContenuMgrInfo() {
        return this.fContenuMgrInfo;
    }

    public final String wGetUrlPublication() {
        return this.fUrlPublication;
    }

    public final void wInitContext(IHComposantType pCompTypePrinc, ISrcNode pDocSource) throws Exception {
        this.fComposantType = pCompTypePrinc;
        this.fDocSource = pDocSource;
    }

    public final void wInitPrinc(String pCode, String pId, Element pNodeRoot, Object pContextContenuMgr, XPathContext pContext) throws Exception {
        this.fElemSource = pNodeRoot;
        this.fCode = pCode;
        this.fPath = "@".concat(pCode);
        this.fId = pId;
        this.hGetUnivers().hGetContenuMgr().hInitComposantPrinc(this, pNodeRoot, this.fDocSource, pContextContenuMgr);
        this.xInit(pNodeRoot, this.fDocSource, pContext);
        this.hGetUnivers().hGetContenuMgr().hInitComposantPrincEnd(this, pNodeRoot, this.fDocSource, pContextContenuMgr);
    }

    public void wInitAssoc(IWComposant pComposantPere, String pCode, String pId, Element pNodeRoot, XPathContext pContext) throws Exception {
        this.fElemSource = pNodeRoot;
        this.fCode = pCode;
        this.fId = pId;
        this.fCompPere = pComposantPere;
        String vPathPere = this.fCompPere.hGetComposantPath();
        StringBuilder vBuf = new StringBuilder(vPathPere.length() + pCode.length() + 1);
        vBuf.append(vPathPere);
        vBuf.append("/");
        vBuf.append(this.fCode);
        this.fPath = vBuf.toString();
        this.hGetUnivers().hGetContenuMgr().hInitComposantAssoc(this, pNodeRoot, this.fDocSource);
        this.xInit(pNodeRoot, this.fDocSource, pContext);
        pComposantPere.wAddComposant(this);
        this.hGetUnivers().hGetContenuMgr().hInitComposantAssocEnd(this, pNodeRoot, this.fDocSource);
    }

    protected abstract void wInit(XPathContext var1) throws Exception;

    public final void wSetContenuMgrInfo(Object pObject) {
        this.fContenuMgrInfo = pObject;
    }

    public final void wSetUrlPublication(String pUrlPublication) {
        this.fUrlPublication = pUrlPublication;
    }

    protected final void xInit(Element pNodeRoot, ISrcNode pDocSource, XPathContext pContext) throws Exception {
        try {
            this.fIntitule = this.fComposantType.hGetIntitule().wSetComposant(this, pContext);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation du champ 'Intitule' du composant " + this.toString(), new String[0]);
        }
        try {
            this.fActif = this.fComposantType.hGetActif().wSetComposant(this, pContext);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation du champ 'Actif' du composant " + this.toString(), new String[0]);
        }
        try {
            this.fDescriptif = this.fComposantType.hGetDescriptif().wSetComposant(this, pContext);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation du champ 'Descriptif' du composant " + this.toString(), new String[0]);
        }
        try {
            this.wInit(pContext);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation du composant : '" + this + "'.", new String[0]);
        }
        for (IHComposantType vCompTypChild = this.fComposantType.wGetFirstChildCompType(); vCompTypChild != null; vCompTypChild = vCompTypChild.wGetNextCompType()) {
            vCompTypChild.hCreateComposantAssoc(this, pNodeRoot, pDocSource, pContext);
        }
    }

    public IWComposant wGetFirstChildComp() {
        return this.fFirst;
    }

    public IWComposant wGetNextComp() {
        return this.fNext;
    }

    public void wSetNextComp(IWComposant pCompType) {
        this.fNext = pCompType;
    }
}

