/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.dialog.webdav;

import com.scenari.m.co.dialog.HInitParams;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HInitParamsWebdav
extends HInitParams {
    public static final String PARAMNAME_DEPTH = "Depth";
    public static final String PARAMNAME_OVERWRITE = "Overwrite";
    public static final String PARAMNAME_PATHRES = "PathRes";
    public static final String PARAMNAME_PATHDEST = "PathDest";
    public static final String PARAMNAME_CONTENT = "Content";
    public static TracePoint sTrace = TraceMgr.register(HInitParamsWebdav.class.getName(), "Trace toutes les requ\u00eates \u00e0 un dialogue de type WebDav.");
    public String fPathRessource = null;
    public boolean fProtocolDav = true;
    public int fDepth = 100;
    public String fDestination = null;
    public boolean fOverwrite = false;
    public Object fContent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDialogFromServlet(IHDialog pDialog, HttpServletRequest pRequest, String pResiduPath) throws Exception {
        String vUser;
        if (sTrace.isEnabled()) {
            this.xLogRequeteClient(pRequest);
        }
        if ((vUser = pRequest.getHeader("user-agent")) != null && vUser.indexOf("Mozilla") >= 0) {
            this.fProtocolDav = false;
        }
        this.fPathRessource = pResiduPath;
        String vMethod = pRequest.getMethod();
        if (vMethod.equals("POST")) {
            this.fProtocolDav = false;
            this.wInitFromServletHttp(pDialog, pRequest);
        } else if (vMethod.equals("GET")) {
            if (pRequest.getQueryString() != null) {
                this.fProtocolDav = false;
                this.wInitFromServletHttp(pDialog, pRequest);
            } else {
                pDialog.hSetCdAction("GET");
            }
        } else if (vMethod.equals("HEAD")) {
            if (pRequest.getQueryString() != null) {
                this.fProtocolDav = false;
                this.wInitFromServletHttp(pDialog, pRequest);
            } else {
                pDialog.hSetCdAction("HEAD");
            }
        } else if (vMethod.equals("PROPFIND")) {
            pDialog.hSetCdAction("PROPFIND_ALL");
            this.wSetDepth(pRequest.getHeader(PARAMNAME_DEPTH), "PROPFIND");
            if (pRequest.getContentLength() > 0) {
                XMLReader vReader = HInitParamsWebdav.xGetXmlReader();
                try {
                    vReader.setContentHandler(new XPropFindSaxHandler(pDialog));
                    vReader.parse(new InputSource((InputStream)pRequest.getInputStream()));
                }
                catch (Exception e) {
                }
                finally {
                    HInitParamsWebdav.xFreeXmlReader(vReader);
                }
            }
        } else if (vMethod.equals("PROPPATCH")) {
            pDialog.hSetCdAction("PROPPATCH");
        } else if (vMethod.equals("MKCOL")) {
            pDialog.hSetCdAction("MKCOL");
        } else if (vMethod.equals("COPY")) {
            pDialog.hSetCdAction("COPY");
            this.wSetDepth(pRequest.getHeader(PARAMNAME_DEPTH), "COPY");
            this.wSetDestination(pRequest.getHeader("Destination"), pRequest.getCharacterEncoding());
            this.wSetOverwrite(pRequest.getHeader(PARAMNAME_OVERWRITE));
        } else if (vMethod.equals("MOVE")) {
            pDialog.hSetCdAction("MOVE");
            this.wSetDestination(pRequest.getHeader("Destination"), pRequest.getCharacterEncoding());
            this.wSetOverwrite(pRequest.getHeader(PARAMNAME_OVERWRITE));
        } else if (vMethod.equals("DELETE")) {
            pDialog.hSetCdAction("DELETE");
        } else if (vMethod.equals("OPTIONS")) {
            pDialog.hSetCdAction("OPTIONS");
        } else if (vMethod.equals("LOCK")) {
            pDialog.hSetCdAction("LOCK");
        } else if (vMethod.equals("UNLOCK")) {
            pDialog.hSetCdAction("UNLOCK");
        } else if (vMethod.equals("PUT")) {
            pDialog.hSetCdAction("PUT");
            this.wSetOverwriteForPut(pRequest.getHeader(PARAMNAME_OVERWRITE));
            this.fContent = pRequest.getInputStream();
        } else if (vMethod.equals("TRACE")) {
            pDialog.hSetCdAction("TRACE");
        } else {
            this.wInitFromServletHttp(pDialog, pRequest);
        }
    }

    protected void wInitFromServletHttp(IHDialog pDialog, HttpServletRequest pRequest) throws Exception {
        if (FileUploadBase.isMultipartContent((HttpServletRequest)pRequest)) {
            DiskFileUpload vFu = new DiskFileUpload();
            List vFields = vFu.parseRequest(pRequest);
            for (int i = 0; i < vFields.size(); ++i) {
                FileItem vField = (FileItem)vFields.get(i);
                String vFieldName = vField.getFieldName();
                if (PARAMNAME_PATHRES.equals(vFieldName)) {
                    this.fPathRessource = vField.getString();
                    continue;
                }
                if (PARAMNAME_CONTENT.equals(vFieldName)) {
                    this.fContent = vField.getInputStream();
                    continue;
                }
                if ("cdaction".equals(vFieldName)) {
                    pDialog.hSetCdAction(vField.getString().intern());
                    continue;
                }
                if ("param".equals(vFieldName)) {
                    pDialog.hSetParam(vField.getString());
                    continue;
                }
                if (PARAMNAME_DEPTH.equals(vFieldName)) {
                    String vD = vField.getString();
                    if ("1".equals(vD)) {
                        this.fDepth = 1;
                        continue;
                    }
                    if ("0".equals(vD)) {
                        this.fDepth = 0;
                        continue;
                    }
                    this.fDepth = 100;
                    continue;
                }
                if (PARAMNAME_OVERWRITE.equals(vFieldName)) {
                    if (pDialog.hGetCdAction() == "PUT") {
                        this.wSetOverwriteForPut(vField.getString());
                        continue;
                    }
                    this.wSetOverwrite(vField.getString());
                    continue;
                }
                if (!PARAMNAME_PATHDEST.equals(vFieldName)) continue;
                this.fDestination = vField.getString();
            }
        } else {
            String vCdAction = pRequest.getParameter("cdaction");
            vCdAction = vCdAction != null ? vCdAction.intern() : "GET";
            pDialog.hSetCdAction(vCdAction);
            pDialog.hSetParam(pRequest.getParameter("param"));
            String vD = pRequest.getParameter(PARAMNAME_DEPTH);
            this.fDepth = "1".equals(vD) ? 1 : ("0".equals(vD) ? 0 : 100);
            String vPathRes = pRequest.getParameter(PARAMNAME_PATHRES);
            if (vPathRes != null) {
                this.fPathRessource = vPathRes;
            }
            this.fDestination = pRequest.getParameter(PARAMNAME_PATHDEST);
            if (vCdAction.equals("PUT")) {
                this.wSetOverwriteForPut(pRequest.getParameter(PARAMNAME_OVERWRITE));
                this.fContent = pRequest.getInputStream();
            } else {
                this.wSetOverwrite(pRequest.getParameter(PARAMNAME_OVERWRITE));
            }
        }
    }

    protected void wSetDepth(String pVal, String pMethod) throws Exception {
        this.fDepth = 100;
        if (pVal != null) {
            if (pVal.equals("0")) {
                this.fDepth = 0;
            } else if (pMethod == "PROPFIND" && pVal.equals("1")) {
                this.fDepth = 1;
            }
        }
    }

    protected void wSetDestination(String pVal, String pEncoding) throws Exception {
        this.fDestination = pVal;
        if (this.fDestination != null && (this.fDestination.indexOf(37) >= 0 || this.fDestination.indexOf(43) >= 0)) {
            this.fDestination = URLDecoder.decode(this.fDestination, pEncoding != null ? pEncoding : "UTF-8");
        }
    }

    protected void wSetOverwrite(String pVal) throws Exception {
        this.fOverwrite = "T".equalsIgnoreCase(pVal);
    }

    protected void wSetOverwriteForPut(String pVal) throws Exception {
        this.fOverwrite = !"F".equalsIgnoreCase(pVal);
    }

    protected static final XMLReader xGetXmlReader() throws Exception {
        return HPoolXmlReader.hGet().hGetXmlReader(true, false);
    }

    protected static final void xFreeXmlReader(XMLReader pReader) {
        HPoolXmlReader.hGet().hFreeXmlReader(pReader);
    }

    protected void xLogRequeteClient(HttpServletRequest pRequest) {
        System.out.println("***************************************************");
        System.out.println("Requete");
        System.out.println();
        System.out.println("Encoding : " + pRequest.getCharacterEncoding());
        System.out.println("Length : " + pRequest.getContentLength());
        System.out.println("Type : " + pRequest.getContentType());
        System.out.println();
        System.out.println("Parameters");
        Enumeration parameters = pRequest.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = pRequest.getParameterValues(paramName);
            System.out.print(paramName + " : ");
            for (int i = 0; i < values.length; ++i) {
                System.out.print(values[i] + ", ");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Protocol : " + pRequest.getProtocol());
        System.out.println("Address : " + pRequest.getRemoteAddr());
        System.out.println("Host : " + pRequest.getRemoteHost());
        System.out.println("Scheme : " + pRequest.getScheme());
        System.out.println("Server Name : " + pRequest.getServerName());
        System.out.println("Server Port : " + pRequest.getServerPort());
        System.out.println();
        System.out.println("Attributes");
        Enumeration attributes = pRequest.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attributeName = (String)attributes.nextElement();
            System.out.print(attributeName + " : ");
            System.out.println(pRequest.getAttribute(attributeName).toString());
        }
        System.out.println();
        System.out.println();
        System.out.println("HTTP Header Info");
        System.out.println();
        System.out.println("Authentication Type : " + pRequest.getAuthType());
        System.out.println("HTTP Method : " + pRequest.getMethod());
        System.out.println("Path Info : " + pRequest.getPathInfo());
        System.out.println("Path translated : " + pRequest.getPathTranslated());
        System.out.println("Query string : " + pRequest.getQueryString());
        System.out.println("Remote user : " + pRequest.getRemoteUser());
        System.out.println("Requested session id : " + pRequest.getRequestedSessionId());
        System.out.println("Request URI : " + pRequest.getRequestURI());
        System.out.println("Context path : " + pRequest.getContextPath());
        System.out.println("Servlet path : " + pRequest.getServletPath());
        System.out.println("User principal : " + pRequest.getUserPrincipal());
        System.out.println();
        System.out.println("Headers : ");
        Enumeration headers = pRequest.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            System.out.print(headerName + " : ");
            System.out.println(pRequest.getHeader(headerName));
        }
        System.out.println();
        System.out.println();
    }

    public String hExtractDestPath(String pUrlService) throws Exception {
        if (this.fProtocolDav) {
            if (!this.fDestination.startsWith(pUrlService)) {
                return null;
            }
            return this.fDestination.substring(pUrlService.endsWith("/") ? pUrlService.length() - 1 : pUrlService.length());
        }
        return this.fDestination;
    }

    public boolean isInitFromServletFullyHandled() {
        return true;
    }

    class XPropFindSaxHandler
    extends DefaultHandler {
        private IHDialog fDialog = null;

        XPropFindSaxHandler(IHDialog pDialog) {
            this.fDialog = pDialog;
        }

        public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            if ("DAV:".equals(pNamespaceURI)) {
                if (pLocalName.equals("allprop")) {
                    this.fDialog.hSetCdAction("PROPFIND_ALL");
                    HInitParamsWebdav.this.fContent = null;
                } else if (pLocalName.equals("propname")) {
                    this.fDialog.hSetCdAction("PROPFIND_NAME");
                    HInitParamsWebdav.this.fContent = null;
                } else if (pLocalName.equals("prop")) {
                    this.fDialog.hSetCdAction("PROPFIND_FILTER");
                    HInitParamsWebdav.this.fContent = new ArrayList(30);
                } else if (HInitParamsWebdav.this.fContent != null) {
                    ((List)HInitParamsWebdav.this.fContent).add("DAV:");
                    ((List)HInitParamsWebdav.this.fContent).add(pLocalName);
                    ((List)HInitParamsWebdav.this.fContent).add(pQName);
                }
            } else if (HInitParamsWebdav.this.fContent != null) {
                ((List)HInitParamsWebdav.this.fContent).add(pNamespaceURI);
                ((List)HInitParamsWebdav.this.fContent).add(pLocalName);
                ((List)HInitParamsWebdav.this.fContent).add(pQName);
            }
        }
    }
}

