/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.dialog.webdav;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.HInitParamsWebdav;
import com.scenari.m.co.dialog.webdav.WResultatError;
import com.scenari.m.co.service.HSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.src.NotAllowedException;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.LogMsg;
import eu.scenari.universe.execframe.IExecFrame;

public abstract class HSDialogWebdav
extends HSDialog {
    public static final String CDACTION_INIT = "Init";
    public static final String CDACTION_DOWNLOAD = "Download";
    public static final String CDACTION_GET = "GET";
    public static final String CDACTION_PROPFIND_FILTER = "PROPFIND_FILTER";
    public static final String CDACTION_PROPFIND_ALL = "PROPFIND_ALL";
    public static final String CDACTION_PROPFIND_NAME = "PROPFIND_NAME";
    public static final String CDACTION_PROPPATCH = "PROPPATCH";
    public static final String CDACTION_MKCOL = "MKCOL";
    public static final String CDACTION_COPY = "COPY";
    public static final String CDACTION_MOVE = "MOVE";
    public static final String CDACTION_PUT = "PUT";
    public static final String CDACTION_DELETE = "DELETE";
    public static final String CDACTION_OPTIONS = "OPTIONS";
    public static final String CDACTION_LOCK = "LOCK";
    public static final String CDACTION_UNLOCK = "UNLOCK";
    public static final String CDACTION_TRACE = "TRACE";
    public static final String CDACTION_HEAD = "HEAD";
    protected HInitParamsWebdav fParamEntree = null;
    protected Object fPageResultatDav = null;
    protected String fPageResultatNonDav = null;

    public HSDialogWebdav(IWService pService) {
        super(pService);
    }

    protected String wGetDefaultCdAction() {
        return CDACTION_INIT;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        if (this.fParamEntree.fProtocolDav || this.hGetCdAction() == CDACTION_DOWNLOAD || this.hGetCdAction() == CDACTION_GET) {
            return this.fPageResultatDav;
        }
        return this.fPageResultatNonDav;
    }

    public Object hGetPageResultatDav() {
        return this.fPageResultatDav;
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        if (this.fParamEntree == null) {
            this.fParamEntree = new HInitParamsWebdav();
        }
        return this.fParamEntree;
    }

    public String hGetRequestPathRes() {
        if (this.fParamEntree != null) {
            return this.fParamEntree.fPathRessource;
        }
        return null;
    }

    public String hGetRequestDest() {
        if (this.fParamEntree != null) {
            return this.fParamEntree.fDestination;
        }
        return null;
    }

    public int hGetRequestDepth() {
        if (this.fParamEntree != null) {
            return this.fParamEntree.fDepth;
        }
        return 0;
    }

    protected IHDialog xExecute() throws Exception {
        String vCdAction = this.hGetCdAction();
        try {
            if (vCdAction == CDACTION_GET) {
                return this.xDoGetHeadDownload(true);
            }
            if (vCdAction == CDACTION_OPTIONS) {
                return this.xDoOptions();
            }
            if (vCdAction == CDACTION_PUT) {
                return this.xDoPut();
            }
            if (vCdAction == CDACTION_COPY) {
                return this.xDoCopy();
            }
            if (vCdAction == CDACTION_MOVE) {
                return this.xDoMove();
            }
            if (vCdAction == CDACTION_PROPFIND_ALL) {
                return this.xDoPropfindAll();
            }
            if (vCdAction == CDACTION_PROPFIND_NAME) {
                return this.xDoPropfindName();
            }
            if (vCdAction == CDACTION_PROPFIND_FILTER) {
                return this.xDoPropfindFilter();
            }
            if (vCdAction == CDACTION_PROPPATCH) {
                return this.xDoProppatch();
            }
            if (vCdAction == CDACTION_DELETE) {
                return this.xDoDelete();
            }
            if (vCdAction == CDACTION_MKCOL) {
                return this.xDoMkcol();
            }
            if (vCdAction == CDACTION_LOCK) {
                return this.xDoLock();
            }
            if (vCdAction == CDACTION_UNLOCK) {
                return this.xDoUnlock();
            }
            if (vCdAction == CDACTION_TRACE) {
                return this.xDoTrace();
            }
            if (vCdAction == CDACTION_HEAD) {
                return this.xDoGetHeadDownload(false);
            }
            if (vCdAction == CDACTION_INIT) {
                return this.xDoInit();
            }
            if (vCdAction == CDACTION_DOWNLOAD) {
                return this.xDoGetHeadDownload(true);
            }
            return super.xExecute();
        }
        catch (NotAllowedException e) {
            this.fPageResultatDav = new WResultatError(403);
            ((WResultatError)this.fPageResultatDav).hSetLogMessage(LogMgr.getMessage(e));
            this.fPageResultatNonDav = this.xGetPageResultatErreur();
        }
        catch (Throwable e) {
            this.fPageResultatDav = new WResultatError(500);
            ((WResultatError)this.fPageResultatDav).hSetLogMessage(LogMgr.getMessage(e));
            this.fPageResultatNonDav = this.xGetPageResultatErreur();
        }
        return this;
    }

    protected IHDialog xDoGetHeadDownload(boolean pWithBody) throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoGetHeadDownload non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoOptions() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoOptions non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoPut() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoPut non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoCopy() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoCopy non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoMove() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoMove non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoPropfindAll() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoPropfindAll non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoPropfindName() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoPropfindName non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoPropfindFilter() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoPropfindFilter non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoProppatch() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoProppatch non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoDelete() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoDelete non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoMkcol() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoMkcol non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoLock() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoLock non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoUnlock() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoUnlock non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoTrace() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoTrace non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected IHDialog xDoInit() throws Exception {
        this.fPageResultatDav = new WResultatError(501, new LogMsg("M\u00e9thode xDoInit non impl\u00e9ment\u00e9e", ILogMsg.LogType.Info, new String[0]));
        return this;
    }

    protected abstract String xGetPageResultatErreur();
}

