/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.dialog.webdav;

import com.scenari.m.co.dialog.IHDialog;
import eu.scenari.fw.main.ServletBase;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.universe.execframe.httpservlet.ISenderHttpResponse;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WResultatGet
implements ISenderHttpResponse {
    protected int fLength = -1;
    protected long fLastModifDate = 0L;
    protected String fContentLocation = null;
    protected Object fStream = null;
    protected String fDownloadNameFile = null;
    protected String fContentType = null;

    public void sendDialogResult(IHDialog pDialog, HttpServletRequest pRequest, HttpServletResponse pResponse) throws Exception {
        try {
            ServletBase.setHeaderNoCache(pResponse);
            if (this.fLength >= 0) {
                pResponse.setContentLength(this.fLength);
            }
            pResponse.setContentType(this.fContentType == null ? "" : this.fContentType);
            if (this.fLastModifDate >= 0L) {
                pResponse.setDateHeader("Last-Modified", this.fLastModifDate);
            }
            if (this.fContentLocation != null) {
                pResponse.setHeader("content-location", this.fContentLocation);
            }
            pResponse.setHeader("Etag", this.xGetETag());
            pResponse.setHeader("Accept-Ranges", "none");
            if (this.fDownloadNameFile != null) {
                pResponse.setHeader("Content-Disposition", "attachment;filename=".concat(this.fDownloadNameFile.replaceAll("\\s", "")));
            }
            if (this.fStream != null) {
                if (this.fStream instanceof IByteStream) {
                    ((IByteStream)this.fStream).writeIn((OutputStream)pResponse.getOutputStream());
                    ((IByteStream)this.fStream).closeStream();
                } else {
                    StreamUtils.write((InputStream)this.fStream, (OutputStream)pResponse.getOutputStream());
                }
            }
        }
        catch (Exception e) {
            if (this.fStream != null) {
                if (this.fStream instanceof IByteStream) {
                    ((IByteStream)this.fStream).closeStream();
                } else {
                    ((InputStream)this.fStream).close();
                }
            }
            throw e;
        }
    }

    public String hGetDownloadNameFile() {
        return this.fDownloadNameFile;
    }

    public String hGetContentLocation() {
        return this.fContentLocation;
    }

    public String hGetContentType() {
        return this.fContentType;
    }

    public int hGetLength() {
        return this.fLength;
    }

    public void hClose() throws Exception {
        if (this.fStream != null) {
            if (this.fStream instanceof IByteStream) {
                ((IByteStream)this.fStream).closeStream();
            } else {
                ((InputStream)this.fStream).close();
            }
        }
    }

    public void hSetContentLocation(String pContentLocation) {
        this.fContentLocation = pContentLocation;
    }

    public void hSetDownloadNameFile(String pDownloadNameFile) {
        this.fDownloadNameFile = pDownloadNameFile;
    }

    public void hSetContentType(String pContentType) {
        this.fContentType = pContentType;
    }

    public void hSetInputStream(InputStream pInputStream) {
        this.fStream = pInputStream;
    }

    public void hSetStream(IByteStream pStream) {
        this.fStream = pStream;
    }

    public void hSetLength(int pLength) {
        this.fLength = pLength;
    }

    public long hGetLastModifDate() {
        return this.fLastModifDate;
    }

    public void hSetLastModifDate(long pLastModifDate) {
        this.fLastModifDate = pLastModifDate;
    }

    protected String xGetETag() {
        return "\"" + this.fLength + "-" + this.fLastModifDate + "\"";
    }
}

