/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.dialog.webdav;

import com.scenari.m.co.dialog.IHDialog;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.main.ServletBase;
import eu.scenari.universe.execframe.httpservlet.ISenderHttpResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WResultatOptions
implements ISenderHttpResponse,
Cloneable {
    public static TracePoint sTrace = TraceMgr.register(WResultatOptions.class.getName(), "Trace les r\u00e9sultats d'une requ\u00eate Webdav 'OPTIONS'.");
    public static final String DAVVERSION_1 = "1";
    public static final String DAVVERSION_2 = "1,2";
    protected String fDavVersion = "1";
    protected String fContentLocation = null;
    protected String fAllow = null;
    protected boolean fOPTIONS = true;
    protected boolean fGET = true;
    protected boolean fHEAD = true;
    protected boolean fPOST = true;
    protected boolean fDELETE = true;
    protected boolean fTRACE = true;
    protected boolean fPROPFIND = true;
    protected boolean fPROPPATCH = true;
    protected boolean fCOPY = true;
    protected boolean fMOVE = true;
    protected boolean fPUT = true;
    protected boolean fMKCOL = true;
    protected boolean fLOCK = false;
    protected boolean fUNLOCK = false;

    public WResultatOptions() {
    }

    public WResultatOptions(String pDavVersion) {
        this.fDavVersion = pDavVersion;
    }

    public void sendDialogResult(IHDialog pDialog, HttpServletRequest pRequest, HttpServletResponse pResponse) throws Exception {
        ServletBase.setHeaderNoCache(pResponse);
        pResponse.setContentType("text/plain");
        pResponse.addHeader("DAV", this.fDavVersion);
        if (this.fAllow == null) {
            this.xBuildAllow();
        }
        pResponse.addHeader("Allow", this.fAllow);
        pResponse.addHeader("MS-Author-Via", "DAV");
        if (sTrace.isEnabled()) {
            LogMgr.publishTrace("Options response - DAV : " + this.fDavVersion + "  - Allow : " + this.fAllow, new String[0]);
        }
    }

    protected void xBuildAllow() {
        StringBuilder vBuf = new StringBuilder(100);
        if (this.fOPTIONS) {
            vBuf.append("OPTIONS,");
        }
        if (this.fGET) {
            vBuf.append("GET,");
        }
        if (this.fTRACE) {
            vBuf.append("TRACE,");
        }
        if (this.fHEAD) {
            vBuf.append("HEAD,");
        }
        if (this.fPOST) {
            vBuf.append("POST,");
        }
        if (this.fDELETE) {
            vBuf.append("DELETE,");
        }
        if (this.fPROPFIND) {
            vBuf.append("PROPFIND,");
        }
        if (this.fPROPPATCH) {
            vBuf.append("PROPPATCH,");
        }
        if (this.fCOPY) {
            vBuf.append("COPY,");
        }
        if (this.fMOVE) {
            vBuf.append("MOVE,");
        }
        if (this.fPUT) {
            vBuf.append("PUT,");
        }
        if (this.fLOCK) {
            vBuf.append("LOCK,");
        }
        if (this.fUNLOCK) {
            vBuf.append("UNLOCK,");
        }
        if (vBuf.length() > 0) {
            vBuf.setLength(vBuf.length() - 1);
        }
        this.fAllow = vBuf.toString();
    }

    public WResultatOptions hClone() {
        try {
            return (WResultatOptions)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String hGetDavVersion() {
        return this.fDavVersion;
    }

    public WResultatOptions hSetDavVersion(String davVersion) {
        this.fDavVersion = davVersion;
        return this;
    }

    public String hGetContentLocation() {
        return this.fContentLocation;
    }

    public WResultatOptions hSetContentLocation(String pContentLocation) {
        this.fContentLocation = pContentLocation;
        return this;
    }

    public boolean hIsCOPY() {
        return this.fCOPY;
    }

    public boolean hIsDELETE() {
        return this.fDELETE;
    }

    public boolean hIsGET() {
        return this.fGET;
    }

    public boolean hIsHEAD() {
        return this.fHEAD;
    }

    public boolean hIsLOCK() {
        return this.fLOCK;
    }

    public boolean hIsMKCOL() {
        return this.fMKCOL;
    }

    public boolean hIsMOVE() {
        return this.fMOVE;
    }

    public boolean hIsOPTIONS() {
        return this.fOPTIONS;
    }

    public boolean hIsPOST() {
        return this.fPOST;
    }

    public boolean hIsPROPFIND() {
        return this.fPROPFIND;
    }

    public boolean hIsPROPPATCH() {
        return this.fPROPPATCH;
    }

    public boolean hIsPUT() {
        return this.fPUT;
    }

    public boolean hIsTRACE() {
        return this.fTRACE;
    }

    public boolean hIsUNLOCK() {
        return this.fUNLOCK;
    }

    public WResultatOptions hSetCOPY(boolean pB) {
        this.fAllow = null;
        this.fCOPY = pB;
        return this;
    }

    public WResultatOptions hSetDELETE(boolean pB) {
        this.fAllow = null;
        this.fDELETE = pB;
        return this;
    }

    public WResultatOptions hSetGET(boolean pB) {
        this.fAllow = null;
        this.fGET = pB;
        return this;
    }

    public WResultatOptions hSetHEAD(boolean pB) {
        this.fAllow = null;
        this.fHEAD = pB;
        return this;
    }

    public WResultatOptions hSetLOCK(boolean pB) {
        this.fAllow = null;
        this.fLOCK = pB;
        return this;
    }

    public WResultatOptions hSetMKCOL(boolean pB) {
        this.fAllow = null;
        this.fMKCOL = pB;
        return this;
    }

    public WResultatOptions hSetMOVE(boolean pB) {
        this.fAllow = null;
        this.fMOVE = pB;
        return this;
    }

    public WResultatOptions hSetOPTIONS(boolean pB) {
        this.fAllow = null;
        this.fOPTIONS = pB;
        return this;
    }

    public WResultatOptions hSetPOST(boolean pB) {
        this.fAllow = null;
        this.fPOST = pB;
        return this;
    }

    public WResultatOptions hSetPROPFIND(boolean pB) {
        this.fAllow = null;
        this.fPROPFIND = pB;
        return this;
    }

    public WResultatOptions hSetPROPPATCH(boolean pB) {
        this.fAllow = null;
        this.fPROPPATCH = pB;
        return this;
    }

    public WResultatOptions hSetPUT(boolean pB) {
        this.fAllow = null;
        this.fPUT = pB;
        return this;
    }

    public WResultatOptions hSetTRACE(boolean pB) {
        this.fAllow = null;
        this.fTRACE = pB;
        return this;
    }

    public WResultatOptions hSetUNLOCK(boolean pB) {
        this.fAllow = null;
        this.fUNLOCK = pB;
        return this;
    }

    public WResultatOptions hUpdateForNullRessource() {
        this.fAllow = null;
        this.fCOPY = false;
        this.fDELETE = false;
        this.fGET = false;
        this.fHEAD = false;
        this.fMKCOL = true;
        this.fMOVE = false;
        this.fOPTIONS = true;
        this.fPROPFIND = false;
        this.fPROPPATCH = false;
        this.fPUT = true;
        this.fTRACE = false;
        return this;
    }
}

