/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.dialog.webdav;

import com.scenari.m.co.dialog.webdav.IHWebdavResource;
import com.scenari.m.co.dialog.webdav.WResultatMultiStatus;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.s.fw.utils.HUrl;
import com.scenari.serializer.simple.IXmlWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class WResultatPropfind
extends WResultatMultiStatus {
    protected static final SimpleDateFormat sModifDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected ArrayList fResources = null;
    boolean fOnlyNames = false;

    public WResultatPropfind() {
        this.fResources = new ArrayList();
    }

    public WResultatPropfind(int pNbResources) {
        this.fResources = new ArrayList(pNbResources);
    }

    public List hGetListRessources() {
        return this.fResources;
    }

    public void hSetOnlyNames(boolean pOnlyNames) {
        this.fOnlyNames = pOnlyNames;
    }

    public void hAddResource(IHWebdavResource pRes) {
        this.fResources.add(pRes);
    }

    public int hGetSize() {
        return this.fResources.size();
    }

    public void xWriteResponses(IXmlWriter pWriter) throws Exception {
        for (int i = 0; i < this.fResources.size(); ++i) {
            int vLength;
            IHWebdavResource vResource = (IHWebdavResource)this.fResources.get(i);
            pWriter.writeOpenTag("response");
            String vUrl = HUrl.hEncode(vResource.hGetPath(), this.fEncoding);
            pWriter.writeTag("href", vUrl);
            pWriter.writeOpenTag("propstat");
            pWriter.writeOpenTag("prop");
            String vVal = null;
            Date vDate = null;
            vVal = vResource.hGetResourceType();
            if (vVal != null) {
                if (!this.fOnlyNames && vVal == "collection") {
                    pWriter.writeOpenTag("resourcetype");
                    pWriter.writeEmptyTag("collection");
                    pWriter.writeCloseTag("resourcetype");
                } else {
                    pWriter.writeEmptyTag("resourcetype");
                }
            }
            if ((vVal = vResource.hGetDisplayName()) != null) {
                if (this.fOnlyNames) {
                    pWriter.writeEmptyTag("displayname");
                } else {
                    pWriter.writeTag("displayname", vVal);
                }
            }
            if ((vDate = vResource.hGetCreationDate()) != null) {
                if (this.fOnlyNames) {
                    pWriter.writeEmptyTag("creationdate");
                } else {
                    pWriter.writeTag("creationdate", sModifDateFormat.format(vDate));
                }
            }
            if ((vDate = vResource.hGetModifDate()) != null) {
                if (this.fOnlyNames) {
                    pWriter.writeEmptyTag("getlastmodified");
                } else {
                    pWriter.writeTag("getlastmodified", sModifDateFormat.format(vDate));
                }
            }
            if ((vLength = vResource.hGetContentLength()) >= 0) {
                if (this.fOnlyNames) {
                    pWriter.writeEmptyTag("getcontentlength");
                } else {
                    pWriter.writeTag("getcontentlength", HCharSeqUtil.hGetIntToString(vLength));
                }
            }
            pWriter.writeCloseTag("prop");
            pWriter.writeTag("status", "HTTP/1.1 200 OK");
            pWriter.writeCloseTag("propstat");
            pWriter.writeCloseTag("response");
        }
    }

    static {
        sModifDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

