/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee;

import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Node;

public class DataFromSource
implements IComputedData {
    protected ISrcNode fSource = null;
    protected String fContentType = null;
    protected HTransformParams fTransforms = null;

    public DataFromSource(ISrcNode pSource, String pContentType, HTransformParams pTransforms) {
        this.fSource = pSource;
        this.fTransforms = pTransforms;
        this.fContentType = pContentType;
    }

    public String getMime() throws Exception {
        IHTransformer vTr;
        if (this.fTransforms != null && (vTr = HTransformerMgr.hGetTransformerMgr(null).hGetTransformer(this.fTransforms)) != null) {
            return vTr.hGetMimeType(this.fTransforms);
        }
        if (this.fContentType != null) {
            return this.fContentType;
        }
        return this.fSource.getContentType();
    }

    public final String getUrlRes() throws Exception {
        return null;
    }

    public String getString() throws Exception {
        StringWriter vBuf = PoolBuffers.popStringWriter();
        this.writeValue(vBuf);
        String vRes = vBuf.getBuffer().substring(0);
        PoolBuffers.freeStringWriter(vBuf);
        return vRes;
    }

    public Node getNode() throws Exception {
        return HDonneeUtils.hGetNodeFromString(this);
    }

    public boolean isResRef() throws Exception {
        return false;
    }

    public void writeValue(Writer pWriter) throws Exception {
        String vCharset = MimeMgr.extractCharsetFromContentType(this.getMime());
        InputStream vInput = null;
        try {
            if (this.fTransforms != null) {
                IByteStream vStream = SrcFeatureTransform.transformContent(this.fSource, this.fTransforms);
                if (vStream != null) {
                    vInput = vStream.getInputStream(true);
                }
            } else {
                vInput = this.fSource.newInputStream(false);
            }
            if (vInput == null) {
                return;
            }
            InputStreamReader vReader = vCharset != null ? new InputStreamReader(vInput, vCharset) : new InputStreamReader(vInput);
            StreamUtils.write(vReader, pWriter);
        }
        catch (Exception e) {
            if (vInput != null) {
                vInput.close();
            }
            LogMgr.publishException((Throwable)e, "Get data from source failed : %s, %s", ILogMsg.LogType.Warning, this.fSource.getSrcUri(), this.fTransforms.hGetQueryStringFromThis());
        }
    }
}

