/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.m.co.donnee.IData;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.xsldom.xalan.serialize.Serializer;
import com.scenari.xsldom.xalan.serialize.SerializerFactory;
import com.scenari.xsldom.xalan.stree.DocumentFragmentImpl;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.StreeDOMBuilder;
import com.scenari.xsldom.xalan.stree.TextImpl;
import com.scenari.xsldom.xalan.templates.OutputProperties;
import eu.scenari.fw.pools.PoolBuffers;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class HDonneeUtils {
    protected static final Properties OUTPUTPROPS_XML = new Properties(OutputProperties.getDefaultMethodProperties("xml"));
    protected static final Properties OUTPUTPROPS_HTML = new Properties(OutputProperties.getDefaultMethodProperties("html"));
    protected static final Properties OUTPUTPROPS_TEXT = new Properties(OutputProperties.getDefaultMethodProperties("text"));

    protected static Properties getDefaultMethodProperties(String method) {
        if (method.equals("xml")) {
            return OUTPUTPROPS_XML;
        }
        if (method.equals("html")) {
            return OUTPUTPROPS_HTML;
        }
        if (method.equals("text")) {
            return OUTPUTPROPS_TEXT;
        }
        return OUTPUTPROPS_XML;
    }

    private HDonneeUtils() {
    }

    public static final boolean hGetBooleanEvalFalse(String pValue) {
        if (pValue == null) {
            return true;
        }
        int vLen = pValue.length();
        if (vLen == 0) {
            return true;
        }
        if (vLen == 1) {
            return pValue.charAt(0) != '0';
        }
        if (vLen == 5) {
            char vChar = pValue.charAt(0);
            if (vChar != 'f' && vChar != 'F') {
                return true;
            }
            vChar = pValue.charAt(1);
            if (vChar != 'a' && vChar != 'A') {
                return true;
            }
            vChar = pValue.charAt(2);
            if (vChar != 'l' && vChar != 'L') {
                return true;
            }
            vChar = pValue.charAt(3);
            if (vChar != 's' && vChar != 'S') {
                return true;
            }
            vChar = pValue.charAt(4);
            if (vChar == 'e' || vChar == 'E') {
                return false;
            }
        }
        return true;
    }

    public static final boolean hGetBooleanEvalTrue(String pValue) {
        if (pValue == null) {
            return false;
        }
        int vLen = pValue.length();
        if (vLen == 0) {
            return false;
        }
        if (vLen == 1) {
            return pValue.charAt(0) == '1';
        }
        if (vLen == 4) {
            char vChar = pValue.charAt(0);
            if (vChar != 't' && vChar != 'T') {
                return false;
            }
            vChar = pValue.charAt(1);
            if (vChar != 'r' && vChar != 'R') {
                return false;
            }
            vChar = pValue.charAt(2);
            if (vChar != 'u' && vChar != 'U') {
                return false;
            }
            vChar = pValue.charAt(3);
            if (vChar == 'e' || vChar == 'E') {
                return true;
            }
        }
        return false;
    }

    public static final boolean hIsLevelInteractif(String pMimeType) {
        return pMimeType == "text/javascript,expression" || pMimeType == "text/javascript,function";
    }

    public static final Document hCreateDoc() {
        return new DocumentImpl(false);
    }

    public static final Node hGetNodeFromString(IData pData, IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        String vMime = pData.getMime(pDialog, pOwner, pArguments);
        if (vMime == "text/xml") {
            String vString = pData.getString(pDialog, pOwner, pArguments);
            return HDonneeUtils.hGetDocumentFromString(vString);
        }
        if (vMime == "text/xml-fragment") {
            String vString = pData.getString(pDialog, pOwner, pArguments);
            return HDonneeUtils.hGetDocumentFragmentFromString(vString);
        }
        return new TextImpl(null, pData.getString(pDialog, pOwner, pArguments));
    }

    public static final Node hGetNodeFromString(IComputedData pData) throws Exception {
        String vMime = pData.getMime();
        if (vMime == "text/xml") {
            String vString = pData.getString();
            return HDonneeUtils.hGetDocumentFromString(vString);
        }
        if (vMime == "text/xml-fragment") {
            String vString = pData.getString();
            return HDonneeUtils.hGetDocumentFragmentFromString(vString);
        }
        return new TextImpl(null, pData.getString());
    }

    public static final Node hGetNodeFromString(String pData) throws Exception {
        return new TextImpl(null, pData);
    }

    public static final Node hGetNodeFromNodeIterator(NodeIterator pIt, String pMime) throws Exception {
        if (pMime == null || pMime == "text/xml-fragment") {
            // empty if block
        }
        return pIt.nextNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String hGetStringFromNode(IData pData, IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        StringWriter vWriter = PoolBuffers.popStringWriter();
        String vResult = "";
        try {
            HDonneeUtils.hWriteFromNode(pData, pDialog, pOwner, pArguments, vWriter);
            vResult = vWriter.getBuffer().substring(0);
        }
        finally {
            PoolBuffers.freeStringWriter(vWriter);
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String hGetStringFromNode(IComputedData pData) throws Exception {
        StringWriter vWriter = PoolBuffers.popStringWriter();
        String vResult = "";
        try {
            HDonneeUtils.hWriteFromNode(pData, vWriter);
            vResult = vWriter.getBuffer().substring(0);
        }
        finally {
            PoolBuffers.freeStringWriter(vWriter);
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String hGetStringFromNode(Node pData) throws Exception {
        if (pData == null) {
            return "";
        }
        StringWriter vWriter = PoolBuffers.popStringWriter();
        String vResult = "";
        try {
            HDonneeUtils.hWriteFromNode(pData, "xml", vWriter);
            vResult = vWriter.getBuffer().substring(0);
        }
        finally {
            PoolBuffers.freeStringWriter(vWriter);
        }
        return vResult;
    }

    public static final void hWriteFromNode(IData pData, IHDialog pDialog, Object pOwner, Object pArguments, Writer pWriter) throws Exception {
        String vMime = pData.getMime(pDialog, pOwner, pArguments);
        if (vMime == "text/html") {
            HDonneeUtils.hWriteFromNode(pData.getNode(pDialog, pOwner, pArguments), "html", pWriter);
        } else if (vMime == "text/plain" || vMime == "text/javascript,function" || vMime == "text/javascript,expression") {
            HDonneeUtils.hWriteFromNode(pData.getNode(pDialog, pOwner, pArguments), "text", pWriter);
        } else {
            HDonneeUtils.hWriteFromNode(pData.getNode(pDialog, pOwner, pArguments), "xml", pWriter);
        }
    }

    public static final void hWriteFromNode(IComputedData pData, Writer pWriter) throws Exception {
        Node vNode = pData.getNode();
        if (vNode == null) {
            return;
        }
        String vMime = pData.getMime();
        if (vMime == "text/html") {
            HDonneeUtils.hWriteFromNode(vNode, "html", pWriter);
        } else if (vMime == "text/plain" || vMime == "text/javascript,function" || vMime == "text/javascript,expression") {
            HDonneeUtils.hWriteFromNode(vNode, "text", pWriter);
        } else {
            HDonneeUtils.hWriteFromNode(vNode, "xml", pWriter);
        }
    }

    public static final void hWriteFromNode(Node pNode, String pMethod, Writer pWriter) throws Exception {
        Serializer vSerializer = SerializerFactory.getSerializer(HDonneeUtils.getDefaultMethodProperties(pMethod));
        vSerializer.setWriter(pWriter);
        vSerializer.asDOMSerializer().serialize(pNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentFragment hGetDocumentFragmentFromString(String vString) throws Exception, SAXNotRecognizedException, SAXNotSupportedException, IOException, SAXException {
        DocumentImpl vDoc = new DocumentImpl(false, vString.length());
        DocumentFragmentImpl vFrag = (DocumentFragmentImpl)vDoc.createDocumentFragment();
        XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            StreeDOMBuilder vDomBuilder = new StreeDOMBuilder((Document)vDoc, vFrag);
            vReader.setContentHandler(vDomBuilder);
            vReader.setProperty("http://xml.org/sax/properties/lexical-handler", vDomBuilder);
            vReader.parse(new InputSource(new StringReader(vString)));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vReader);
        }
        return vFrag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document hGetDocumentFromString(String vString) throws Exception, SAXNotRecognizedException, SAXNotSupportedException, IOException, SAXException {
        DocumentImpl vDoc = new DocumentImpl(false, vString.length());
        XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            StreeDOMBuilder vDomBuilder = new StreeDOMBuilder(vDoc);
            vReader.setContentHandler(vDomBuilder);
            vReader.setProperty("http://xml.org/sax/properties/lexical-handler", vDomBuilder);
            vReader.parse(new InputSource(new StringReader(vString)));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vReader);
        }
        return vDoc;
    }

    static {
        OUTPUTPROPS_XML.setProperty("omit-xml-declaration", "yes");
    }
}

