/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.HDonneeCalculate;
import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.m.co.donnee.IHContextDonnee;
import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.PrefixResolverDefault;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WDonneeXPath
implements IAgentData {
    protected String fMime = null;
    protected XPath fXPathCompiled = null;

    public IComputedData compute(IHDialog pDialog, Object pOwner, Object pArguments, boolean pAddOwnerToExecStack) throws Exception {
        return new HDonneeCalculate(pDialog, this, pOwner, pArguments, pAddOwnerToExecStack);
    }

    public final String getMime(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return this.fMime == null ? "text/plain" : this.fMime;
    }

    public Node getNode(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return HDonneeUtils.hGetNodeFromString(this, pDialog, pOwner, pArguments);
    }

    public final String getUrlRes(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        throw new Exception("Cette donn\u00e9e n'est pas une ressource statique.");
    }

    public final boolean isResRef(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return false;
    }

    public String toString() {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        vBuf.append("<donnee type=\"");
        vBuf.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1));
        vBuf.append("\">");
        if (this.fXPathCompiled != null) {
            vBuf.append("<xpath><![CDATA[");
            vBuf.append(this.fXPathCompiled.getPatternString());
            vBuf.append("]]></xpath>");
        }
        if (this.fMime != null) {
            vBuf.append("<mime>");
            vBuf.append(this.fMime);
            vBuf.append("</mime>");
        }
        vBuf.append("</donnee>");
        String vResult = vBuf.substring(0);
        PoolBuffers.freeStringBuilder(vBuf);
        return vResult;
    }

    public final void wSetMime(String pMimeType) {
        this.fMime = pMimeType == null ? null : pMimeType.intern();
    }

    public final void wSetValue(IHComposantType pCompType, String pValue, IHContextDonnee pContextDonnee) throws Exception {
        this.xLoadXPath(pCompType, pValue, pContextDonnee.hGetPrefixResolver());
        this.xInitDonneeFc(pCompType);
    }

    public final void wSetValueParRef(IHComposantType pCompType, ISrcNode pDocSource) throws Exception {
        String vContent = StreamUtils.buildString(SrcFeatureStreams.newReader(pDocSource, null));
        this.xLoadXPath(pCompType, vContent, null);
        this.xInitDonneeFc(pCompType);
    }

    public final boolean wSetValueParSaxHandler(IHComposantType pCompType, FragmentSaxHandlerBase pHandlerPere, IHContextDonnee pContextDonnee) throws Exception {
        return false;
    }

    protected final String xGetValue(IHDialog pDialog, IWAgent pAgent, Object pArguments) throws Exception {
        String vResultat = null;
        if (this.fXPathCompiled != null) {
            Element vRoot = pAgent.hGetElementRoot();
            XPathContext vPathContext = pAgent.hGetInstance().hPopXPathContext();
            try {
                VariableStack vStack = vPathContext.getVarStack();
                vStack.pushVariable(ZXPath.QNAME_VDIALOG, new XObject(pDialog));
                vStack.pushVariable(ZXPath.QNAME_VAGENT, new XObject(pAgent));
                if (pArguments != null) {
                    vStack.pushVariable(ZXPath.QNAME_VARGUMENTS, XObject.create(pArguments));
                }
                vStack.markGlobalStackFrame();
                vPathContext.setPrefixResolver(new PrefixResolverDefault(vRoot));
                XObject vResultObject = this.fXPathCompiled.execute(vPathContext, vRoot);
                vResultat = vResultObject.str();
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec au calcul d'une donnee dynamique XPath : " + this.fXPathCompiled.getPatternString(), new String[0]);
            }
            finally {
                pAgent.hGetInstance().hFreeXPathContext(vPathContext);
            }
        } else {
            vResultat = "";
        }
        return vResultat;
    }

    protected void xInitDonneeFc(IHComposantType pCompType) throws Exception {
    }

    protected void xLoadXPath(IHComposantType pCompType, String pContent, PrefixResolver pPrefixResolver) throws Exception {
        try {
            this.fXPathCompiled = XPath.createXPath(pContent, null, pPrefixResolver != null ? pPrefixResolver : PrefixResolverDefault.DEFAULT, 0);
        }
        catch (Exception e) {
            this.fXPathCompiled = null;
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la compilation d'un XPath du composant type '" + pCompType + "':\n" + pContent, new String[0]);
        }
    }
}

