/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.HDonneeCalculate;
import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.m.co.donnee.IHContextDonnee;
import com.scenari.m.co.donnee.XSaxHandlerToXsl;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xsldom.xalan.processor.TransformerFactoryImpl;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class WDonneeXsl
implements IAgentData {
    public static TracePoint sTrace = TraceMgr.register(WDonneeXsl.class.getName(), "Affiche le temps d'execution des XSL ex\u00e9cut\u00e9s sur l'instance (level dynamique)..");
    protected String fMime = null;
    protected Object fTemplate = null;

    public final IComputedData compute(IHDialog pDialog, Object pOwner, Object pArguments, boolean pAddOwnerToExecStack) throws Exception {
        return new HDonneeCalculate(pDialog, this, pOwner, pArguments, pAddOwnerToExecStack);
    }

    public final String getMime(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return this.fMime == null ? "text/plain" : this.fMime;
    }

    public Node getNode(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return HDonneeUtils.hGetNodeFromString(this, pDialog, pOwner, pArguments);
    }

    public final String getUrlRes(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        throw new Exception("Cette donn\u00e9e n'est pas une ressource statique.");
    }

    public final boolean isResRef(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return false;
    }

    public String toString() {
        String vResult = "";
        vResult = vResult + "<donnee type=\"" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + "\">";
        if (this.fTemplate != null) {
            vResult = vResult + "<template>" + this.fTemplate.toString() + "</template>";
        }
        if (this.fMime != null) {
            vResult = vResult + "<mime>" + this.fMime + "</mime>";
        }
        vResult = vResult + "</donnee>";
        return vResult;
    }

    public final void wSetMime(String pMimeType) {
        this.fMime = pMimeType == null ? null : pMimeType.intern();
    }

    public void wSetValue(IHComposantType pCompType, String pValue, IHContextDonnee pContextDonnee) throws Exception {
        if (pValue != null) {
            XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                SrcFeaturePaths.SrcNodeResolver vDocSource = pContextDonnee.hGetDocSource();
                TransformerFactoryImpl vTransFact = new TransformerFactoryImpl();
                vDocSource.setAliasResolver((ISrcAliasResolver)((Object)pCompType));
                ((TransformerFactory)vTransFact).setURIResolver(vDocSource);
                vXmlReader.setEntityResolver(vDocSource);
                SAXSource vSource = null;
                InputSource vInputSource = new InputSource(new StringReader(pValue.trim()));
                vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vDocSource));
                vSource = new SAXSource(vXmlReader, vInputSource);
                this.fTemplate = ((TransformerFactory)vTransFact).newTemplates(vSource);
            }
            catch (Exception e) {
                this.fTemplate = null;
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la compilation d'un template XSL du composant type '" + pCompType + "':\n" + pValue, new String[0]);
            }
            finally {
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
        }
    }

    public void wSetValueParRef(IHComposantType pCompType, ISrcNode pDocSource) throws Exception {
        this.fTemplate = pDocSource;
    }

    public boolean wSetValueParSaxHandler(IHComposantType pCompType, FragmentSaxHandlerBase pHandlerPere, IHContextDonnee pContextDonnee) throws Exception {
        XSaxHandlerToXsl vHandler = new XSaxHandlerToXsl(this, pCompType, pContextDonnee);
        vHandler.hSetXmlReader(pHandlerPere.getXMLReader());
        return true;
    }

    protected final void xGetValue(IHDialog pDialog, IWAgent pAgent, Object pArguments, Result pResult) throws Exception {
        IWComposant vComposant = pAgent.hGetComposant();
        Templates vTemplate = this.xGetTemplate(vComposant.hGetComposantType());
        if (vTemplate != null) {
            try {
                long vTo = 0L;
                if (sTrace.isEnabled()) {
                    vTo = System.currentTimeMillis();
                }
                Transformer vTransformer = vTemplate.newTransformer();
                SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(pAgent.hGetComposant().hGetDocSource(), (ISrcAliasResolver)((Object)pAgent));
                vTransformer.setURIResolver(vResolver);
                vComposant.hGetUnivers().hGetContenuMgr().hSetAliasPublic(vTransformer, pAgent);
                vTransformer.setParameter("vDialog", pDialog);
                vTransformer.setParameter("vAgent", new XObject(pAgent));
                if (pArguments != null) {
                    vTransformer.setParameter("vArguments", pArguments);
                }
                DOMSource vSource = new DOMSource(pAgent.hGetElementRoot());
                vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolver));
                vTransformer.transform(vSource, pResult);
                if (sTrace.isEnabled()) {
                    vTo = System.currentTimeMillis() - vTo;
                    sTrace.publishDebug("Temps d'ex\u00e9cution XSL : " + vTo + "ms. " + pDialog + ".", new String[0]);
                }
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Echec au calcul dynamique d'une donnee (XSL-Dynamique) de l'agent : " + pAgent, new String[0]);
                ILogMsg vMess = LogMgr.getMessage(e);
                LogMgr.publishMessage(vMess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Templates xGetTemplate(IHComposantType pCompType) throws Exception {
        if (this.fTemplate == null) {
            return null;
        }
        if (this.fTemplate instanceof Templates) {
            return (Templates)this.fTemplate;
        }
        SrcFeaturePaths.SrcNodeResolver vDocSource = SrcFeaturePaths.newSrcNodeResolver((ISrcNode)this.fTemplate, (ISrcAliasResolver)((Object)pCompType));
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            TransformerFactoryImpl vTransFact = new TransformerFactoryImpl();
            ((TransformerFactory)vTransFact).setURIResolver(vDocSource);
            vXmlReader.setEntityResolver(vDocSource);
            InputStream vStream = vDocSource.newInputStream(false);
            if (vStream == null) {
                throw LogMgr.newException("Le fichier template XSL '" + vDocSource + "' est introuvable.", new String[0]);
            }
            InputSource vInputSource = new InputSource(vStream);
            vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vDocSource));
            SAXSource vSource = new SAXSource(vXmlReader, vInputSource);
            try {
                this.fTemplate = ((TransformerFactory)vTransFact).newTemplates(vSource);
            }
            finally {
                vStream.close();
            }
        }
        catch (Exception e) {
            this.fTemplate = null;
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la compilation d'un template XSL du composant type '" + pCompType + "':\n" + vDocSource.toString(), new String[0]);
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
        return (Templates)this.fTemplate;
    }
}

