/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee;

import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.donnee.HADonneeMgr;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.donnee.IHContextDonnee;
import com.scenari.s.fw.util.xml.HExtraitSaxHandlerToText;
import com.scenari.s.fw.util.xml.HExtraitSaxHandlerToXml;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xsldom.xml.utils.PrefixResolverStatic;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class XSaxHandlerDonnees
extends FragmentSaxHandlerBase {
    public static final String TAG_DONNEE_ATT_TYPE = "type";
    public static final String TAG_DONNEE_ATT_HREF = "href";
    public static final String TAG_DONNEE_ATT_MIME = "mime";
    protected IHContextDonnee fContextDonnee = null;
    protected IHComposantType fCompType = null;
    protected IAgentData fCurrentDonnee = null;
    protected HExtraitSaxHandlerToText fSaxHandlerToText = null;
    protected HExtraitSaxHandlerToXml fSaxHandlerToXml = null;
    protected boolean fCurrentSubSaxHandlerIsXml = false;

    public XSaxHandlerDonnees(IHComposantType pCompType) {
        this.fCompType = pCompType;
    }

    public void hSetContextDonnee(IHContextDonnee pContextDonnee) {
        this.fContextDonnee = pContextDonnee;
    }

    protected void xEndElementDonnee(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (this.fCurrentDonnee != null) {
            StringBuilder vBuf;
            StringBuilder stringBuilder = vBuf = this.fCurrentSubSaxHandlerIsXml ? this.fSaxHandlerToXml.hGetStringBuilder() : this.fSaxHandlerToText.hGetStringBuilder();
            if (vBuf.length() > 0) {
                try {
                    this.fCurrentDonnee.wSetValue(this.fCompType, vBuf.substring(0), this.fContextDonnee);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation du contenu d'une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            } else {
                try {
                    this.fCurrentDonnee.wSetValue(this.fCompType, "", this.fContextDonnee);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation d'une chaine vide ('') dans une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            }
            this.fCurrentDonnee = null;
        }
    }

    public IAgentData xNewDonnee(Attributes pAttributes) throws SAXException {
        IAgentData vResult = null;
        String vType = pAttributes.getValue(TAG_DONNEE_ATT_TYPE);
        String vHRef = pAttributes.getValue(TAG_DONNEE_ATT_HREF);
        String vMime = pAttributes.getValue(TAG_DONNEE_ATT_MIME);
        if (vHRef != null && !vHRef.equals("")) {
            try {
                vResult = HADonneeMgr.hNewDonneeParRef(vType, vMime, this.fCompType, SrcFeaturePaths.findNodeByPath(this.fContextDonnee.hGetDocSource(), vHRef, true));
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException("Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + vType + "' et de ref externe '" + vHRef + "'."), LogMgr.getMessage(e));
            }
        }
        try {
            vResult = HADonneeMgr.hNewDonnee(vType, vMime, this.fCompType);
            if (!vResult.wSetValueParSaxHandler(this.fCompType, this, this.fContextDonnee)) {
                this.fCurrentDonnee = vResult;
                if (vMime != null && vMime.indexOf("xml") >= 0) {
                    if (this.fSaxHandlerToXml == null) {
                        this.fSaxHandlerToXml = new HExtraitSaxHandlerToXml();
                        this.fSaxHandlerToXml.hSetStringBuilder(new StringBuilder(256));
                    } else {
                        this.fSaxHandlerToXml.hGetStringBuilder().setLength(0);
                    }
                    this.fSaxHandlerToXml.hSetXmlReader(this.fXMLReader, false);
                    this.fCurrentSubSaxHandlerIsXml = true;
                } else {
                    if (this.fSaxHandlerToText == null) {
                        this.fSaxHandlerToText = new HExtraitSaxHandlerToText();
                        this.fSaxHandlerToText.hSetStringBuilder(new StringBuilder(256));
                    } else {
                        this.fSaxHandlerToText.hGetStringBuilder().setLength(0);
                    }
                    this.fSaxHandlerToText.hSetXmlReader(this.fXMLReader, false);
                    this.fCurrentSubSaxHandlerIsXml = false;
                }
            }
        }
        catch (Exception e) {
            throw (SAXException)LogMgr.addMessage(new SAXException("Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + vType + "'."), LogMgr.getMessage(e));
        }
        return vResult;
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        ((PrefixResolverStatic)this.fContextDonnee.hGetPrefixResolver()).removePrefix(pPrefix);
    }

    public void startPrefixMapping(String pPrefix, String pUri) throws SAXException {
        ((PrefixResolverStatic)this.fContextDonnee.hGetPrefixResolver()).addPrefix(pPrefix, pUri);
    }
}

