/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee.composition;

import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.donnee.HADonneeMgr;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.donnee.XSaxHandlerDonnees;
import com.scenari.m.co.donnee.composition.XContainer;
import com.scenari.m.co.donnee.composition.XContainerAgentsLies;
import com.scenari.m.co.donnee.composition.XContainerBoucle;
import com.scenari.m.co.donnee.composition.XContainerCdata;
import com.scenari.m.co.donnee.composition.XContainerChoose;
import com.scenari.m.co.donnee.composition.XContainerChooseWhen;
import com.scenari.m.co.donnee.composition.XContainerIf;
import com.scenari.m.co.donnee.composition.XResultatAgent;
import com.scenari.s.fw.util.xml.HEncodingXml;
import com.scenari.s.fw.utils.HUrl;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xsldom.xml.utils.XMLCharacterRecognizer;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XCompositionSaxHandler
extends XSaxHandlerDonnees {
    public static final String TAG_COMPOSITION = "composition";
    public static final String TAG_DONNEE = "donnee";
    public static final String TAG_CDATA = "cdata";
    public static final String TAG_RESULTAT = "resultat";
    public static final String TAG_RESULTAT_ATT_AGENT = "agent";
    public static final String TAG_RESULTAT_ATT_DIALOGUE = "dialogue";
    public static final String TAG_RESULTAT_ATT_ARGUMENTS = "arguments";
    public static final String TAG_AGENTSLIES = "agentslies";
    public static final String TAG_BOUCLEAGENTS = "boucleagents";
    public static final String TAG_LISTEAGENTS = "listeagents";
    public static final String TAG_CHOOSE = "choose";
    public static final String TAG_WHEN = "when";
    public static final String TAG_OTHERWISE = "otherwise";
    public static final String TAG_IF = "if";
    public static final String TAG_ATT_TEST = "test";
    public static final String NS_COMPOSITION = "composition";
    protected XContainer fContainer = null;
    protected Stack fStackContainer = null;
    protected StringBuilder fStringBuilder = new StringBuilder();
    protected int fOffsetLastElementInDonnee = 0;
    protected ArrayList fNsDeclStack = null;

    public XCompositionSaxHandler(XContainer pContainer, IHComposantType pCompType) {
        super(pCompType);
        this.fContainer = pContainer;
    }

    public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
        this.fStringBuilder.append(pCh, pStart, pLength);
    }

    public void xAddStringFix(boolean pExcludeWhiteSpace, boolean pTrim) throws Exception {
        if (this.fStringBuilder.length() > 0) {
            String vVal = null;
            if (pExcludeWhiteSpace) {
                if (!XMLCharacterRecognizer.isWhiteSpace(this.fStringBuilder)) {
                    vVal = this.fStringBuilder.substring(0);
                    if (pTrim) {
                        vVal = vVal.trim();
                    }
                }
            } else if (this.fStringBuilder.length() > 0) {
                vVal = this.fStringBuilder.substring(0);
                if (pTrim) {
                    vVal = vVal.trim();
                }
            }
            if (vVal != null && vVal.length() > 0) {
                this.fContainer.xAddElement(HADonneeMgr.hNewDonnee("fixe", null, this.fCompType, vVal, this.fContextDonnee));
            }
            this.fStringBuilder.setLength(0);
            this.fOffsetLastElementInDonnee = -1;
        }
    }

    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if ("composition" == pNamespaceURI) {
            if (TAG_DONNEE == pLocalName || TAG_LISTEAGENTS == pLocalName) {
                this.xAddStringFix(true, false);
                super.xEndElementDonnee(pNamespaceURI, pLocalName, pQName);
            } else if (TAG_AGENTSLIES == pLocalName || TAG_BOUCLEAGENTS == pLocalName || TAG_CDATA == pLocalName || TAG_CHOOSE == pLocalName || TAG_WHEN == pLocalName || TAG_OTHERWISE == pLocalName || TAG_IF == pLocalName) {
                this.xAddStringFix(true, false);
                this.fContainer = (XContainer)this.fStackContainer.pop();
            } else if ("composition" == pLocalName) {
                this.xAddStringFix(true, false);
            }
        } else if (this.fOffsetLastElementInDonnee == this.fStringBuilder.length()) {
            if (this.fStringBuilder.length() > 0) {
                this.fStringBuilder.setCharAt(this.fStringBuilder.length() - 1, '/');
                this.fStringBuilder.append('>');
            }
        } else {
            this.fStringBuilder.append("</");
            this.fStringBuilder.append(pQName);
            this.fStringBuilder.append('>');
        }
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if ("composition".equals(pUri)) {
            this.xAddStringFix(true, false);
            if (TAG_DONNEE == pLocalName) {
                this.fContainer.xAddElement(this.xNewDonnee(pAttributes));
            } else if (TAG_RESULTAT == pLocalName) {
                this.fContainer.xAddElement(new XResultatAgent(pAttributes.getValue(TAG_RESULTAT_ATT_AGENT), pAttributes.getValue(TAG_RESULTAT_ATT_DIALOGUE), pAttributes.getValue(TAG_RESULTAT_ATT_ARGUMENTS)));
            } else if (TAG_AGENTSLIES == pLocalName) {
                if (this.fStackContainer == null) {
                    this.fStackContainer = new Stack();
                }
                XContainerAgentsLies vContainer = new XContainerAgentsLies(pAttributes.getValue(TAG_RESULTAT_ATT_AGENT), pAttributes.getValue(TAG_RESULTAT_ATT_DIALOGUE));
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_BOUCLEAGENTS == pLocalName) {
                if (this.fStackContainer == null) {
                    this.fStackContainer = new Stack();
                }
                XContainerBoucle vContainer = new XContainerBoucle();
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_LISTEAGENTS == pLocalName) {
                if (this.fContainer == null || !(this.fContainer instanceof XContainerBoucle)) {
                    throw LogMgr.newException("Un tag 'listeagents' n'est pas d\u00e9fini dans un \u00e9l\u00e9ment 'boucleagents'.", new String[0]);
                }
                ((XContainerBoucle)this.fContainer).fListeAgents = this.xNewDonnee(pAttributes);
            } else if (TAG_CDATA == pLocalName) {
                if (this.fStackContainer == null) {
                    this.fStackContainer = new Stack();
                }
                XContainerCdata vContainer = new XContainerCdata();
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_CHOOSE == pLocalName) {
                if (this.fStackContainer == null) {
                    this.fStackContainer = new Stack();
                }
                XContainerChoose vContainer = new XContainerChoose();
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_WHEN == pLocalName) {
                if (this.fContainer == null || !(this.fContainer instanceof XContainerChoose)) {
                    throw LogMgr.newException("Un tag 'when' doit \u00eatre d\u00e9clar\u00e9 dans un tag 'choose'.", new String[0]);
                }
                XContainerChooseWhen vContainer = new XContainerChooseWhen();
                vContainer.fTest = this.xBuildTest(pUri, pLocalName, pQName, pAttributes);
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_OTHERWISE == pLocalName) {
                if (this.fContainer == null || !(this.fContainer instanceof XContainerChoose)) {
                    throw LogMgr.newException("Un tag 'otherwise' doit \u00eatre d\u00e9clar\u00e9 dans un tag 'choose'.", new String[0]);
                }
                XContainerChooseWhen vContainer = new XContainerChooseWhen();
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            } else if (TAG_IF == pLocalName) {
                if (this.fStackContainer == null) {
                    this.fStackContainer = new Stack();
                }
                XContainerIf vContainer = new XContainerIf();
                vContainer.fTest = this.xBuildTest(pUri, pLocalName, pQName, pAttributes);
                this.fContainer.xAddContainer(vContainer);
                this.fStackContainer.push(this.fContainer);
                this.fContainer = vContainer;
            }
        } else {
            int i;
            this.fStringBuilder.append('<');
            this.fStringBuilder.append(pQName);
            for (i = 0; i < pAttributes.getLength(); ++i) {
                this.fStringBuilder.append(' ');
                this.fStringBuilder.append(pAttributes.getQName(i));
                this.fStringBuilder.append("=\"");
                String vValAtt = pAttributes.getValue(i);
                int vOffsLastAppend = 0;
                int vOffsBegin = vValAtt.indexOf(123);
                if (vOffsBegin >= 0) {
                    this.xAddStringFix(true, false);
                }
                while (vOffsBegin >= 0) {
                    if (vOffsBegin < vValAtt.length() - 1) {
                        if (vValAtt.charAt(vOffsBegin + 1) != '{') {
                            int vOffsLast = vValAtt.indexOf(125, vOffsBegin);
                            while (vOffsLast >= 0 && vOffsLast != vValAtt.length() - 1 && vValAtt.charAt(vOffsLast + 1) == '}') {
                                vValAtt = vValAtt.substring(0, vOffsLast).concat(vValAtt.substring(vOffsLast + 1));
                                vOffsLast = vValAtt.indexOf(125, vOffsLast + 1);
                            }
                            if (vOffsLast < 0) {
                                LogMgr.publishException("L'attribut '" + pAttributes.getQName(i) + "' dans l'\u00e9l\u00e9ment '" + pQName + "' de la donn\u00e9e " + this.fCurrentDonnee + " est mal form\u00e9 : auncune accolade fermante trouv\u00e9e.", new String[0]);
                                break;
                            }
                            if (vOffsLastAppend < vOffsBegin) {
                                HEncodingXml.hWriteAttributHtmlValue(this.fStringBuilder, vValAtt.substring(vOffsLastAppend, vOffsBegin));
                            }
                            vOffsLastAppend = vOffsLast + 1;
                            String vPrefix = vValAtt.substring(vOffsBegin + 1, vOffsLast);
                            String vValue = null;
                            int vEndPrefix = vPrefix.indexOf(58);
                            if (vEndPrefix >= 0) {
                                vValue = vEndPrefix < vPrefix.length() - 1 ? vPrefix.substring(vEndPrefix + 1) : "";
                                vPrefix = vPrefix.substring(0, vEndPrefix).trim();
                            } else {
                                vPrefix = vPrefix.trim();
                            }
                            HUrl vUrl = new HUrl(vPrefix);
                            if (TAG_DONNEE.equals(vUrl.hGetUrlWithoutParams())) {
                                String vType = vUrl.hGetValue("type");
                                String vHRef = vUrl.hGetValue("href");
                                String vMime = vUrl.hGetValue("mime");
                                if (vHRef != null && !vHRef.equals("")) {
                                    try {
                                        this.xAddStringFix(false, false);
                                        this.fContainer.xAddElement(HADonneeMgr.hNewDonneeParRef(vType, vMime, this.fCompType, SrcFeaturePaths.findNodeByPath(this.fContextDonnee.hGetDocSource(), vHRef, true)));
                                    }
                                    catch (Exception e) {
                                        throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + vType + "' et de ref externe '" + vHRef + "' dans l'attribut '" + pAttributes.getQName(i) + "' de l'\u00e9l\u00e9ment '" + pQName + "' de la donn\u00e9e " + this.fCurrentDonnee + ".", new String[0]);
                                    }
                                } else {
                                    try {
                                        this.xAddStringFix(false, false);
                                        this.fContainer.xAddElement(HADonneeMgr.hNewDonnee(vType, vMime, this.fCompType, vValue, this.fContextDonnee));
                                    }
                                    catch (Exception e) {
                                        throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + vType + "' et de contenu'" + vValue + "' dans l'attribut '" + pAttributes.getQName(i) + "' de l'\u00e9l\u00e9ment '" + pQName + "' de la donn\u00e9e " + this.fCurrentDonnee + ".", new String[0]);
                                    }
                                }
                            } else if (TAG_RESULTAT.equals(vUrl.hGetUrlWithoutParams())) {
                                this.xAddStringFix(false, false);
                                if (vValue != null) {
                                    this.fContainer.xAddElement(new XResultatAgent(vUrl.hGetValue(TAG_RESULTAT_ATT_AGENT), vUrl.hGetValue(TAG_RESULTAT_ATT_DIALOGUE), vValue));
                                } else {
                                    this.fContainer.xAddElement(new XResultatAgent(vUrl.hGetValue(TAG_RESULTAT_ATT_AGENT), vUrl.hGetValue(TAG_RESULTAT_ATT_DIALOGUE), vUrl.hGetValue(TAG_RESULTAT_ATT_ARGUMENTS)));
                                }
                            } else {
                                LogMgr.publishException("L'attribut '" + pAttributes.getQName(i) + "' dans l'\u00e9l\u00e9ment '" + pQName + "' de la donn\u00e9e " + this.fCurrentDonnee + " est mal form\u00e9 : le pr\u00e9fixe de la zone dynamique '" + vUrl.hGetUrlWithoutParams() + "' est inconnu.", new String[0]);
                                break;
                            }
                            vOffsBegin = vOffsLast;
                        } else {
                            if (vOffsLastAppend < vOffsBegin) {
                                HEncodingXml.hWriteAttributHtmlValue(this.fStringBuilder, vValAtt.substring(vOffsLastAppend, vOffsBegin));
                            }
                            vOffsLastAppend = ++vOffsBegin;
                        }
                    }
                    vOffsBegin = vValAtt.indexOf(123, vOffsBegin + 1);
                }
                if (vOffsLastAppend < vValAtt.length()) {
                    HEncodingXml.hWriteAttributHtmlValue(this.fStringBuilder, vValAtt.substring(vOffsLastAppend));
                    this.xAddStringFix(false, false);
                }
                this.fStringBuilder.append('\"');
            }
            if (this.fNsDeclStack != null && this.fNsDeclStack.size() > 0) {
                for (i = 0; i < this.fNsDeclStack.size(); i += 2) {
                    String vPrefix = (String)this.fNsDeclStack.get(i);
                    String vNs = (String)this.fNsDeclStack.get(i + 1);
                    if (vPrefix.length() > 0) {
                        this.fStringBuilder.append(" xmlns:");
                        this.fStringBuilder.append(vPrefix);
                        this.fStringBuilder.append("=\"");
                    } else {
                        this.fStringBuilder.append(" xmlns=\"");
                    }
                    this.fStringBuilder.append(vNs);
                    this.fStringBuilder.append('\"');
                }
            }
            this.fStringBuilder.append('>');
            this.fOffsetLastElementInDonnee = this.fStringBuilder.length();
        }
        if (this.fNsDeclStack != null && this.fNsDeclStack.size() > 0) {
            this.fNsDeclStack.clear();
        }
        return true;
    }

    protected IAgentData xBuildTest(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        String vType = pAttributes.getValue("type");
        String vHRef = pAttributes.getValue("href");
        String vMime = pAttributes.getValue("mime");
        if (vHRef != null && !vHRef.equals("")) {
            try {
                return HADonneeMgr.hNewDonneeParRef(vType, vMime, this.fCompType, SrcFeaturePaths.findNodeByPath(this.fContextDonnee.hGetDocSource(), vHRef, true));
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout de la condition '" + vType + "', de ref externe '" + vHRef + "' de l'\u00e9l\u00e9ment '" + pQName + "'.", new String[0]);
            }
        }
        String vValue = pAttributes.getValue(TAG_ATT_TEST);
        try {
            return HADonneeMgr.hNewDonnee(vType, vMime, this.fCompType, vValue, this.fContextDonnee);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout de la condition '" + vType + "', de valeur '" + vValue + "' de l'\u00e9l\u00e9ment '" + pQName + "'.", new String[0]);
        }
    }

    public void startPrefixMapping(String pPrefix, String pUri) throws SAXException {
        super.startPrefixMapping(pPrefix, pUri);
        if (this.fNsDeclStack == null) {
            this.fNsDeclStack = new ArrayList();
        }
        this.fNsDeclStack.add(pPrefix);
        this.fNsDeclStack.add(pUri);
    }
}

