/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee.externe;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.HDonneeCalculate;
import com.scenari.m.co.donnee.HDonneeUtils;
import com.scenari.m.co.donnee.IComputedData;
import com.scenari.m.co.donnee.IData;
import com.scenari.m.co.donnee.IServiceData;
import com.scenari.m.co.donnee.externe.XSInitDonneeSaxHandler;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.IWContenuMgr;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xsldom.xalan.processor.TransformerFactoryImpl;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDonneeExterne
implements IServiceData {
    public static TracePoint sTrace = TraceMgr.register(WSDonneeExterne.class.getName(), "Trace les transformations r\u00e9alis\u00e9es dans les donn\u00e9es de type 'externe'.");
    protected IData fSource = IData.NULL;
    protected List fTransforms = null;
    protected String fMime = null;

    public IComputedData compute(IHDialog pDialog, Object pOwner, Object pArguments, boolean pAddOwnerToExecStack) throws Exception {
        return new HDonneeCalculate(pDialog, this, pOwner, pArguments, pAddOwnerToExecStack);
    }

    public int getLevel() throws Exception {
        return this.fTransforms == null ? this.fSource.getLevel() : 3;
    }

    public final String getMime(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return this.fMime == null ? "text/plain" : this.fMime;
    }

    public String getUrlRes(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return this.fTransforms == null ? this.fSource.getUrlRes(pDialog, pOwner, pArguments) : null;
    }

    public String getString(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        if (this.fTransforms != null) {
            StringWriter vWriter = PoolBuffers.popStringWriter();
            this.writeValue(vWriter, pDialog, pOwner, pArguments);
            String vResult = vWriter.getBuffer().substring(0);
            PoolBuffers.freeStringWriter(vWriter);
            return vResult;
        }
        return this.fSource.getString(pDialog, pOwner, pArguments);
    }

    public Node getNode(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return HDonneeUtils.hGetNodeFromString(this, pDialog, pOwner, pArguments);
    }

    public boolean isResRef(IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        return this.fTransforms == null ? this.fSource.isResRef(pDialog, pOwner, pArguments) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeValue(Writer pWriter, IHDialog pDialog, Object pOwner, Object pArguments) throws Exception {
        IWService vService = (IWService)pOwner;
        if (this.fTransforms == null || this.fTransforms.size() == 0) {
            this.fSource.writeValue(pWriter, pDialog, pOwner, pArguments);
            return;
        }
        if (this.fTransforms.size() == 1) {
            String vSourceString = this.fSource.getString(pDialog, pOwner, pArguments);
            Writer vWriterSortie = pWriter;
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("Source avant transformation d'une donn\u00e9e de type 'externe' :\n" + vSourceString, new String[0]);
                vWriterSortie = new StringWriter();
            }
            try {
                Transformer vTransformer = ((Templates)this.fTransforms.get(0)).newTransformer();
                vService.hGetUnivers().hGetContenuMgr().hSetAliasPublic(vTransformer, vService.hGetPrescription());
                vTransformer.setParameter("vDialog", pDialog);
                vTransformer.setParameter("vService", pOwner);
                if (pArguments != null) {
                    vTransformer.setParameter("vArguments", pArguments);
                }
                StringReader vStrReader = new StringReader(vSourceString);
                vTransformer.transform(new StreamSource(vStrReader), new StreamResult(vWriterSortie));
                if (vWriterSortie == pWriter) return;
                vSourceString = ((StringWriter)vWriterSortie).getBuffer().toString();
                sTrace.publishDebug(vSourceString, new String[0]);
                pWriter.write(vSourceString);
                return;
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation d'une donn\u00e9e de type 'externe'.", new String[0]);
            }
        }
        TransformerFactoryImpl vTransFact = new TransformerFactoryImpl();
        try {
            String vSourceString = this.fSource.getString(pDialog, pOwner, pArguments);
            Writer vWriterSortie = pWriter;
            if (sTrace.isEnabled()) {
                sTrace.publishDebug(vSourceString, new String[0]);
                vWriterSortie = new StringWriter();
            }
            TransformerHandler[] vTransfHandlers = new TransformerHandler[this.fTransforms.size()];
            IWContenuMgr vContenuMgr = vService.hGetUnivers().hGetContenuMgr();
            for (int i = 0; i < vTransfHandlers.length; ++i) {
                vTransfHandlers[i] = ((SAXTransformerFactory)vTransFact).newTransformerHandler((Templates)this.fTransforms.get(i));
                vContenuMgr.hSetAliasPublic(vTransfHandlers[i].getTransformer(), vService.hGetPrescription());
                Transformer vTransformer = vTransfHandlers[i].getTransformer();
                vTransformer.setParameter("vDialog", pDialog);
                vTransformer.setParameter("vService", pOwner);
                if (pArguments == null) continue;
                vTransformer.setParameter("vArguments", pArguments);
            }
            XMLReader vReader = XMLReaderFactory.createXMLReader();
            vReader.setContentHandler(vTransfHandlers[0]);
            vReader.setProperty("http://xml.org/sax/properties/lexical-handler", vTransfHandlers[0]);
            for (int i = 1; i < vTransfHandlers.length; ++i) {
                vTransfHandlers[i - 1].setResult(new SAXResult(vTransfHandlers[i]));
            }
            vTransfHandlers[vTransfHandlers.length - 1].setResult(new StreamResult(vWriterSortie));
            StringReader vStrReader = new StringReader(vSourceString);
            vReader.parse(new InputSource(vStrReader));
            if (vWriterSortie == pWriter) return;
            vSourceString = ((StringWriter)vWriterSortie).getBuffer().toString();
            sTrace.publishDebug(vSourceString, new String[0]);
            pWriter.write(vSourceString);
            return;
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation d'un composant de sortie.", new String[0]);
        }
    }

    public void wSetMime(String pMimeType) {
        this.fMime = pMimeType == null ? null : pMimeType.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wSetValue(IWService pService, String pValue, ISrcNode pDocSourceBase) throws Exception {
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            InputSource vInputSource = null;
            vXmlReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(pDocSourceBase, null));
            vInputSource = new InputSource(new StringReader(pValue));
            XSInitDonneeSaxHandler vHandler = new XSInitDonneeSaxHandler(this, pService, pDocSourceBase);
            vHandler.initSaxHandlerForRoot(vXmlReader);
            vXmlReader.parse(vInputSource);
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wSetValueParRef(IWService pService, ISrcNode pDocSource) throws Exception {
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        InputStream vStream = pDocSource.newInputStream(false);
        try {
            InputSource vInputSource = null;
            vXmlReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(pDocSource, null));
            vInputSource = new InputSource(vStream);
            vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(pDocSource));
            XSInitDonneeSaxHandler vHandler = new XSInitDonneeSaxHandler(this, pService, pDocSource);
            vHandler.initSaxHandlerForRoot(vXmlReader);
            vXmlReader.parse(vInputSource);
        }
        finally {
            if (vStream != null) {
                vStream.close();
            }
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
    }

    public boolean wSetValueParSaxHandler(IWService pService, FragmentSaxHandlerBase pHandlerPere, ISrcNode pDocSourceBase) throws Exception {
        XSInitDonneeSaxHandler vHandler = new XSInitDonneeSaxHandler(this, pService, pDocSourceBase);
        vHandler.initSaxHandlerForChildren(pHandlerPere.getXMLReader());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xAddTransformXsl(String pTemplateSource, boolean pRessourceExt, ISrcNode pDocSource) throws Exception {
        TransformerFactoryImpl vTransFact = null;
        SAXSource vSource = null;
        InputStream vStream = null;
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            InputSource vInputSource;
            SrcFeaturePaths.SrcNodeResolver vResolverXsl;
            if (pRessourceExt) {
                vResolverXsl = SrcFeaturePaths.newSrcNodeResolver(SrcFeaturePaths.findNodeByPath(pDocSource, pTemplateSource, true), null);
                vStream = vResolverXsl.newInputStream(false);
                vInputSource = new InputSource(vStream);
                vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolverXsl));
                vSource = new SAXSource(vXmlReader, vInputSource);
                if (vStream == null) {
                    throw LogMgr.newException("Le fichier template XSL '" + pTemplateSource + "' est introuvable.", new String[0]);
                }
            } else {
                vResolverXsl = SrcFeaturePaths.newSrcNodeResolver(pDocSource, null);
                vInputSource = new InputSource(new StringReader(pTemplateSource.trim()));
                vInputSource.setSystemId(vResolverXsl.getSrcUri());
                vSource = new SAXSource(vXmlReader, vInputSource);
            }
            vXmlReader.setEntityResolver(vResolverXsl);
            vTransFact = new TransformerFactoryImpl();
            ((TransformerFactory)vTransFact).setURIResolver(vResolverXsl);
            Templates vTemplates = ((TransformerFactory)vTransFact).newTemplates(vSource);
            if (this.fTransforms == null) {
                this.fTransforms = new ArrayList();
            }
            this.fTransforms.add(vTemplates);
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Echec \u00e0 la compilation d'un template XSL d'une donn\u00e9e externe :\n" + pTemplateSource, new String[0]);
        }
        finally {
            if (vStream != null) {
                vStream.close();
            }
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
    }

    protected void xInitEnd() throws Exception {
    }
}

