/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.donnee.externe;

import com.scenari.m.co.donnee.HSDonneeMgr;
import com.scenari.m.co.donnee.IServiceData;
import com.scenari.m.co.donnee.externe.WSDonneeExterne;
import com.scenari.m.co.service.IWService;
import com.scenari.s.fw.util.xml.HExtraitSaxHandlerToText;
import com.scenari.s.fw.util.xml.HExtraitSaxHandlerToXml;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import org.xml.sax.Attributes;

public class XSInitDonneeSaxHandler
extends FragmentSaxHandlerBase {
    public static final String TAG_ROOT_DONNEE = "sourceexterne";
    public static final String TAG_SOURCE = "source";
    public static final String TAG_TRANSFORMATIONXSL = "transformationxsl";
    public static final String TAG_XXX_ATT_HREF = "href";
    protected ISrcNode fCurrentDocSource = null;
    protected IWService fService = null;
    protected WSDonneeExterne fDonnee = null;
    protected IServiceData fCurrentDonnee = null;
    protected boolean fCurrentTransform = false;
    protected HExtraitSaxHandlerToText fSaxHandlerToText = null;
    protected HExtraitSaxHandlerToXml fSaxHandlerToXml = null;

    public XSInitDonneeSaxHandler(WSDonneeExterne pDonnee, IWService pService, ISrcNode pSource) {
        this.fDonnee = pDonnee;
        this.fService = pService;
        this.fCurrentDocSource = pSource;
    }

    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (this.fCurrentDonnee != null) {
            if (this.fSaxHandlerToText.hGetStringBuilder().length() > 0) {
                try {
                    this.fCurrentDonnee.wSetValue(this.fService, this.fSaxHandlerToText.hGetStringBuilder().substring(0), this.fCurrentDocSource);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation du contenu d'une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            } else {
                try {
                    this.fCurrentDonnee.wSetValue(this.fService, "", this.fCurrentDocSource);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation d'une chaine vide ('') dans une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            }
            this.fCurrentDonnee = null;
        } else if (this.fCurrentTransform) {
            if (this.fSaxHandlerToXml.hGetStringBuilder().length() > 0) {
                this.fDonnee.xAddTransformXsl(this.fSaxHandlerToXml.hGetStringBuilder().substring(0), false, this.fCurrentDocSource);
            }
            this.fCurrentTransform = false;
        } else if (this.isRootElt()) {
            this.fDonnee.xInitEnd();
        }
    }

    public IServiceData xNewDonnee(String pType, Attributes pAttributes) throws Exception {
        IServiceData vResult = null;
        String vHRef = pAttributes.getValue(TAG_XXX_ATT_HREF);
        if (vHRef != null && !vHRef.equals("")) {
            try {
                vResult = HSDonneeMgr.hNewDonneeParRef(pType, this.fService, SrcFeaturePaths.findNodeByPath(this.fCurrentDocSource, vHRef, true));
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + pType + "' et de ref externe '" + vHRef + "'.", new String[0]);
            }
        }
        try {
            vResult = HSDonneeMgr.hNewDonnee(pType, this.fService, this.fCurrentDocSource);
            if (!vResult.wSetValueParSaxHandler(this.fService, this, this.fCurrentDocSource)) {
                this.fCurrentDonnee = vResult;
                if (this.fSaxHandlerToText == null) {
                    this.fSaxHandlerToText = new HExtraitSaxHandlerToText();
                    this.fSaxHandlerToText.hSetStringBuilder(new StringBuilder(256));
                }
                this.fSaxHandlerToText.hGetStringBuilder().setLength(0);
                this.fSaxHandlerToText.hSetXmlReader(this.fXMLReader, false);
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + pType + "'.", new String[0]);
        }
        return vResult;
    }

    public IServiceData xNewDonnee(Attributes pAttributes) throws Exception {
        return this.xNewDonnee(pAttributes.getValue("type"), pAttributes);
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if (TAG_SOURCE == pLocalName) {
            this.fDonnee.fSource = this.xNewDonnee(pAttributes);
        } else if (TAG_TRANSFORMATIONXSL == pLocalName) {
            String vHref = pAttributes.getValue(TAG_XXX_ATT_HREF);
            if (vHref != null && !"".equals(vHref)) {
                this.fDonnee.xAddTransformXsl(vHref, true, this.fCurrentDocSource);
            } else {
                if (this.fSaxHandlerToXml == null) {
                    this.fSaxHandlerToXml = new HExtraitSaxHandlerToXml();
                    this.fSaxHandlerToXml.hSetStringBuilder(new StringBuilder(256));
                }
                this.fSaxHandlerToXml.hGetStringBuilder().setLength(0);
                this.fSaxHandlerToXml.hSetXmlReader(this.fXMLReader, false);
                this.fCurrentTransform = true;
            }
        }
        return true;
    }
}

