/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.instance;

import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.instance.HInstanceSaxHandlerBase;
import com.scenari.m.co.instance.IWInstFormation;
import com.scenari.m.co.prescription.IWPrescription;
import com.scenari.m.co.univers.IWInstanceDef;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.IUserMgr;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.ElementImpl;
import com.scenari.xsldom.xml.utils.PrefixResolverDefault;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.DomHelper;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class HInstanceInMem
extends DocumentImpl
implements IWInstFormation {
    protected String fID = null;
    protected IWPrescription fPrescr = null;
    protected String[] fCodesRoles = null;
    protected IUser[][] fActeurs = null;
    protected Element fParentAllAgents = null;
    protected IWAgent fAgentRoot = null;
    protected Element fEtatRoot = null;
    protected ArrayList fXPathContextStack = new ArrayList(2);

    protected HInstanceInMem() {
        super(false);
    }

    public HInstanceInMem(IWPrescription pPresc, IWInstanceDef pInstDef) throws Exception {
        super(false);
        this.fPrescr = pPresc;
        this.fID = pInstDef.hGetID();
        this.xCreateDom();
        this.wDefinitionUpdated(pInstDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hFreeXPathContext(XPathContext pXPathContext) {
        pXPathContext.reset();
        pXPathContext.getVarStack().reset();
        pXPathContext.getSourceTreeManager().reset();
        pXPathContext.getSourceTreeManager().setURIResolver(null);
        ArrayList arrayList = this.fXPathContextStack;
        synchronized (arrayList) {
            this.fXPathContextStack.add(pXPathContext);
        }
    }

    public IUser hGetActeurByRole(String pRole) throws Exception {
        for (int i = 0; i < this.fCodesRoles.length; ++i) {
            if (!this.fCodesRoles[i].equals(pRole) || this.fActeurs[i].length <= 0) continue;
            return this.fActeurs[i][0];
        }
        return null;
    }

    public IUser[] hGetActeursByRole(String pRole) throws Exception {
        for (int i = 0; i < this.fCodesRoles.length; ++i) {
            if (!this.fCodesRoles[i].equals(pRole)) continue;
            return this.fActeurs[i];
        }
        return null;
    }

    public IWAgent hGetAgent(IWComposant pComposant) throws Exception {
        IWAgent vResult = this.hGetAgentPrinc(pComposant.hGetComposantPrincipal().hGetCode());
        if (vResult != null && !pComposant.hIsComposantPrincipal()) {
            vResult = this.xGetAgentAssoc(vResult, pComposant);
        }
        return vResult;
    }

    public IWAgent hGetAgentParRef(String pRef) throws Exception {
        return this.hGetAgentRoot().hGetAgentParRef(pRef);
    }

    public synchronized IWAgent hGetAgentPrinc(String pCode) throws Exception {
        IWComposant vComp;
        IWAgent vResult = this.xLookForAgentPrinc(pCode = this.wResolveCodeAgent(null, pCode));
        if (vResult == null && (vComp = this.fPrescr.hGetUnivers().hGetContenuMgr().hGetComposantPrincParCode(this.fPrescr, pCode)) != null) {
            vResult = vComp.hNewAgent(this);
            vResult.wInit();
            this.fParentAllAgents.appendChild((Node)((Object)vResult));
        }
        return vResult;
    }

    public IWAgent hGetAgentRoot() throws Exception {
        if (this.fAgentRoot == null && this.fPrescr != null) {
            this.fAgentRoot = this.hGetAgentPrinc(this.fPrescr.hGetIdNoeudDepart());
        }
        return this.fAgentRoot;
    }

    public String hGetEtat(String pCodeEtat) {
        String vResult = null;
        if (this.fEtatRoot == null) {
            this.fEtatRoot = DomHelper.getFirstElementChildOrCreate(this.getDocumentElement(), "etat");
        }
        if ((vResult = this.fEtatRoot.getAttribute(pCodeEtat)) != null && vResult.length() == 0) {
            vResult = null;
        }
        return vResult;
    }

    public String hGetID() {
        return this.fID;
    }

    public IWPrescription hGetPrescription() {
        return this.fPrescr;
    }

    public boolean hIsRole(IUser pActeur, String pRole) {
        for (int i = 0; i < this.fCodesRoles.length; ++i) {
            if (!this.fCodesRoles[i].equals(pRole)) continue;
            for (int ii = 0; ii < this.fActeurs[i].length; ++ii) {
                if (pActeur != this.fActeurs[i][ii]) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathContext hPopXPathContext() {
        XPathContext vResult = null;
        ArrayList arrayList = this.fXPathContextStack;
        synchronized (arrayList) {
            if (this.fXPathContextStack.size() > 0) {
                vResult = (XPathContext)this.fXPathContextStack.remove(this.fXPathContextStack.size() - 1);
            }
        }
        return vResult == null ? new XPathContext() : vResult;
    }

    public void hSetEtat(String pCodeEtat, String pValeurEtat) {
        if (this.fEtatRoot == null) {
            this.fEtatRoot = DomHelper.getFirstElementChildOrCreate(this.getDocumentElement(), "etat");
        }
        this.fEtatRoot.setAttribute(pCodeEtat, pValeurEtat);
    }

    public ContentHandler wGetSaxHandlerForLoadInstance() {
        return new HInstanceSaxHandlerBase(this);
    }

    public void wDefinitionUpdated(IWInstanceDef pInstDef) throws Exception {
        if (this.fID != null && !this.fID.equals(pInstDef.hGetID())) {
            throw new Exception("Il est impossible de modifier l'id d'une prescription d'une instance d\u00e9j\u00e0 cr\u00e9\u00e9e. Ancien ID : '" + this.fID + "' Nouvel ID : '" + pInstDef.hGetID() + "'.");
        }
        this.fCodesRoles = pInstDef.hGetRolesCodes();
        if (this.fPrescr != null) {
            IUserMgr vActMgr = this.fPrescr.hGetUnivers().getUserMgr();
            String[][] vActeursIds = pInstDef.hGetActeursId();
            this.fActeurs = new IUser[vActeursIds.length][];
            for (int i = 0; i < vActeursIds.length; ++i) {
                String[] vListIds = vActeursIds[i];
                if (vListIds == null) {
                    this.fActeurs[i] = new IUser[0];
                    continue;
                }
                this.fActeurs[i] = new IUser[vListIds.length];
                IUser[] vListActeurs = this.fActeurs[i];
                for (int ii = 0; ii < vListIds.length; ++ii) {
                    vListActeurs[ii] = vActMgr.getUser(vListIds[ii]);
                }
            }
        }
    }

    public void wDeleteInstance() throws Exception {
    }

    public void wProductionUpdated(IWAgent pAgent) {
    }

    public void wSaveIfNecessary(IHDialog pDialog) throws Exception {
    }

    public String wResolveCodeAgent(IWAgent pContext, String pCodeAgent) throws Exception {
        if (pCodeAgent.startsWith("{") && pCodeAgent.endsWith("}")) {
            XPathContext vXPathContext = this.hPopXPathContext();
            try {
                XPath vXPath = XPath.createXPath(pCodeAgent.substring(1, pCodeAgent.length() - 1), null, PrefixResolverDefault.DEFAULT, 0);
                pCodeAgent = vXPath.execute(vXPathContext, pContext != null ? (Element)((Object)pContext) : this.getDocumentElement()).str();
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'\u00e9xecution du code agent dynamique : " + pCodeAgent, new String[0]);
            }
            finally {
                this.hFreeXPathContext(vXPathContext);
            }
        }
        return pCodeAgent;
    }

    public String toString() {
        return "<instance id=\"" + this.fID + "\">" + this.fPrescr + "</instance>";
    }

    protected IWAgent xGetAgentAssoc(IWAgent pAgentPrinc, IWComposant pComposantAssoc) throws Exception {
        IWAgent vResult = null;
        IWComposant vCompPere = pComposantAssoc.hGetComposantPere();
        vResult = vCompPere.hIsComposantPrincipal() ? pAgentPrinc.hGetAgentAssoc(pComposantAssoc.hGetCode()) : this.xGetAgentAssoc(pAgentPrinc, vCompPere).hGetAgentAssoc(pComposantAssoc.hGetCode());
        return vResult;
    }

    protected void xCreateDom() {
        Element vRoot = this.createElement("in");
        vRoot.setAttribute("id", this.fID);
        this.fEtatRoot = this.createElement("etat");
        vRoot.appendChild(this.fEtatRoot);
        ((ElementImpl)this.fEtatRoot).setComplete(true);
        this.fParentAllAgents = this.createElement("co");
        vRoot.appendChild(this.fParentAllAgents);
        this.appendChild(vRoot);
    }

    protected IWAgent xLookForAgentPrinc(String pCode) {
        for (Node vCh = this.fParentAllAgents.getFirstChild(); vCh != null; vCh = vCh.getNextSibling()) {
            if (!vCh.getNodeName().equals(pCode)) continue;
            return (IWAgent)((Object)vCh);
        }
        return null;
    }
}

