/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.service;

import com.scenari.m.co.donnee.HSDonneeMgr;
import com.scenari.m.co.donnee.IServiceData;
import com.scenari.m.co.prescription.IWPrescription;
import com.scenari.m.co.service.IWServiceLoader;
import com.scenari.m.co.service.WService;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.s.fw.util.xml.HExtraitSaxHandlerToText;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.universe.execframe.IExecFrame;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class HServiceLoader
extends FragmentSaxHandlerBase
implements IWServiceLoader {
    protected static final String TAG_DESCRIPTIF = "descriptif";
    protected static final String TAG_ICONE = "icone";
    protected static final String TAG_IMPORT = "import";
    protected static final String TAG_INJECT_EXECFRAME = "injectInExecFrame";
    protected static final String TAG_INTITULE = "intitule";
    protected static final String TAG_ROOT_ATT_CODE = "code";
    protected static final String TAG_XXX_ATT_HREF = "href";
    protected static final String TAG_XXX_ATT_LANGAGE = "langage";
    protected static final String TAG_ROOT_ATT_RACINE_XPATH = "racine";
    protected IWUnivers fUnivers = null;
    protected IWPrescription fPrescription = null;
    protected WService fCurrentService = null;
    protected HExtraitSaxHandlerToText fSaxHandlerToText = null;
    protected IServiceData fCurrentDonnee = null;
    protected ISrcNode fCurrentDocSource = null;
    protected boolean fSousDocument = false;

    public void endDocument() throws SAXException {
        if (!this.fSousDocument) {
            super.endDocument();
        }
    }

    public void hSetDocSource(ISrcNode pDocSource) {
        this.fCurrentDocSource = pDocSource;
    }

    public void hSetPrescription(IWPrescription pPrescription) {
        this.fPrescription = pPrescription;
        if (this.fPrescription != null) {
            this.fUnivers = this.fPrescription.hGetUnivers();
        }
    }

    public void hSetUnivers(IWUnivers pUnivers) {
        this.fUnivers = pUnivers;
    }

    public void startDocument() throws SAXException {
        if (!this.fSousDocument) {
            super.startDocument();
        }
    }

    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (this.fCurrentDonnee != null) {
            if (this.fSaxHandlerToText.hGetStringBuilder().length() > 0) {
                try {
                    this.fCurrentDonnee.wSetValue(this.fCurrentService, this.fSaxHandlerToText.hGetStringBuilder().substring(0), this.fCurrentDocSource);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation du contenu d'une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            } else {
                try {
                    this.fCurrentDonnee.wSetValue(this.fCurrentService, "", this.fCurrentDocSource);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec lors de l'affectation d'une chaine vide ('') dans une donn\u00e9e de type " + this.fCurrentDonnee.getClass().getName(), new String[0]);
                }
            }
            this.fCurrentDonnee = null;
        }
    }

    public IServiceData xNewDonnee(String pType, Attributes pAttributes) throws Exception {
        IServiceData vResult = null;
        String vHRef = pAttributes.getValue(TAG_XXX_ATT_HREF);
        if (vHRef != null && !vHRef.equals("")) {
            try {
                vResult = HSDonneeMgr.hNewDonneeParRef(pType, this.fCurrentService, SrcFeaturePaths.findNodeByPath(this.fCurrentDocSource, vHRef, true));
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + pType + "' et de ref externe '" + vHRef + "'.", new String[0]);
            }
        }
        try {
            vResult = HSDonneeMgr.hNewDonnee(pType, this.fCurrentService, this.fCurrentDocSource);
            if (!vResult.wSetValueParSaxHandler(this.fCurrentService, this, this.fCurrentDocSource)) {
                this.fCurrentDonnee = vResult;
                if (this.fSaxHandlerToText == null) {
                    this.fSaxHandlerToText = new HExtraitSaxHandlerToText();
                    this.fSaxHandlerToText.hSetStringBuilder(new StringBuilder(256));
                }
                this.fSaxHandlerToText.hGetStringBuilder().setLength(0);
                this.fSaxHandlerToText.hSetXmlReader(this.fXMLReader, false);
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'ajout d'une donn\u00e9e de type '" + pType + "'.", new String[0]);
        }
        return vResult;
    }

    public IServiceData xNewDonnee(Attributes pAttributes) throws Exception {
        return this.xNewDonnee(pAttributes.getValue("type"), pAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        boolean vResult = false;
        if (this.fCurrentService != null) {
            if (pLocalName == TAG_INTITULE) {
                this.fCurrentService.xSetIntitule(this.xNewDonnee(pAttributes));
                vResult = true;
            } else if (pLocalName == TAG_ICONE) {
                this.fCurrentService.xSetIcone(this.xNewDonnee(pAttributes));
                vResult = true;
            } else if (pLocalName == TAG_DESCRIPTIF) {
                this.fCurrentService.xSetDescriptif(this.xNewDonnee(pAttributes));
                vResult = true;
            } else if (pLocalName == TAG_INJECT_EXECFRAME) {
                String vCode = pAttributes.getValue(TAG_ROOT_ATT_CODE);
                IExecFrame vExecFrame = this.fUnivers.getExecFrame(vCode);
                if (vExecFrame != null) {
                    FragmentSaxHandlerBase vSubHanlder = vExecFrame.injectParams();
                    vSubHanlder.initSaxHandlerForChildren(this.fXMLReader);
                }
                vResult = true;
            }
        }
        if (pLocalName == TAG_IMPORT) {
            block17: {
                String vUriImport = pAttributes.getValue(TAG_XXX_ATT_HREF);
                ISrcNode vCurrentDocSource = this.fCurrentDocSource;
                boolean vCurrentSousDocument = this.fSousDocument;
                XMLReader vCurrentXMLReader = this.fXMLReader;
                InputSource vSource = null;
                InputStream vInputStream = null;
                try {
                    this.fCurrentDocSource = SrcFeaturePaths.findNodeByPath(this.fCurrentDocSource, vUriImport, true);
                    vInputStream = this.fCurrentDocSource.newInputStream(false);
                    if (vInputStream != null) {
                        vSource = new InputSource(vInputStream);
                        vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(this.fCurrentDocSource));
                        this.fXMLReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                        this.fSousDocument = true;
                        this.fXMLReader.setContentHandler(this);
                        this.fXMLReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(this.fCurrentDocSource, null));
                        this.fXMLReader.parse(vSource);
                        HPoolXmlReader.hGet().hFreeXmlReader(this.fXMLReader);
                        this.fXMLReader = vCurrentXMLReader;
                        break block17;
                    }
                    throw LogMgr.newException("Le fichier '" + vUriImport + "' (" + this.fCurrentDocSource + ") est introuvable.", new String[0]);
                }
                catch (Throwable e) {
                    LogMgr.publishException(e, "Echec \u00e0 l'import du fichier '" + vUriImport + ".", new String[0]);
                    if (vInputStream != null) {
                        vInputStream.close();
                    }
                }
                finally {
                    this.fCurrentDocSource = vCurrentDocSource;
                    this.fSousDocument = vCurrentSousDocument;
                    this.fXMLReader = vCurrentXMLReader;
                }
            }
            vResult = true;
        }
        return vResult;
    }
}

