/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.service;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.donnee.IAgentData;
import com.scenari.m.co.donnee.IServiceData;
import com.scenari.m.co.prescription.IWPrescription;
import com.scenari.m.co.service.IWSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.IWUnivers;
import eu.scenari.fw.log.LogMgr;

public abstract class WService
implements IWService {
    protected String fCode = null;
    protected IWUnivers fUnivers = null;
    protected IWPrescription fPrescription = null;
    protected IServiceData fIcone = IServiceData.NULL;
    protected IServiceData fIntitule = IServiceData.NULL;
    protected IServiceData fDescriptif = IServiceData.NULL;
    protected String fUrlPublication = null;
    protected String fUrn = null;

    public final String hGetAncre() {
        return this.fPrescription == null ? "/u" : "/p";
    }

    public final String hGetCode() {
        return this.fCode;
    }

    public final IServiceData hGetDescriptif() {
        return this.fDescriptif;
    }

    public final IServiceData hGetIcone() {
        return this.fIcone;
    }

    public final IServiceData hGetIntitule() {
        return this.fIntitule;
    }

    public final IWPrescription hGetPrescription() {
        return this.fPrescription;
    }

    public final IWUnivers hGetUnivers() {
        return this.fUnivers;
    }

    public final String hGetUrn() {
        if (this.fUrn == null) {
            StringBuilder vBuf = new StringBuilder(64);
            vBuf.append(this.hGetAncre());
            vBuf.append("/");
            if (this.fPrescription != null) {
                vBuf.append(this.fPrescription.hGetID());
                vBuf.append("/");
            }
            vBuf.append(this.fCode);
            this.fUrn = vBuf.substring(0);
        }
        return this.fUrn;
    }

    public IWSDialog hNewDialog(IHDialog pDialogBase) {
        IWSDialog vResult = this.hNewDialog();
        vResult.hInitFromDialogPrec(pDialogBase);
        return vResult;
    }

    public String toString() {
        return this.toXMLString();
    }

    public String toXMLString() {
        String vResult = "";
        boolean vHasDetail = false;
        vResult = vResult + "<service ";
        vResult = vResult + "code=\"";
        vResult = vResult + this.hGetCode();
        vResult = vResult + "\">";
        if (this.hGetIntitule() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<intitule>";
            vResult = vResult + this.hGetIntitule().toString();
            vResult = vResult + "</intitule>";
        }
        if (this.hGetIcone() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<icone>";
            vResult = vResult + this.hGetIcone().toString();
            vResult = vResult + "</icone>";
        }
        if (this.hGetDescriptif() != IAgentData.NULL) {
            if (!vHasDetail) {
                vHasDetail = true;
                vResult = vResult + "<detail>";
            }
            vResult = vResult + "<descriptif>";
            vResult = vResult + this.hGetDescriptif().toString();
            vResult = vResult + "</descriptif>";
        }
        if (vHasDetail) {
            vResult = vResult + "</detail>";
        }
        vResult = vResult + "</service>";
        return vResult;
    }

    public void wInitAndLinkServices() throws Exception {
    }

    public final String wGetUrlPublication() {
        return this.fUrlPublication;
    }

    public void wInit(IWPrescription pPrescription, String pCode) throws Exception {
        this.fPrescription = pPrescription;
        this.fUnivers = pPrescription.hGetUnivers();
        this.fCode = pCode;
        this.fPrescription.hAddService(this);
    }

    public void wInit(IWUnivers pUniverse, String pCode) throws Exception {
        if (pCode == null || pCode.length() == 0) {
            throw LogMgr.newException("Empty code for service type %s", this.getClass().getName());
        }
        this.fUnivers = pUniverse;
        this.fPrescription = null;
        this.fCode = pCode;
        pUniverse.wAddService(this);
    }

    public void wRemoveService() throws Exception {
    }

    public void wSetUrlPublication(String pUrlPublication) {
        this.fUrlPublication = pUrlPublication;
    }

    public final void xSetDescriptif(IServiceData pDescriptif) {
        this.fDescriptif = pDescriptif;
    }

    public final void xSetIcone(IServiceData pIcone) {
        this.fIcone = pIcone;
    }

    public final void xSetIntitule(IServiceData pIntitule) {
        this.fIntitule = pIntitule;
    }
}

