/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.service.sourcedav;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.HInitParamsWebdav;
import com.scenari.m.co.dialog.webdav.HSDialogWebdav;
import com.scenari.m.co.dialog.webdav.HWebdavResource;
import com.scenari.m.co.dialog.webdav.WResultatError;
import com.scenari.m.co.dialog.webdav.WResultatGet;
import com.scenari.m.co.dialog.webdav.WResultatOptions;
import com.scenari.m.co.dialog.webdav.WResultatPropfind;
import com.scenari.m.co.dialog.webdav.WResultatSimpleStatus;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.service.sourcedav.HSourceDavResource;
import com.scenari.m.co.service.sourcedav.WServiceSourceDav;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.NotAllowedException;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.rights.SrcFeatureRights;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.feature.uris.SrcFeatureUris;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;

public class HSDialogSourceDav
extends HSDialogWebdav {
    public static final WResultatOptions OPTIONS_NULL = new WResultatOptions("1").hUpdateForNullRessource();
    public static final WResultatOptions OPTIONS_FILE = new WResultatOptions("1").hSetMKCOL(false);
    public static final WResultatOptions OPTIONS_FILE_READONLY = OPTIONS_FILE.hClone().hSetPUT(false);
    public static final WResultatOptions OPTIONS_NORIGHTS = new WResultatOptions("1").hUpdateForNullRessource().hSetMKCOL(false).hSetPUT(false);
    public static final WResultatOptions OPTIONS_FOLDER = new WResultatOptions("1").hSetPUT(false);
    public static String sPageNonDav = "/serv/sourcedav.jsp";
    public static int sPropfindMaxResources = 3000;
    protected ISrcNode fSource = null;

    public HSDialogSourceDav(IWService pService) {
        super(pService);
        this.fPageResultatNonDav = sPageNonDav;
    }

    public boolean hNeedAuthentification() {
        boolean vResult = true;
        try {
            vResult = !"N".equalsIgnoreCase(((WServiceSourceDav)this.fService).hGetNeedAuthentification().getString(this, this.fService, null));
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        return vResult;
    }

    protected String xGetPageResultatErreur() {
        return sPageNonDav;
    }

    protected IHDialog xDoOptions() throws Exception {
        int vStatus = this.xLoadSource();
        this.fPageResultatDav = vStatus == -1 ? OPTIONS_NULL : (SrcFeatureRights.isAllowed(this.fSource, 3) ? (vStatus == 1 ? (SrcFeatureRights.isAllowed(this.fSource, 508) ? OPTIONS_FILE : OPTIONS_FILE_READONLY) : OPTIONS_FOLDER) : OPTIONS_NORIGHTS);
        return this;
    }

    protected IHDialog xDoPropfindAll() throws Exception {
        int vStatus = this.xCheckSource();
        if (vStatus > -1) {
            this.fPageResultatDav = new WResultatPropfind();
            this.xAppendResultatPropfindAll(this.fSource, vStatus, this.xGetPublicRootUrl(), 0);
        }
        return this;
    }

    protected void xAppendResultatPropfindAll(ISrcNode pSource, int pStatus, String pUrlEspace, int pDepth) throws Exception {
        WResultatPropfind vResult = (WResultatPropfind)this.fPageResultatDav;
        int vStatusSrc = pSource.getContentStatus();
        if (vStatusSrc > -1 && vResult.hGetSize() < sPropfindMaxResources) {
            HWebdavResource vResource = this.xCreateWebdavResource(pSource);
            vResult.hAddResource(vResource);
            vResource.hSetUrlRoot(pUrlEspace);
            vResource.hSetUriInRoot(pSource.getSrcUri());
            long vDate = pSource.getLastModif();
            if (vDate > 0L) {
                vResource.hSetModifDate(new Date(vDate));
            }
            if (pStatus == 1) {
                vResource.hSetResourceType("");
                vResource.hSetContentLength(pSource.getContentSize());
            } else {
                vResource.hSetResourceType("collection");
                if (pDepth < this.fParamEntree.fDepth) {
                    ArrayList<ISrcNode> vFils = new ArrayList<ISrcNode>();
                    pSource.listChildrenNodes(vFils);
                    for (int i = 0; i < vFils.size(); ++i) {
                        ISrcNode vSourceFils = (ISrcNode)vFils.get(i);
                        this.xAppendResultatPropfindAll(vSourceFils, vSourceFils.getContentStatus(), pUrlEspace, pDepth + 1);
                    }
                }
            }
        }
    }

    protected IHDialog xDoPropfindFilter() throws Exception {
        int vStatus = this.xCheckSource();
        if (vStatus > -1) {
            this.fPageResultatDav = new WResultatPropfind();
            this.xAppendResultatPropfindFilter(this.fSource, vStatus, this.xGetPublicRootUrl(), 0);
        }
        return this;
    }

    protected void xAppendResultatPropfindFilter(ISrcNode pSource, int pStatus, String pUrlEspace, int pDepth) throws Exception {
        WResultatPropfind vResult = (WResultatPropfind)this.fPageResultatDav;
        HWebdavResource vResource = this.xCreateWebdavResource(pSource);
        if (vResult.hGetSize() < sPropfindMaxResources) {
            long vDate;
            vResult.hAddResource(vResource);
            vResource.hSetUrlRoot(pUrlEspace);
            vResource.hSetUriInRoot(pSource.getSrcUri());
            if (this.xIsPropertyRequired("DAV:", "getlastmodified") && (vDate = pSource.getLastModif()) > 0L) {
                vResource.hSetModifDate(new Date(vDate));
            }
            if (this.xIsPropertyRequired("DAV:", "displayname")) {
                vResource.hConstructDisplayNameFromPath();
            }
            if (pStatus == 1) {
                if (this.xIsPropertyRequired("DAV:", "resourcetype")) {
                    vResource.hSetResourceType("");
                }
                if (this.xIsPropertyRequired("DAV:", "getcontentlength")) {
                    vResource.hSetContentLength(pSource.getContentSize());
                }
            } else {
                vResource.hSetResourceType("collection");
                if (pDepth < this.fParamEntree.fDepth) {
                    ArrayList<ISrcNode> vFils = new ArrayList<ISrcNode>();
                    pSource.listChildrenNodes(vFils);
                    for (int i = 0; i < vFils.size(); ++i) {
                        ISrcNode vSourceFils = (ISrcNode)vFils.get(i);
                        this.xAppendResultatPropfindFilter(vSourceFils, vSourceFils.getContentStatus(), pUrlEspace, pDepth + 1);
                    }
                }
            }
        }
    }

    protected boolean xIsPropertyRequired(String pNameSpace, String pProperty) {
        ArrayList vList = (ArrayList)this.fParamEntree.fContent;
        for (int i = 0; i < vList.size(); i += 3) {
            if (!((String)vList.get(i)).equals(pNameSpace) || !((String)vList.get(i + 1)).equals(pProperty)) continue;
            return true;
        }
        return false;
    }

    protected IHDialog xDoPropfindName() throws Exception {
        return this.xDoPropfindAll();
    }

    protected IHDialog xDoGetHeadDownload(boolean pWithBody) throws Exception {
        int vStatus = this.xCheckSource();
        if (vStatus == 1) {
            if (SrcFeatureRights.isAllowed(this.fSource, 1)) {
                ISrcNode vDocSource = this.fSource;
                WResultatGet vResult = new WResultatGet();
                long vDate = vDocSource.getLastModif();
                if (vDate > 0L) {
                    vResult.hSetLastModifDate(vDate);
                }
                vResult.hSetLength(vDocSource.getContentSize());
                String vContentType = vDocSource.getContentType();
                if (vContentType == null) {
                    vContentType = MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vDocSource.getSrcUri());
                }
                vResult.hSetContentType(vContentType);
                if (!this.fParamEntree.fPathRessource.equals(vDocSource.getSrcUri())) {
                    vResult.hSetContentLocation(vDocSource.getSrcUri());
                }
                if (pWithBody) {
                    vResult.hSetInputStream(vDocSource.newInputStream(false));
                    if (this.hGetCdAction() == "Download") {
                        vResult.hSetDownloadNameFile(this.fSource.getSrcName());
                    }
                }
                this.fPageResultatDav = vResult;
            } else {
                this.fPageResultatDav = new WResultatSimpleStatus(403);
            }
        } else if (vStatus == 2) {
            this.fPageResultatDav = SrcFeatureRights.isAllowed(this.fSource, 2) ? new WResultatSimpleStatus(204) : new WResultatSimpleStatus(403);
        }
        return this;
    }

    protected IHDialog xDoPut() throws Exception {
        int vStatus = this.xLoadSource();
        if (SrcFeatureRights.isAllowed(this.fSource, 4)) {
            if (vStatus == -2) {
                this.fPageResultatDav = new WResultatError(409);
            } else if (!this.fParamEntree.fOverwrite && vStatus != -1) {
                this.fPageResultatDav = new WResultatError(412);
            } else {
                SrcFeatureStreams.writeFrom(this.fSource, (InputStream)this.fParamEntree.fContent);
                this.fPageResultatDav = new WResultatSimpleStatus(vStatus == -1 ? 201 : 204);
            }
        } else {
            this.fPageResultatDav = new WResultatError(403);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHDialog xDoCopy() throws Exception {
        int vStatusSrc = this.xLoadSource();
        if (vStatusSrc == -1) {
            this.fPageResultatDav = new WResultatError(404);
            return this;
        }
        if (vStatusSrc == -2) {
            this.fPageResultatDav = new WResultatError(409);
            return this;
        }
        if (this.fParamEntree.fDestination == null) {
            this.fPageResultatDav = new WResultatError(400);
            return this;
        }
        String vUrlDst = this.fParamEntree.hExtractDestPath(this.xGetPublicRootUrl());
        if (vUrlDst == null) {
            this.fPageResultatDav = new WResultatError(400);
            return this;
        }
        ISrcNode vDst = this.xGetDst(vUrlDst);
        int vStatutDst = vDst.getContentStatus();
        if (vStatutDst == -2) {
            this.fPageResultatDav = new WResultatError(409);
            return this;
        }
        if (this.xIsDstInSrc(vDst, this.fSource)) {
            this.fPageResultatDav = new WResultatError(403);
            return this;
        }
        if (vStatutDst != -1 && !this.fParamEntree.fOverwrite) {
            this.fPageResultatDav = new WResultatError(412);
            return this;
        }
        try {
            block17: {
                if (vStatusSrc == 1) {
                    if (SrcFeatureRights.isAllowed(vDst, 4 | (vStatutDst == -1 ? 32 : 0)) && SrcFeatureRights.isAllowed(this.fSource, 1)) {
                        SrcFeatureCopyMove.copy(this.fSource, vDst);
                        break block17;
                    } else {
                        this.fPageResultatDav = new WResultatError(403);
                        return this;
                    }
                }
                if (vStatutDst == -1) {
                    if (SrcFeatureRights.isAllowed(vDst, 64) && SrcFeatureRights.isAllowed(this.fSource, 2)) {
                        SrcFeatureCopyMove.copy(this.fSource, vDst);
                        break block17;
                    } else {
                        this.fPageResultatDav = new WResultatError(403);
                        return this;
                    }
                }
                if (SrcFeatureRights.isAllowed(vDst, 72) && SrcFeatureRights.isAllowed(this.fSource, 2)) {
                    SrcFeatureCopyMove.copy(this.fSource, vDst);
                } else {
                    this.fPageResultatDav = new WResultatError(403);
                    return this;
                }
            }
            this.fPageResultatDav = new WResultatSimpleStatus(vStatutDst == -1 ? 201 : 204);
            return this;
        }
        catch (Exception e) {
            this.fPageResultatDav = new WResultatError(500, LogMgr.getMessage(e));
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHDialog xDoMove() throws Exception {
        int vStatusSrc = this.xLoadSource();
        if (vStatusSrc == -1) {
            this.fPageResultatDav = new WResultatError(404);
            return this;
        }
        if (vStatusSrc == -2) {
            this.fPageResultatDav = new WResultatError(409);
            return this;
        }
        String vUrlDst = this.fParamEntree.hExtractDestPath(this.xGetPublicRootUrl());
        if (vUrlDst == null) {
            this.fPageResultatDav = new WResultatError(400);
            return this;
        }
        ISrcNode vDst = this.xGetDst(vUrlDst);
        int vStatutDst = vDst.getContentStatus();
        if (vStatutDst == -2) {
            this.fPageResultatDav = new WResultatError(409);
            return this;
        }
        if (this.xIsDstInSrc(vDst, this.fSource)) {
            this.fPageResultatDav = new WResultatError(403);
            return this;
        }
        if (vStatutDst != -1) {
            if (!this.fParamEntree.fOverwrite) {
                this.fPageResultatDav = new WResultatError(412);
                return this;
            }
            vDst.removeSrc();
        }
        try {
            block15: {
                if (vStatusSrc == 1) {
                    if (SrcFeatureRights.isAllowed(vDst, 36) && SrcFeatureRights.isAllowed(this.fSource, 256)) {
                        SrcFeatureCopyMove.move(this.fSource, vDst);
                        break block15;
                    } else {
                        this.fPageResultatDav = new WResultatError(403);
                        return this;
                    }
                }
                if (SrcFeatureRights.isAllowed(vDst, 64) && SrcFeatureRights.isAllowed(this.fSource, 256)) {
                    SrcFeatureCopyMove.move(this.fSource, vDst);
                } else {
                    this.fPageResultatDav = new WResultatError(403);
                    return this;
                }
            }
            this.fPageResultatDav = new WResultatSimpleStatus(vStatutDst == -1 ? 201 : 204);
            return this;
        }
        catch (NotAllowedException e) {
            this.fPageResultatDav = new WResultatError(403, LogMgr.getMessage(e));
            return this;
        }
        catch (Exception e) {
            this.fPageResultatDav = new WResultatError(500, LogMgr.getMessage(e));
        }
        return this;
    }

    protected IHDialog xDoDelete() throws Exception {
        int vStatus = this.xCheckSource();
        this.fPageResultatDav = vStatus == 1 | vStatus == 2 ? (SrcFeatureRights.isAllowed(this.fSource, 8) ? (this.fSource.removeSrc() ? new WResultatSimpleStatus(204) : new WResultatError(409)) : new WResultatError(403)) : new WResultatError(404);
        return this;
    }

    protected IHDialog xDoMkcol() throws Exception {
        int vStatus;
        ISrcContent vSrc = SrcFeaturePaths.findContentByPath(this.xGetRoot(), this.xGetPathFromRoot(), false);
        this.fPageResultatDav = SrcFeatureRights.isAllowed(vSrc, 64) ? (vSrc.createAsFolder() ? new WResultatSimpleStatus(201) : ((vStatus = vSrc.getContentStatus()) == -1 ? new WResultatError(403) : (vStatus == -2 ? new WResultatError(409) : new WResultatError(412)))) : new WResultatError(403);
        return this;
    }

    protected IHDialog xDoInit() throws Exception {
        HInitParamsWebdav vParam = (HInitParamsWebdav)this.getParamsInitializer(null);
        vParam.fDepth = 1;
        vParam.fProtocolDav = false;
        vParam.fPathRessource = "/";
        this.xDoPropfindAll();
        return this;
    }

    protected int xCheckSource() throws Exception {
        int vStatus = this.xLoadSource();
        if (vStatus == -1) {
            this.fPageResultatDav = new WResultatError(404);
        } else if (vStatus == -2) {
            this.fPageResultatDav = new WResultatError(409);
        }
        return vStatus;
    }

    protected int xLoadSource() throws Exception {
        this.fSource = SrcFeaturePaths.findNodeByPath(this.xGetRoot(), this.xGetPathFromRoot(), false);
        int vStatus = this.fSource.getContentStatus();
        return vStatus;
    }

    protected ISrcNode xGetRoot() throws Exception {
        return ((WServiceSourceDav)this.fService).hGetDocServeur(this);
    }

    protected String xGetPathFromRoot() throws Exception {
        return this.fParamEntree.fPathRessource;
    }

    protected ISrcNode xGetDst(String pDstPath) throws Exception {
        return SrcFeaturePaths.findNodeByPath(this.xGetRoot(), pDstPath, false);
    }

    protected boolean xIsDstInSrc(ISrcNode pDst, ISrcNode pSource) {
        return SrcFeatureUris.isAncestorOrSameUri(pSource.getSrcUri(), pDst.getSrcUri());
    }

    protected String xGetPublicRootUrl() throws Exception {
        return ((WServiceSourceDav)this.fService).hGetUrlService(this);
    }

    protected HWebdavResource xCreateWebdavResource(ISrcNode pSource) throws Exception {
        return new HSourceDavResource(pSource);
    }
}

