/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.univers;

import com.scenari.m.co.classecomp.IWClasseComposant;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.HUpdates;
import com.scenari.m.co.univers.IWContenuMgr;
import com.scenari.m.co.univers.IWInstancesMgr;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.univers.wsp.WContenuMgrWsp;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.IUserMgr;
import com.scenari.m.co.user.fs.UserMgrFs;
import com.scenari.src.ISrcNode;
import com.scenari.src.system.ISrcSystem;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import java.util.HashMap;
import javax.xml.transform.TransformerFactory;

public class WUnivers
implements IWUnivers {
    protected String fCode = null;
    protected ISrcSystem fEspaceSource = null;
    protected HashMap fEspaces = new HashMap();
    protected IUserMgr fUserMgr = null;
    protected HashMap fClasseComposants = new HashMap();
    protected HashMap fServices = new HashMap();
    protected IExecFrame[] fExecFrames = null;
    protected IWInstancesMgr fInstancesMgr = null;
    protected IWContenuMgr fContenuMgr = null;
    protected String fIntitule = null;
    protected TransformerFactory fTransformerFactory = null;

    public WUnivers(String pCode) {
        this.fCode = pCode;
        this.fIntitule = pCode;
    }

    public void hCheckUpdate(HUpdates pUpdates) throws Exception {
        if (this.fContenuMgr != null) {
            this.fContenuMgr.hCheckUpdate(pUpdates);
        }
    }

    public final IUser getUser(String pCompte) throws Exception {
        return this.fUserMgr.getUser(pCompte);
    }

    public IUserMgr getUserMgr() {
        return this.fUserMgr;
    }

    public final IWClasseComposant hGetClasseComposantByUrn(String pUrn) throws Exception {
        return (IWClasseComposant)this.fClasseComposants.get(pUrn);
    }

    public final IWClasseComposant hGetClasseComposantPrincByCode(String pCode) throws Exception {
        return (IWClasseComposant)this.fClasseComposants.get(pCode);
    }

    public final String hGetCode() {
        return this.fCode;
    }

    public final IWContenuMgr hGetContenuMgr() throws Exception {
        return this.fContenuMgr;
    }

    public final IExecFrame getExecFrame(String pCode) {
        if (this.fExecFrames != null) {
            for (int i = 0; i < this.fExecFrames.length; ++i) {
                IExecFrame vFrame = this.fExecFrames[i];
                if (!vFrame.getCode().equals(pCode)) continue;
                return vFrame;
            }
        }
        return null;
    }

    public final ISrcNode hGetEspace(String pCodeEspace) throws Exception {
        ISrcSystem vSourceSystem = (ISrcSystem)this.fEspaces.get(pCodeEspace);
        return vSourceSystem != null ? vSourceSystem.getStartSrcNode() : null;
    }

    public final ISrcNode hGetEspaceSources() throws Exception {
        return this.fEspaceSource.getStartSrcNode();
    }

    public final IWInstancesMgr hGetInstancesMgr() throws Exception {
        return this.fInstancesMgr;
    }

    public final String hGetIntitule() {
        return this.fIntitule;
    }

    public final IWService hGetService(String pCode) {
        return (IWService)this.fServices.get(pCode);
    }

    public final void hSetEspace(String pCode, ISrcSystem pSourceSystem) {
        if ("Source".equals(pCode)) {
            this.fEspaceSource = pSourceSystem;
        }
        this.fEspaces.put(pCode, pSourceSystem);
    }

    public final void hSetIntitule(String pIntitule) {
        this.fIntitule = pIntitule;
    }

    public String toString() {
        return "<univers code=\"" + this.fCode + "\"/>";
    }

    public final void wAddClasseComposant(IWClasseComposant pClasseComp) {
        this.fClasseComposants.put(pClasseComp.hGetUrn(), pClasseComp);
    }

    public final void wAddClasseComposantPrincipal(IWClasseComposant pClasseComp) {
        this.fClasseComposants.put(pClasseComp.hGetCode(), pClasseComp);
        this.fClasseComposants.put(pClasseComp.hGetUrn(), pClasseComp);
    }

    public final synchronized void wAddContextExec(IExecFrame pContextExec) {
        if (this.fExecFrames == null) {
            this.fExecFrames = new IExecFrame[1];
            this.fExecFrames[0] = pContextExec;
        } else {
            for (int i = 0; i < this.fExecFrames.length; ++i) {
                if (!this.fExecFrames[i].getCode().equals(pContextExec.getCode())) continue;
                this.fExecFrames[i] = pContextExec;
                return;
            }
            IExecFrame[] vNewTab = new IExecFrame[this.fExecFrames.length + 1];
            System.arraycopy(this.fExecFrames, 0, vNewTab, 0, this.fExecFrames.length);
            vNewTab[this.fExecFrames.length] = pContextExec;
            this.fExecFrames = vNewTab;
        }
    }

    public final synchronized void wAddService(IWService pService) throws Exception {
        this.fServices.put(pService.hGetCode(), pService);
        this.hGetContenuMgr().hInitServiceUnivers(pService);
    }

    public final void wSetContenuMgr(IWContenuMgr pContenuMgr) throws Exception {
        this.fContenuMgr = pContenuMgr;
        this.fContenuMgr.wInitBegin(this);
    }

    public final void wSetInstancesMgr(IWInstancesMgr pInstancesMgr) throws Exception {
        this.fInstancesMgr = pInstancesMgr;
        this.fInstancesMgr.wInitBegin(this);
    }

    public final void wSetUserMgr(IUserMgr pUserMgr) throws Exception {
        this.fUserMgr = pUserMgr;
    }

    public final void wUnload() throws Exception {
        try {
            if (this.fContenuMgr != null) {
                this.fContenuMgr.wUnloadUnivers();
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        try {
            if (this.fInstancesMgr != null) {
                this.fInstancesMgr.wUnloadUnivers();
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        if (this.fServices != null) {
            for (IWService vService : this.fServices.values()) {
                try {
                    vService.wRemoveService();
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        }
    }

    public final void xInitBegin() throws Exception {
        this.fUserMgr = new UserMgrFs(this, true, true);
    }

    public final void xInitEnd() throws Exception {
        if (this.fContenuMgr == null) {
            this.fContenuMgr = new WContenuMgrWsp();
            this.fContenuMgr.wInitBegin(this);
        }
        this.fContenuMgr.wInitEnd(this);
        if (this.fInstancesMgr == null) {
            throw LogMgr.newException("No instancemgr defined in universe " + this.fCode, new String[0]);
        }
        this.fInstancesMgr.wInitEnd(this);
        for (IWService vSvc : this.fServices.values()) {
            vSvc.wInitAndLinkServices();
        }
    }
}

