/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.univers;

import com.scenari.m.co.univers.HUniversMgr;
import com.scenari.m.co.univers.HUpdates;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.univers.WUnivers;
import com.scenari.m.co.univers.XParamUniversSaxHandler;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.util.xml.HSaxParsingEnCours;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import eu.scenari.fw.log.LogMgr;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class WUniversHandle
implements Serializable {
    public static final int ETAT_OK = 0;
    public static final int ETAT_INIT = 1;
    public static final int ETAT_RESET = 2;
    public static final int ETAT_REMOVE = 3;
    public static final int ETAT_UNLOADING = 4;
    public static final int ETAT_UNLOADED = 5;
    public static final int ETAT_ECHEC = 6;
    public static boolean sCheckUpdateUnivers = true;
    public static long sTimeToUpdate = 0L;
    public static long sTimeOutInit = 30000L;
    protected transient WUnivers fUnivers = null;
    protected transient WUnivers fUniversInUpdate = null;
    protected String fUniversCode = null;
    protected ISrcNode fDocSource = null;
    protected long fDocSourceLastModif = -1L;
    protected volatile transient int fEtat = 1;
    protected transient long fTimeStamp = 0L;

    public WUniversHandle(String pCode, ISrcNode pDocSource) throws Exception {
        this.fUniversCode = pCode;
        this.fDocSource = pDocSource;
        this.fEtat = 1;
        this.fTimeStamp = System.currentTimeMillis();
    }

    public synchronized void hCheckUpdate(HUpdates pUpdates) throws Exception {
        if (SrcFeatureRefresh.isUpdatedOrUnknown(this.fDocSource, this.fDocSourceLastModif)) {
            this.wUnloadUnivers();
            this.wReinit();
            pUpdates.hAddUpdate(this);
        } else {
            pUpdates.hAddNoUpdate(this);
        }
        if (this.fUnivers != null) {
            this.fUnivers.hCheckUpdate(pUpdates);
        }
    }

    public final IWUnivers hGet() throws Exception {
        while (this.fEtat != 0) {
            if (this.fEtat == 3) {
                throw LogMgr.newException("L'univers '" + this.fUniversCode + "' a \u00e9t\u00e9 supprim\u00e9.", new String[0]);
            }
            if (this.fEtat == 6) {
                if (this.fTimeStamp < System.currentTimeMillis() - 3000L) {
                    this.fEtat = 5;
                    this.wReinit();
                    continue;
                }
                throw LogMgr.newException("L'univers '" + this.fUniversCode + "' est en \u00e9chec au chargement. Retentez le chargement dans quelques secondes...", new String[0]);
            }
            if (this.fEtat == 5) {
                this.wReinit();
                continue;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.fEtat == 0 || this.fTimeStamp + sTimeOutInit >= System.currentTimeMillis()) continue;
            this.fEtat = 6;
        }
        return this.fUnivers;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return HUniversMgr.hGetUniversHandle(this.fUniversCode, this.fDocSource);
        }
        catch (Exception e) {
            return HUniversMgr.hGetUniversHandle(this.fUniversCode);
        }
    }

    public String toString() {
        return "<univershandle code=\"" + this.fUniversCode + "\"/>";
    }

    public final synchronized IWUnivers wGetInUpdate() throws Exception {
        if (this.fUniversInUpdate != null) {
            return this.fUniversInUpdate;
        }
        return this.fUnivers;
    }

    void wInitBegin(HSaxParsingEnCours pParsingEnCours) throws Exception {
        block10: {
            try {
                WUnivers vUnivers = new WUnivers(this.fUniversCode);
                vUnivers.xInitBegin();
                this.fUniversInUpdate = vUnivers;
                if (pParsingEnCours == null) {
                    InputStream vInputStream = this.fDocSource.newInputStream(false);
                    if (vInputStream != null) {
                        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                        try {
                            XParamUniversSaxHandler vSaxHandler = new XParamUniversSaxHandler();
                            vXmlReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(this.fDocSource, null));
                            vSaxHandler.initSaxHandlerForRoot(vXmlReader);
                            vSaxHandler.hSetDocSource(this.fDocSource);
                            vSaxHandler.hSetUnivers(this, vUnivers);
                            InputSource vInputSource = new InputSource(vInputStream);
                            vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(this.fDocSource));
                            vXmlReader.parse(vInputSource);
                            if (this.fEtat != 0) {
                                this.fEtat = this.fEtat == 2 ? 0 : 6;
                            }
                            break block10;
                        }
                        catch (Exception e) {
                            vInputStream.close();
                            this.fEtat = this.fEtat == 2 ? 0 : 6;
                            throw e;
                        }
                        finally {
                            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
                        }
                    }
                    throw LogMgr.newException("Le DocServeur d'initialisation de l'univers '" + this.fUniversCode + "' ne peut \u00eatre recharg\u00e9 : " + this.fDocSource, new String[0]);
                }
                XParamUniversSaxHandler vSaxHandler = new XParamUniversSaxHandler();
                vSaxHandler.hSetDocSource(this.fDocSource);
                vSaxHandler.hSetUnivers(this, vUnivers);
                pParsingEnCours.hForward(vSaxHandler);
            }
            catch (Exception e) {
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 l'initialisation de l'univers '" + this.fUniversCode + "'.", new String[0]);
            }
        }
    }

    void wInitEnd(WUnivers pUnivers) throws Exception {
        try {
            this.fDocSourceLastModif = this.fDocSource.getLastModifWithChildren();
            pUnivers.xInitEnd();
            this.fUnivers = pUnivers;
            this.fUniversInUpdate = null;
            this.fEtat = 0;
        }
        catch (Exception e) {
            this.fEtat = this.fEtat == 2 ? 0 : 6;
            throw e;
        }
    }

    synchronized void wReinit() throws Exception {
        if (this.fEtat == 5) {
            this.fEtat = 1;
            this.fTimeStamp = System.currentTimeMillis();
            this.wInitBegin(null);
        }
    }

    synchronized void wUnloadUnivers() throws Exception {
        if (this.fUnivers != null) {
            this.fTimeStamp = System.currentTimeMillis();
            this.fEtat = 4;
            if (sTimeToUpdate > 0L) {
                Thread.sleep(sTimeToUpdate);
            }
            this.fUnivers.wUnload();
            this.fUnivers = null;
        }
        this.fTimeStamp = System.currentTimeMillis();
        this.fEtat = 5;
    }
}

