/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.univers;

import com.scenari.m.co.classecomp.HClasseComposant;
import com.scenari.m.co.classecomp.IWClasseComposant;
import com.scenari.m.co.service.HServicesMgr;
import com.scenari.m.co.service.IWServiceLoader;
import com.scenari.m.co.univers.WUnivers;
import com.scenari.m.co.univers.WUniversHandle;
import com.scenari.m.co.univers.wsp.HContenuMgrWspLoader;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.system.ISrcSystemLoader;
import com.scenari.src.system.SrcSystemFactory;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.universe.UniverseSubLoaderBase;
import eu.scenari.universe.execframe.httpservlet.ExecFrameHttpServletLoader;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XParamUniversSaxHandler
extends FragmentSaxHandlerBase {
    public static final String TAG_UNIVERS = "univers";
    public static final String TAG_UNIVERS_ATT_CODE = "code";
    public static final String TAG_UNIVERS_ATT_INTITULE = "intitule";
    public static final String TAG_ESPACE = "espace";
    public static final String TAG_ESPACE_ATT_TYPE = "type";
    public static final String TAG_ESPACE_ATT_CODE = "code";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_SERVICE_ATT_TYPE = "type";
    public static final String TAG_SERVICE_ATT_CODE = "code";
    public static final String TAG_COMPOSANT = "composant";
    public static final String TAG_COMPOSANT_ATT_REF = "ref";
    public static final String TAG_SPUL = "spul";
    public static final String TAG_COMP_LECTEUR = "lecteur";
    public static final String TAG_COMP_DIALOGUE = "dialogue";
    public static final String TAG_COMP_PARAM = "param";
    public static final String TAG_COMP_PAGERESULTAT = "pageresultat";
    public static final String TAG_COMP_PAGERESULTAT_ATT_RES = "coderesultat";
    public static final String TAG_EXEC_FRAME = "executionFrame";
    public static final String TAG_CONTENUMGR = "contenumgr";
    public static final String TAG_INSTANCESMGR = "instancesmgr";
    public static final String TAG_USERMGR = "usermgr";
    public static final String TAG_IMPORT = "import";
    public static final String TAG_XXX_ATT_HREF = "href";
    public static final String TAG_XXX_ATT_CLASSE = "classe";
    protected ISrcNode fCurrentDocSource = null;
    protected boolean fSousDocument = false;
    protected WUniversHandle fUniversHandle = null;
    protected WUnivers fUnivers = null;
    protected boolean fUniversEnCours = false;
    protected String fCurrentParamCode = null;
    protected ArrayList fStackClasseComposants = new ArrayList();
    protected StringBuilder fBuf = new StringBuilder(64);

    public void characters(char[] pContent, int pStart, int pLength) throws SAXException {
        this.fBuf.append(pContent, pStart, pLength);
    }

    public void endDocument() throws SAXException {
        if (!this.fSousDocument) {
            super.endDocument();
        }
    }

    public void hSetDocSource(ISrcNode pDocSource) {
        this.fCurrentDocSource = pDocSource;
    }

    public void hSetUnivers(WUniversHandle pUniversHandle, WUnivers pUnivers) {
        this.fUniversHandle = pUniversHandle;
        this.fUnivers = pUnivers;
    }

    public void startDocument() throws SAXException {
        if (!this.fSousDocument) {
            super.startDocument();
        }
    }

    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (this.fUniversEnCours) {
            if (pLocalName == TAG_UNIVERS) {
                this.fUniversHandle.wInitEnd(this.fUnivers);
            } else if (pLocalName == TAG_COMPOSANT || pLocalName == TAG_SPUL) {
                this.fStackClasseComposants.remove(this.fStackClasseComposants.size() - 1);
            } else if (this.fCurrentParamCode != null) {
                this.xGetCurrentClasseComposant().wAddParam(this.fCurrentParamCode, this.fBuf.substring(0));
                this.fCurrentParamCode = null;
            }
        }
        this.fBuf.setLength(0);
    }

    private IWClasseComposant xGetCurrentClasseComposant() {
        return (IWClasseComposant)this.fStackClasseComposants.get(this.fStackClasseComposants.size() - 1);
    }

    private void xNewEspace(String pType, String pCodeEspace, String pUri, String pLocalName, String pQName, Attributes pAttributes) {
        try {
            ISrcSystemLoader vDocSrvLoader = SrcSystemFactory.getInstanceLoader(pType);
            vDocSrvLoader.setSourceDefinition(this.fCurrentDocSource);
            vDocSrvLoader.setOwner(this.fUnivers);
            vDocSrvLoader.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            this.fUnivers.hSetEspace(pCodeEspace, vDocSrvLoader.getSrcSystem());
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Echec \u00e0 l'installation de l'espace '" + pCodeEspace + " de type '" + pType + "' \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if (!this.fUniversEnCours) {
            String vCode;
            if (pLocalName == TAG_UNIVERS && (vCode = pAttributes.getValue("code")) != null && vCode.equals(this.fUnivers.hGetCode())) {
                this.fUniversEnCours = true;
                vCode = pAttributes.getValue(TAG_UNIVERS_ATT_INTITULE);
                if (vCode != null && !vCode.equals("")) {
                    this.fUnivers.hSetIntitule(vCode);
                }
            }
        } else if (pLocalName == TAG_ESPACE) {
            this.xNewEspace(pAttributes.getValue("type"), pAttributes.getValue("code"), pUri, pLocalName, pQName, pAttributes);
        } else if (pLocalName == TAG_EXEC_FRAME) {
            try {
                String vType = pAttributes.getValue("type");
                UniverseSubLoaderBase vSaxHandler = null;
                if (vType != null) {
                    Class<?> vClass = Class.forName(vType);
                    vSaxHandler = (UniverseSubLoaderBase)vClass.newInstance();
                } else {
                    vSaxHandler = new ExecFrameHttpServletLoader();
                }
                vSaxHandler.setUniverse(this.fUnivers);
                vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'initialisation de l'ExceFrame \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
            }
        } else if (pLocalName == TAG_SPUL) {
            HClasseComposant vComp = new HClasseComposant(pAttributes.getValue("code"));
            this.fUnivers.wAddClasseComposantPrincipal(vComp);
            if (!this.fStackClasseComposants.isEmpty()) {
                LogMgr.publishException("Anomalie : Un composant principal (sp / ul) est d\u00e9clar\u00e9 en dehors de la racine des classes de composant de l'univers.", new String[0]);
                this.fStackClasseComposants.clear();
            }
            this.fStackClasseComposants.add(vComp);
        } else if (pLocalName == TAG_COMPOSANT) {
            IWClasseComposant vComp = null;
            String vRef = pAttributes.getValue(TAG_COMPOSANT_ATT_REF);
            if (vRef != null) {
                vComp = this.fUnivers.hGetClasseComposantByUrn("/".concat(vRef));
                if (vComp == null) {
                    LogMgr.publishException("Une classe de composant r\u00e9f\u00e9renc\u00e9e '" + vRef + "' est introuvable dans la d\u00e9claration des classes de composants de l'univers '" + this.fUnivers.hGetCode() + "'.", new String[0]);
                }
            } else {
                vComp = new HClasseComposant(pAttributes.getValue("code"));
                if (!this.fStackClasseComposants.isEmpty()) {
                    vComp.wSetClasseComposantHebergeur(this.xGetCurrentClasseComposant());
                }
            }
            if (vComp != null) {
                if (!this.fStackClasseComposants.isEmpty()) {
                    this.xGetCurrentClasseComposant().wAddClasseCompAssoc(vComp);
                    this.fUnivers.wAddClasseComposant(vComp);
                } else {
                    this.fUnivers.wAddClasseComposant(vComp);
                }
                this.fStackClasseComposants.add(vComp);
            }
        } else if (pLocalName == TAG_COMP_LECTEUR) {
            if (!this.fStackClasseComposants.isEmpty()) {
                try {
                    this.xGetCurrentClasseComposant().wSetLoaderClasse(pAttributes.getValue(TAG_XXX_ATT_CLASSE));
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        } else if (pLocalName == TAG_COMP_DIALOGUE) {
            if (!this.fStackClasseComposants.isEmpty()) {
                try {
                    this.xGetCurrentClasseComposant().wSetDialogClasse(pAttributes.getValue(TAG_XXX_ATT_CLASSE));
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
            }
        } else if (pLocalName == TAG_COMP_PAGERESULTAT) {
            if (!this.fStackClasseComposants.isEmpty()) {
                this.xGetCurrentClasseComposant().wAddPageResultat(pAttributes.getValue("code"), pAttributes.getValue(TAG_COMP_PAGERESULTAT_ATT_RES));
            }
        } else if (pLocalName == TAG_COMP_PARAM) {
            if (!this.fStackClasseComposants.isEmpty()) {
                this.fCurrentParamCode = pAttributes.getValue("code");
            }
        } else if (pLocalName == TAG_CONTENUMGR) {
            try {
                String vType = pAttributes.getValue("type");
                UniverseSubLoaderBase vSaxHandler = null;
                if (vType != null) {
                    try {
                        Class<?> vClass = Class.forName(vType);
                        vSaxHandler = (UniverseSubLoaderBase)vClass.newInstance();
                    }
                    catch (Exception e) {
                        LogMgr.publishException(e);
                    }
                }
                if (vSaxHandler == null) {
                    vSaxHandler = new HContenuMgrWspLoader();
                }
                vSaxHandler.setUniverse(this.fUnivers);
                vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'initialisation du ContenuMgr \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
            }
        } else if (pLocalName == TAG_INSTANCESMGR) {
            try {
                String vType = pAttributes.getValue("type");
                UniverseSubLoaderBase vSaxHandler = null;
                if (vType != null) {
                    Class<?> vClass = Class.forName(vType);
                    vSaxHandler = (UniverseSubLoaderBase)vClass.newInstance();
                }
                vSaxHandler.setUniverse(this.fUnivers);
                vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'initialisation de l'InstancesMgr \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
            }
        } else if (pLocalName == TAG_USERMGR) {
            try {
                String vType = pAttributes.getValue("type");
                UniverseSubLoaderBase vSaxHandler = null;
                if (vType != null) {
                    Class<?> vClass = Class.forName(vType);
                    vSaxHandler = (UniverseSubLoaderBase)vClass.newInstance();
                }
                vSaxHandler.setUniverse(this.fUnivers);
                vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'initialisation du UserMgr \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
            }
        } else if (pLocalName == TAG_SERVICE) {
            String vCode = pAttributes.getValue("code");
            String vType = pAttributes.getValue("type");
            try {
                IWServiceLoader vSaxHandler = HServicesMgr.hGetLoader(vType);
                vSaxHandler.hSetUnivers(this.fUnivers);
                vSaxHandler.hSetDocSource(this.fCurrentDocSource);
                vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'installation du service '" + vCode + " de type '" + vType + "' \u00e0 partir de : '" + this.fCurrentDocSource + "'.", new String[0]);
            }
        } else if (pLocalName == TAG_IMPORT) {
            String vUriImport = pAttributes.getValue(TAG_XXX_ATT_HREF);
            ISrcNode vCurrentDocSource = this.fCurrentDocSource;
            boolean vCurrentSousDocument = this.fSousDocument;
            XMLReader vCurrentXMLReader = this.fXMLReader;
            InputSource vSource = null;
            try {
                this.fCurrentDocSource = SrcFeaturePaths.findNodeByPath(this.fCurrentDocSource, vUriImport, true);
                vSource = new InputSource(this.fCurrentDocSource.newInputStream(false));
                vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(this.fCurrentDocSource));
                this.fXMLReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                this.fSousDocument = true;
                this.fXMLReader.setContentHandler(this);
                this.fXMLReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(this.fCurrentDocSource, null));
                this.fXMLReader.parse(vSource);
                HPoolXmlReader.hGet().hFreeXmlReader(this.fXMLReader);
                this.fXMLReader = vCurrentXMLReader;
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 l'import du fichier '" + vUriImport + ".", new String[0]);
                if (vSource != null) {
                    vSource.getByteStream().close();
                }
            }
            finally {
                this.fCurrentDocSource = vCurrentDocSource;
                this.fSousDocument = vCurrentSousDocument;
                this.fXMLReader = vCurrentXMLReader;
            }
        }
        return true;
    }
}

