/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.univers.wsp;

import com.scenari.m.co.classecomp.IWClasseComposant;
import com.scenari.m.co.composant.IHComposantType;
import com.scenari.m.co.composant.IHComposantTypeLoader;
import com.scenari.m.co.composant.IWComposant;
import com.scenari.m.co.composant.LoadOnlyRootDefSaxException;
import com.scenari.m.co.donnee.HContextDonnee;
import com.scenari.m.co.univers.wsp.WContenuMgrWsp;
import com.scenari.m.co.univers.wsp.XFcSaxHandler;
import com.scenari.m.co.univers.wsp.XInfoCompType;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.cachedobjects.SrcFeatureCachedObjects;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.StreeDOMBuilder;
import com.scenari.xsldom.xml.utils.PrefixResolverStatic;
import eu.scenari.fw.log.Chrono;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.mem.MemoryMgr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CompTypeSet {
    public static boolean sLoadOnlyBsRootDefinition = false;
    public static TracePoint sTrace = TraceMgr.register(CompTypeSet.class.getName(), "Trace la compilation des composants-types.");
    public static String sCodeCompTypeRoot = "_root";
    protected WContenuMgrWsp fContenuMgr = null;
    protected String fUriJeuFc = null;
    protected String fUriFcs = null;
    protected String fUriReFo = null;
    protected List fCompTypes = null;
    protected IHComposantType fCompTypeRoot = null;
    protected HashMap fMapCompSetByUri = new HashMap();
    protected HashMap fMapUriById = new HashMap();
    protected HashMap fMapCompRootByUri = new HashMap();
    protected long fLastUsed = 0L;
    protected long fLastId = 0L;

    public CompTypeSet(WContenuMgrWsp pContenuMgr, String pUriJeuFc) throws Exception {
        this.fContenuMgr = pContenuMgr;
        this.fUriJeuFc = pUriJeuFc;
        if (pUriJeuFc.endsWith("/")) {
            this.fUriFcs = pUriJeuFc.substring(0, pUriJeuFc.length() - 1);
            this.fUriReFo = pUriJeuFc.concat("_common");
        } else {
            this.fUriFcs = pUriJeuFc;
            this.fUriReFo = pUriJeuFc.concat("/_common");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComposantsSet hGetComposantsSet(String pUriComp) throws Exception {
        Object vCompSet = null;
        String vId = null;
        HashMap hashMap = this.fMapCompSetByUri;
        synchronized (hashMap) {
            String vKey = pUriComp;
            vCompSet = this.fMapCompSetByUri.get(vKey);
            if (vCompSet != null) {
                if (vCompSet instanceof ComposantsSet) {
                    return vCompSet;
                }
                vId = vCompSet;
            } else {
                vId = "c" + this.fLastId++;
                this.fMapUriById.put(vId, pUriComp);
            }
            ComposantsSet vCompSetNew = new ComposantsSet();
            vCompSetNew.fId = vId;
            vCompSetNew.fSource = SrcFeaturePaths.findNodeByPath(this.fContenuMgr.fUnivers.hGetEspaceSources(), pUriComp, false);
            this.fMapCompSetByUri.put(vKey, vCompSetNew);
            return vCompSetNew;
        }
    }

    public ComposantsSet hGetComposantsSetById(String pId) throws Exception {
        String vUri = (String)this.fMapUriById.get(pId);
        if (vUri != null) {
            return this.hGetComposantsSet(vUri);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComposantRoot hGetComposantRoot(String pUriComp) throws Exception {
        String vKey = pUriComp;
        HashMap hashMap = this.fMapCompRootByUri;
        synchronized (hashMap) {
            ComposantRoot vCompRoot = (ComposantRoot)this.fMapCompRootByUri.get(vKey);
            if (vCompRoot != null) {
                return vCompRoot;
            }
            vCompRoot = new ComposantRoot();
            vCompRoot.fSource = SrcFeaturePaths.findNodeByPath(this.fContenuMgr.fUnivers.hGetEspaceSources(), pUriComp, false);
            this.fMapCompRootByUri.put(vKey, vCompRoot);
            return vCompRoot;
        }
    }

    public synchronized void hLoadComposantTypes(boolean pCheckUpadtes) throws Exception {
        this.fLastUsed = System.currentTimeMillis();
        if (pCheckUpadtes || this.fCompTypes == null) {
            int i;
            Chrono vChrono = sTrace.isEnabled() ? new Chrono().begin() : null;
            ISrcNode vJeuFc = SrcFeaturePaths.findNodeByPath(this.fContenuMgr.fUnivers.hGetEspaceSources(), this.fUriJeuFc, false);
            SrcFeatureRefresh.refresh(vJeuFc);
            List<String> vListSourcesFc = this.fContenuMgr.fUnivers.hGetEspaceSources().findContentByUri(this.fUriFcs).listChildrenNames(null, 1);
            ArrayList<IHComposantType> vNewCompTypeList = new ArrayList<IHComposantType>(vListSourcesFc.size());
            IHComposantType[] vOldCompTypes = this.fCompTypes != null ? this.fCompTypes.toArray(new IHComposantType[this.fCompTypes.size()]) : null;
            for (i = 0; i < vListSourcesFc.size(); ++i) {
                String vNameFc = vListSourcesFc.get(i);
                int vLengthUri = this.fUriFcs.length() + vNameFc.length() + 1;
                boolean vOldCompTypeFound = false;
                if (vOldCompTypes != null) {
                    for (int j = -1; j < vOldCompTypes.length; ++j) {
                        IHComposantType vOldCompType;
                        IHComposantType iHComposantType = vOldCompType = j == -1 ? this.fCompTypeRoot : vOldCompTypes[j];
                        if (vOldCompType == null) continue;
                        XInfoCompType vOldInfo = (XInfoCompType)vOldCompType.wGetContenuMgrInfo();
                        String vUriOldFc = vOldInfo.fSourceFc.getSrcUri();
                        if (vLengthUri != vUriOldFc.length() || !vUriOldFc.endsWith(vNameFc)) continue;
                        boolean vUpdated = SrcFeatureRefresh.isUpdatedOrUnknown(vOldInfo.fSourceFc, vOldInfo.fSourceFcLastModif);
                        if (!vUpdated && vOldInfo.fSourceResUsed != null) {
                            ISrcNode vRes;
                            for (int k = 0; k < vOldInfo.fSourceResUsed.size() && !(vUpdated = SrcFeatureRefresh.isUpdatedOrUnknown(vRes = (ISrcNode)vOldInfo.fSourceResUsed.get(k), vOldInfo.fSourceResUsedLastModif[k])); ++k) {
                            }
                        }
                        if (vUpdated) {
                            IHComposantType vCompType = this.xLoadCompType(vOldInfo.fSourceFc);
                            if (vCompType != null) {
                                this.xAddCompType(vCompType, vNewCompTypeList, vOldCompType);
                            } else {
                                LogMgr.publishException("La feuille de comportement d'url '" + vOldInfo.fSourceFc.getSrcUri() + "' n'a pas \u00e9t\u00e9 reconnue (aucun composant-type cr\u00e9\u00e9).", new String[0]);
                            }
                        } else {
                            vNewCompTypeList.add(vOldCompType);
                        }
                        vOldCompTypeFound = true;
                        if (j <= 0) continue;
                        vOldCompTypes[j] = null;
                    }
                }
                if (vOldCompTypeFound) continue;
                String vUrlFc = this.fUriFcs + "/" + vNameFc;
                IHComposantType vCompType = this.xLoadCompType(SrcFeaturePaths.findNodeByPath(this.fContenuMgr.fUnivers.hGetEspaceSources(), vUrlFc, false));
                if (vCompType != null) {
                    this.xAddCompType(vCompType, vNewCompTypeList, null);
                    continue;
                }
                LogMgr.publishException("La feuille de comportement d'url '" + vUrlFc + "' n'a pas \u00e9t\u00e9 reconnue (aucun composant-type cr\u00e9\u00e9).", new String[0]);
            }
            i = 0;
            while (i < vNewCompTypeList.size()) {
                IHComposantType vCompType = (IHComposantType)vNewCompTypeList.get(i);
                if (vCompType.hGetCode().equals(sCodeCompTypeRoot)) {
                    this.fCompTypeRoot = vCompType;
                    vNewCompTypeList.remove(i);
                    continue;
                }
                ++i;
            }
            this.fCompTypes = vNewCompTypeList;
            if (vChrono != null) {
                sTrace.publishDebug("Chrono LoadCompTypes : " + vChrono.end().computeResults(), new String[0]);
            }
        }
    }

    public long hEvalMemory() {
        long vResult = 0L;
        if (this.fCompTypes != null) {
            vResult = this.fCompTypes.size() * 300000;
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hEvalMemoryAllComp() {
        long vResult = 0L;
        HashMap hashMap = this.fMapCompSetByUri;
        synchronized (hashMap) {
            for (ComposantsSet vCompList : this.fMapCompSetByUri.values()) {
                vResult += vCompList.hEvalMemory();
            }
        }
        return vResult += (long)(this.fMapCompRootByUri.size() * 100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hFreeCompByLastUse(long pLimit) {
        long vResult = 0L;
        HashMap hashMap = this.fMapCompSetByUri;
        synchronized (hashMap) {
            for (Map.Entry entry : this.fMapCompSetByUri.entrySet()) {
                ComposantsSet vCompSet = (ComposantsSet)entry.getValue();
                if (vCompSet.fLastUsedComp >= pLimit || vCompSet.fLastUsedComp == 0L) continue;
                vResult += vCompSet.hEvalMemory();
                entry.setValue(vCompSet.fId);
                if (!MemoryMgr.sTrace.isEnabled()) continue;
                MemoryMgr.sTrace.publishDebug("Purge de " + vCompSet.toString() + " car non utilis\u00e9 depuis : " + new Date(vCompSet.fLastUsedComp), new String[0]);
            }
        }
        hashMap = this.fMapCompRootByUri;
        synchronized (hashMap) {
            Iterator vIt = this.fMapCompRootByUri.values().iterator();
            while (vIt.hasNext()) {
                ComposantRoot composantRoot = (ComposantRoot)((Object)vIt.next());
                if (composantRoot.fLastUsedComp >= pLimit || composantRoot.fLastUsedComp == 0L) continue;
                vResult += composantRoot.hEvalMemory();
                vIt.remove();
                if (!MemoryMgr.sTrace.isEnabled()) continue;
                MemoryMgr.sTrace.publishDebug("Purge de " + composantRoot.toString() + " car non utilis\u00e9 depuis : " + new Date(composantRoot.fLastUsedComp), new String[0]);
            }
        }
        return vResult;
    }

    protected IHComposantType xLoadCompType(ISrcNode pSourceFc) throws Exception {
        XMLReader vParser = CompTypeSet.xGetXmlReader();
        XFcSaxHandler vSaxHandler = new XFcSaxHandler(this, sLoadOnlyBsRootDefinition);
        vSaxHandler.hSetXmlReader(vParser);
        InputSource vSource = null;
        try {
            SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(pSourceFc, null);
            vSaxHandler.hSetDocSourceFc(vResolver);
            vSource = new InputSource(pSourceFc.newInputStream(false));
            vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolver));
            vParser.setEntityResolver(vResolver);
            vParser.setContentHandler(vSaxHandler);
            vParser.parse(vSource);
            if (vSaxHandler.fCompType != null) {
                ((XInfoCompType)vSaxHandler.fCompType.wGetContenuMgrInfo()).setLoaded();
            }
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("Compilation de la FC : " + pSourceFc, new String[0]);
            }
        }
        catch (LoadOnlyRootDefSaxException e) {
            if (vSaxHandler.fCompType != null) {
                ((XInfoCompType)vSaxHandler.fCompType.wGetContenuMgrInfo()).setLoaded();
            }
        }
        catch (Exception e) {
            if (vSource != null && vSource.getByteStream() != null) {
                vSource.getByteStream().close();
            }
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la lecture de la feuille de comportement '" + pSourceFc + "'.", new String[0]);
        }
        finally {
            CompTypeSet.xFreeXmlReader(vParser);
        }
        return vSaxHandler.fCompType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xAddCompType(IHComposantType pCompType, List pNewList, IHComposantType pOldCompTypeToReplace) {
        if (pCompType.hGetCode().equals(sCodeCompTypeRoot)) {
            this.fCompTypeRoot = pCompType;
            HashMap hashMap = this.fMapCompRootByUri;
            synchronized (hashMap) {
                this.fMapCompRootByUri.clear();
            }
        }
        boolean vEqualsDefRoots = pOldCompTypeToReplace != null ? pOldCompTypeToReplace.wEqualsDefRoots(pCompType) : false;
        pNewList.add(pCompType);
        HashMap hashMap = this.fMapCompSetByUri;
        synchronized (hashMap) {
            for (ComposantsSet vCompSet : this.fMapCompSetByUri.values()) {
                if (pOldCompTypeToReplace != null) {
                    if (vEqualsDefRoots) {
                        vCompSet.replaceCompType(pOldCompTypeToReplace, pCompType);
                        continue;
                    }
                    vCompSet.removeCompType(pOldCompTypeToReplace);
                    vCompSet.addNewCompType(pCompType);
                    continue;
                }
                vCompSet.addNewCompType(pCompType);
            }
        }
    }

    protected static final XMLReader xGetXmlReader() throws Exception {
        return HPoolXmlReader.hGet().hGetXmlReader(true, false);
    }

    protected static final void xFreeXmlReader(XMLReader pReader) {
        HPoolXmlReader.hGet().hFreeXmlReader(pReader);
    }

    public String toString() {
        return "<jeuFc uri=\"" + this.fUriJeuFc + "\"/>";
    }

    protected Document xGetDocument(ISrcNode pSource) throws Exception {
        InputStream vReader;
        Document vDoc = SrcFeatureCachedObjects.getDom(pSource, false);
        if (vDoc != null) {
            return vDoc;
        }
        if (sTrace.isEnabled()) {
            sTrace.publishDebug("Compilation du contenu : " + pSource, new String[0]);
        }
        if ((vReader = pSource.newInputStream(false)) != null) {
            XMLReader vXmlReader = CompTypeSet.xGetXmlReader();
            InputSource vSaxSource = new InputSource();
            try {
                vXmlReader.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(pSource, null));
                vSaxSource.setByteStream(vReader);
                vSaxSource.setSystemId(SrcFeaturePaths.getXmlSystemId(pSource));
                vDoc = new DocumentImpl(false);
                StreeDOMBuilder vContentHandler = new StreeDOMBuilder(vDoc);
                vXmlReader.setContentHandler(vContentHandler);
                vXmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", vContentHandler);
                vXmlReader.parse(vSaxSource);
                vReader.close();
                ((DocumentImpl)vDoc).setComplete(true);
            }
            catch (Exception e) {
                if (vReader != null) {
                    vReader.close();
                }
                throw (Exception)LogMgr.addMessage((Throwable)e, "Le parsing du fichier " + pSource + " de l'espace source a \u00e9chou\u00e9.", new String[0]);
            }
            finally {
                CompTypeSet.xFreeXmlReader(vXmlReader);
            }
        }
        return vDoc;
    }

    protected void xReLoadCompType(IHComposantType pCompType) throws Exception {
        XMLReader vParser = CompTypeSet.xGetXmlReader();
        IWClasseComposant vClassComp = pCompType.hGetClasseComposant();
        IHComposantTypeLoader vLoader = (IHComposantTypeLoader)vClassComp.hGetLoaderClasse().newInstance();
        XInfoCompType vInfoCompType = (XInfoCompType)pCompType.wGetContenuMgrInfo();
        vInfoCompType.reset();
        SrcFeaturePaths.SrcNodeResolver vResolver = SrcFeaturePaths.newSrcNodeResolver(vInfoCompType.fSourceFc, (ISrcAliasResolver)((Object)pCompType));
        HContextDonnee vContextDonnee = new HContextDonnee(vResolver, new PrefixResolverStatic(null));
        InputSource vSource = null;
        try {
            vLoader.hSetCompType(pCompType);
            vLoader.hSetContextDonnee(vContextDonnee);
            vLoader.initSaxHandlerForRoot(vParser);
            vSource = new InputSource(vResolver.newInputStream(false));
            vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolver));
            vParser.setEntityResolver(vResolver);
            vParser.parse(vSource);
            vInfoCompType.setLoaded();
            if (sTrace.isEnabled()) {
                sTrace.publishDebug("Re-compilation de la FC : " + vResolver, new String[0]);
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la lecture de la feuille de comportement '" + vResolver + "'.", new String[0]);
        }
        finally {
            CompTypeSet.xFreeXmlReader(vParser);
        }
    }

    public class ComposantRoot {
        protected ISrcNode fSource = null;
        protected long fSourceLastModif = -1L;
        protected IWComposant fComp = null;
        protected long fLastUsedComp = 0L;

        public CompTypeSet getCompTypeSet() {
            return CompTypeSet.this;
        }

        public long hEvalMemory() {
            return 100000L;
        }

        public String toString() {
            return "Composant racine issus de " + this.fSource;
        }

        public IWComposant hGetComposantRoot(boolean pCheckUpdates) throws Exception {
            if ((this.fComp == null || pCheckUpdates) && CompTypeSet.this.fCompTypeRoot != null && SrcFeatureRefresh.isUpdatedOrUnknown(this.fSource, this.fSourceLastModif)) {
                Document vDoc = CompTypeSet.this.xGetDocument(this.fSource);
                if (CompTypeSet.this.fCompTypeRoot.isOnlyRootDefinitionLoaded()) {
                    if (CompTypeSet.this.fCompTypeRoot.hIsComposantPrincCreatable(vDoc, this.fSource, this)) {
                        CompTypeSet.this.xReLoadCompType(CompTypeSet.this.fCompTypeRoot);
                        CompTypeSet.this.fCompTypeRoot.hCreateComposantPrinc(vDoc, this.fSource, this);
                    }
                } else {
                    CompTypeSet.this.fCompTypeRoot.hCreateComposantPrinc(vDoc, this.fSource, this);
                }
                this.fSourceLastModif = this.fSource.getLastModif();
            }
            return this.fComp;
        }

        public void xSetComp(IWComposant pComp) {
            this.fComp = pComp;
        }
    }

    public class ComposantsSet {
        protected ISrcNode fSource = null;
        protected long fSourceLastModif = -1L;
        protected String fId = null;
        protected List fComps = null;
        protected long fLastUsedComp = 0L;
        protected List fNewCompTypes = null;

        public synchronized List hGetComposants(boolean pCheckUpdates) throws Exception {
            if (this.fComps == null || pCheckUpdates || this.fNewCompTypes != null) {
                if (SrcFeatureRefresh.isUpdatedOrUnknown(this.fSource, this.fSourceLastModif)) {
                    if (this.fComps != null) {
                        this.fComps.clear();
                    } else {
                        this.fComps = new ArrayList();
                    }
                    Document vDoc = CompTypeSet.this.xGetDocument(this.fSource);
                    List vCompTypes = CompTypeSet.this.fCompTypes;
                    if (vDoc != null) {
                        for (int i = 0; i < vCompTypes.size(); ++i) {
                            IHComposantType vCompType = (IHComposantType)vCompTypes.get(i);
                            if (vCompType.isOnlyRootDefinitionLoaded()) {
                                if (!vCompType.hIsComposantPrincCreatable(vDoc, this.fSource, this)) continue;
                                CompTypeSet.this.xReLoadCompType(vCompType);
                                vCompType.hCreateComposantPrinc(vDoc, this.fSource, this);
                                continue;
                            }
                            vCompType.hCreateComposantPrinc(vDoc, this.fSource, this);
                        }
                    }
                    this.fSourceLastModif = this.fSource.getLastModif();
                    this.fNewCompTypes = null;
                } else if (this.fNewCompTypes != null && this.fNewCompTypes.size() > 0) {
                    Document vDoc = CompTypeSet.this.xGetDocument(this.fSource);
                    for (int i = 0; i < this.fNewCompTypes.size(); ++i) {
                        IHComposantType vCompType = (IHComposantType)this.fNewCompTypes.get(i);
                        if (vCompType.isOnlyRootDefinitionLoaded()) {
                            if (!vCompType.hIsComposantPrincCreatable(vDoc, this.fSource, this)) continue;
                            CompTypeSet.this.xReLoadCompType(vCompType);
                            vCompType.hCreateComposantPrinc(vDoc, this.fSource, this);
                            continue;
                        }
                        vCompType.hCreateComposantPrinc(vDoc, this.fSource, this);
                    }
                    this.fSourceLastModif = this.fSource.getLastModif();
                    this.fNewCompTypes = null;
                }
            }
            return this.fComps;
        }

        public void addNewCompType(IHComposantType pCompType) {
            if (this.fNewCompTypes == null) {
                this.fNewCompTypes = new ArrayList();
            }
            this.fNewCompTypes.add(pCompType);
        }

        public void removeCompType(IHComposantType pCompType) {
            int i;
            if (this.fNewCompTypes != null) {
                i = 0;
                while (i < this.fNewCompTypes.size()) {
                    if (this.fNewCompTypes.get(i) == pCompType) {
                        this.fNewCompTypes.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            if (this.fComps != null) {
                i = 0;
                while (i < this.fComps.size()) {
                    IWComposant vComp = (IWComposant)this.fComps.get(i);
                    if (vComp.hGetComposantType() == pCompType) {
                        this.fComps.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }

        public void replaceCompType(IHComposantType pOldCompType, IHComposantType pNewCompType) {
            int i;
            if (this.fNewCompTypes != null) {
                for (i = 0; i < this.fNewCompTypes.size(); ++i) {
                    if (this.fNewCompTypes.get(i) != pOldCompType) continue;
                    this.fNewCompTypes.set(i, pNewCompType);
                    return;
                }
            }
            if (this.fComps != null) {
                i = 0;
                while (i < this.fComps.size()) {
                    IWComposant vComp = (IWComposant)this.fComps.get(i);
                    if (vComp.hGetComposantType() == pOldCompType) {
                        this.fComps.remove(i);
                        this.addNewCompType(pNewCompType);
                        continue;
                    }
                    ++i;
                }
            }
        }

        public CompTypeSet getCompTypeSet() {
            return CompTypeSet.this;
        }

        public void xAddComp(IWComposant pComp) {
            this.fComps.add(pComp);
        }

        public long hEvalMemory() {
            long vResult = 0L;
            if (this.fComps != null) {
                vResult = this.fComps.size() * 100000;
            }
            return vResult;
        }

        public String toString() {
            return "Composants issus de " + this.fSource;
        }
    }
}

