/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.user;

import com.scenari.m.co.user.IHActorMgr;
import eu.scenari.fw.util.collections.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class HActorMgrInMem
implements IHActorMgr {
    ArrayList fRoles = new ArrayList();
    ArrayList fRolesUsers = new ArrayList();

    public List hGetRoles() {
        return this.fRoles;
    }

    public Iterator hGetUsers() {
        int vNbRoles = this.fRoles.size();
        switch (vNbRoles) {
            case 0: {
                return CollectionUtil.emptyIterator();
            }
            case 1: {
                return ((List)this.fRolesUsers.get(0)).iterator();
            }
            case 2: {
                return CollectionUtil.newUnionSortedIterator(((List)this.fRolesUsers.get(0)).iterator(), ((List)this.fRolesUsers.get(1)).iterator(), null);
            }
        }
        ArrayList vIterators = new ArrayList(this.fRoles.size());
        for (int i = 0; i < this.fRoles.size(); ++i) {
            List vListUser = (List)this.fRolesUsers.get(i);
            if (vListUser.size() <= 0) continue;
            vIterators.add(vListUser.iterator());
        }
        return CollectionUtil.newUnionSortedIterator(vIterators, null);
    }

    public Iterator hGetUsersByRole(String pRole) {
        if (pRole == null) {
            return CollectionUtil.emptyIterator();
        }
        int vIdxRole = Collections.binarySearch(this.fRoles, pRole);
        if (vIdxRole >= 0) {
            return ((List)this.fRolesUsers.get(vIdxRole)).iterator();
        }
        return CollectionUtil.emptyIterator();
    }

    public Iterator hGetUsersByRoles(String[] pRoles) {
        if (pRoles == null) {
            return CollectionUtil.emptyIterator();
        }
        int vNbRoles = pRoles.length;
        switch (vNbRoles) {
            case 0: {
                return CollectionUtil.emptyIterator();
            }
            case 1: {
                return this.hGetUsersByRole(pRoles[0]);
            }
            case 2: {
                int vIdxRole1 = Collections.binarySearch(this.fRoles, pRoles[0]);
                int vIdxRole2 = Collections.binarySearch(this.fRoles, pRoles[0]);
                if (vIdxRole1 >= 0 && vIdxRole2 >= 0) {
                    return CollectionUtil.newUnionSortedIterator(((List)this.fRolesUsers.get(vIdxRole1)).iterator(), ((List)this.fRolesUsers.get(vIdxRole2)).iterator(), null);
                }
                if (vIdxRole1 >= 0) {
                    return ((List)this.fRolesUsers.get(vIdxRole1)).iterator();
                }
                if (vIdxRole2 >= 0) {
                    return ((List)this.fRolesUsers.get(vIdxRole2)).iterator();
                }
                return CollectionUtil.emptyIterator();
            }
        }
        int[] vIdxRoles = new int[vNbRoles];
        for (int i = 0; i < vNbRoles; ++i) {
            vIdxRoles[i] = Collections.binarySearch(this.fRoles, pRoles[i]);
        }
        ArrayList vIterators = new ArrayList(vNbRoles);
        for (int i = 0; i < vNbRoles; ++i) {
            List vListUser;
            int vIdxRole = vIdxRoles[i];
            if (vIdxRole < 0 || (vListUser = (List)this.fRolesUsers.get(vIdxRole)).size() <= 0) continue;
            vIterators.add(vListUser.iterator());
        }
        return CollectionUtil.newUnionSortedIterator(vIterators, null);
    }

    public List hGetRolesByUser(String pAccountUser) {
        if (pAccountUser == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList vResult = new ArrayList(this.fRoles.size());
        for (int i = 0; i < this.fRoles.size(); ++i) {
            List vListUsers = (List)this.fRolesUsers.get(i);
            if (Collections.binarySearch(vListUsers, pAccountUser) < 0) continue;
            vResult.add(this.fRoles.get(i));
        }
        return vResult;
    }

    public boolean hIsUserRole(String pAccountUser, String pRole) {
        if (pRole == null || pAccountUser == null) {
            return false;
        }
        int vIdxRole = Collections.binarySearch(this.fRoles, pRole);
        if (vIdxRole >= 0) {
            return Collections.binarySearch((List)this.fRolesUsers.get(vIdxRole), pAccountUser) >= 0;
        }
        return false;
    }

    public boolean wAddActor(String pAccountUser, String pRole) {
        if (pRole == null || pAccountUser == null) {
            return false;
        }
        List vListUsers = this.xGetOrCreateRole(pRole);
        int vIdxUser = Collections.binarySearch(vListUsers, pAccountUser);
        if (vIdxUser < 0) {
            vListUsers.add(-vIdxUser - 1, pAccountUser);
            return true;
        }
        return false;
    }

    public boolean wAddRole(String pRole) {
        if (pRole == null) {
            return false;
        }
        int vIdxRole = Collections.binarySearch(this.fRoles, pRole);
        if (vIdxRole < 0) {
            this.fRoles.add(-vIdxRole - 1, pRole);
            this.fRolesUsers.add(-vIdxRole - 1, new ArrayList());
            return true;
        }
        return false;
    }

    protected List xGetOrCreateRole(String pRole) {
        int vIdxRole = Collections.binarySearch(this.fRoles, pRole);
        if (vIdxRole < 0) {
            this.fRoles.add(-vIdxRole - 1, pRole);
            ArrayList vRes = new ArrayList();
            this.fRolesUsers.add(-vIdxRole - 1, vRes);
            return vRes;
        }
        return (List)this.fRolesUsers.get(vIdxRole);
    }
}

