/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.user.fs;

import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.fs.XUserSaxHandler;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.impl.XMLSerializer;
import eu.scenari.fw.log.LogMgr;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class UserFs
implements IUser {
    public static long sTimeSleepWhenValidatingPassword = 0L;
    protected static DateFormat sFormatDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected static MessageDigest sMsgDigest = null;
    protected IWUnivers fUniverse = null;
    protected String fLastName = null;
    protected String fFirstName = null;
    protected String fDisplayName = null;
    protected String fAccount = null;
    protected String fEmail = null;
    protected byte[] fDigestPassword = null;
    protected String fPasswordChecked = null;
    protected boolean fIsSuperAdmin = false;

    private UserFs() {
    }

    public int compareTo(Object pObject) {
        int vResult = 0;
        if (pObject instanceof IUser) {
            IUser vActeur = (IUser)pObject;
            vResult = this.getAccount().compareToIgnoreCase(vActeur.getAccount());
        }
        return vResult;
    }

    public boolean equals(Object pObject) {
        boolean vResult = false;
        if (pObject instanceof IUser) {
            IUser vActeur = (IUser)pObject;
            vResult = this.getAccount().equals(vActeur.getAccount());
        }
        return vResult;
    }

    public final String getAccount() {
        return this.fAccount;
    }

    public final String getEmail() {
        return this.fEmail;
    }

    public final String getLastName() {
        return this.fLastName;
    }

    public final String getFirstName() {
        return this.fFirstName;
    }

    public final String getName() {
        if (this.fDisplayName == null) {
            String vFirstName = this.getFirstName();
            this.fDisplayName = !vFirstName.equals("") ? vFirstName + " " + this.getLastName() : this.getLastName();
        }
        return this.fDisplayName;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isSuperAdmin() {
        return this.fIsSuperAdmin;
    }

    public boolean checkPassword(String pPassword) {
        boolean vResult;
        boolean bl = vResult = this.fDigestPassword == null;
        if (!vResult && pPassword != null) {
            try {
                if (this.fPasswordChecked != null) {
                    vResult = pPassword.equals(this.fPasswordChecked);
                } else {
                    vResult = Arrays.equals(this.fDigestPassword, UserFs.digestPassword(pPassword));
                    if (vResult) {
                        this.fPasswordChecked = pPassword;
                    }
                }
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            if (sTimeSleepWhenValidatingPassword > 0L) {
                try {
                    Thread.sleep(sTimeSleepWhenValidatingPassword);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vResult;
    }

    public IWUnivers getUniverse() {
        return this.fUniverse;
    }

    protected static synchronized byte[] digestPassword(String pPassword) throws Exception {
        try {
            if (sMsgDigest == null) {
                sMsgDigest = MessageDigest.getInstance("SHA");
            }
            int l = pPassword.length();
            for (int i = 0; i < l; ++i) {
                char vC = pPassword.charAt(i);
                sMsgDigest.update((byte)(~vC));
                sMsgDigest.update((byte)(vC >>> 8));
            }
            byte[] i = sMsgDigest.digest();
            return i;
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Password digest failed", new String[0]);
        }
        finally {
            if (sMsgDigest != null) {
                sMsgDigest.reset();
            }
        }
    }

    public void hSet(String pCodeActeur, String pPassword, String pNom, String pPrenom, String pEmail, boolean pIsSuperAdmin) throws Exception {
        this.fAccount = pCodeActeur;
        if (pPassword != null) {
            this.fPasswordChecked = pPassword;
            this.fDigestPassword = UserFs.digestPassword(pPassword);
        }
        this.fLastName = pNom;
        this.fFirstName = pPrenom;
        this.fEmail = pEmail;
        this.fIsSuperAdmin = pIsSuperAdmin;
        this.fDisplayName = null;
        this.xSave();
    }

    protected static IUser wCreate(IWUnivers pUnivers, String pCompte) throws Exception {
        UserFs vResult = new UserFs();
        vResult.fUniverse = pUnivers;
        vResult.fAccount = pCompte;
        vResult.xSave();
        return vResult;
    }

    protected static void wDelete(IWUnivers pUnivers, String pCodeActeur) {
        try {
            ISrcNode vDocServ = pUnivers.hGetEspace("Acteur");
            SrcFeaturePaths.findContentByPath(vDocServ, "ac/".concat(pCodeActeur), false).removeSrc();
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Erreur lors de la suppression de l'acteur " + pCodeActeur, new String[0]);
        }
    }

    public static IUser wLoad(IWUnivers pUnivers, String pAccount) throws Exception {
        String vPath;
        if (pAccount == null) {
            return null;
        }
        UserFs vResult = null;
        ISrcNode vDocServ = pUnivers.hGetEspace("Acteur");
        ISrcNode vDocSource = SrcFeaturePaths.findNodeByPath(vDocServ, vPath = "ac/".concat(pAccount).concat("/acdef.xml"), false);
        InputStream vReader = vDocSource.newInputStream(false);
        if (vReader != null) {
            XMLReader vParser = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                vResult = new UserFs();
                vResult.fUniverse = pUnivers;
                XUserSaxHandler vSaxHandler = new XUserSaxHandler();
                vSaxHandler.setUser(vResult);
                InputSource vSource = new InputSource(vReader);
                vSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vDocSource));
                vParser.setEntityResolver(SrcFeaturePaths.newSrcNodeResolver(vDocSource, null));
                vParser.setContentHandler(vSaxHandler);
                vParser.parse(vSource);
                if (vResult.fAccount == null || !vResult.fAccount.equals(pAccount)) {
                    vResult = null;
                    throw LogMgr.newException("Le fichier Xml '" + vPath + "' dans l'espace 'acteurs' d\u00e9finissant le compte '" + pAccount + "' est mal form\u00e9.", new String[0]);
                }
            }
            catch (SAXException e) {
                if (e.getException() != null) {
                    throw (Exception)LogMgr.addMessage(e, LogMgr.getMessage(e.getException()));
                }
                throw e;
            }
            finally {
                vReader.close();
                HPoolXmlReader.hGet().hFreeXmlReader(vParser);
            }
        }
        return vResult;
    }

    protected void xSave() throws Exception {
        String vUriAcDef = null;
        Writer vWriter = null;
        try {
            vUriAcDef = "/ac/".concat(this.fAccount).concat("/acdef.xml");
            vWriter = new OutputStreamWriter(this.fUniverse.hGetEspace("Acteur").findContentByUri(vUriAcDef).newOutputStream(false), "UTF-8");
            XMLSerializer vSer = new XMLSerializer(vWriter, new OutputFormat("xml", "UTF-8", false));
            AttributesImpl vAtts = new AttributesImpl();
            vSer.startDocument();
            vAtts.addAttribute("", "compte", "", "CDATA", this.fAccount);
            vAtts.addAttribute("", "version", "", "CDATA", "1.0");
            vSer.startElement("", "acteur", "", vAtts);
            vAtts.clear();
            vSer.startElement("", "identite", "", vAtts);
            if (this.fLastName != null) {
                vSer.startElement("", "nom", "", vAtts);
                vSer.characters(this.fLastName);
                vSer.endElement("", "nom", "");
            }
            if (this.fFirstName != null) {
                vSer.startElement("", "prenom", "", vAtts);
                vSer.characters(this.fFirstName);
                vSer.endElement("", "prenom", "");
            }
            if (this.fEmail != null) {
                vSer.startElement("", "email", "", vAtts);
                vSer.characters(this.fEmail);
                vSer.endElement("", "email", "");
            }
            vSer.endElement("", "identite", "");
            vSer.startElement("", "acces", "", vAtts);
            if (this.fDigestPassword != null) {
                vSer.startElement("", "digestPwd", "", vAtts);
                StringBuilder vSb = new StringBuilder();
                for (byte vByte : this.fDigestPassword) {
                    vSb.append((char)((vByte & 0xF) + 65));
                    vSb.append((char)((vByte >>> 4 & 0xF) + 65));
                }
                vSer.characters(vSb);
                vSer.endElement("", "digestPwd", "");
            }
            if (this.fIsSuperAdmin) {
                vAtts.addAttribute("", "type", "", "CDATA", "admin");
                vSer.startElement("", "role", "", vAtts);
                vAtts.clear();
                vSer.endElement("", "role", "");
            }
            vSer.endElement("", "acces", "");
            vSer.endElement("", "acteur", "");
            vSer.endDocument();
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Erreur au stockage de l'acteur '" + this.fAccount + "' \u00e0 l'url '" + vUriAcDef + "'.", new String[0]);
        }
        finally {
            if (vWriter != null) {
                vWriter.close();
            }
        }
    }

    protected void xSetRights(List pRights) {
        this.fIsSuperAdmin = pRights == null || pRights.size() == 0 ? false : pRights.indexOf("admin") >= 0;
    }
}

