/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.user.fs;

import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.fs.IUserUpdater;
import com.scenari.m.co.user.fs.UserAnonymous;
import com.scenari.m.co.user.fs.UserFs;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class UserMgrFs
implements IUserUpdater {
    public static final String ESPACE_USER = "Acteur";
    protected IWUnivers fUniverse = null;
    protected HashMap fUsers = new HashMap();
    protected boolean fAllUsersLoaded = false;
    protected boolean fAnomyousUserAllowed = false;
    protected boolean fAnonymousUserIsSuperAdmin = false;

    public UserMgrFs(IWUnivers pUniverse, boolean pAnomyousUserAllowed, boolean pAnonymousUserIsSuperAdmin) {
        this.fUniverse = pUniverse;
        this.fAnomyousUserAllowed = pAnomyousUserAllowed;
        this.fAnonymousUserIsSuperAdmin = pAnomyousUserAllowed;
    }

    public synchronized String deleteUser(String pAccount) throws Exception {
        UserFs vUser = (UserFs)this.getUser(pAccount);
        if (vUser != null) {
            UserFs.wDelete(this.fUniverse, pAccount);
            this.fUsers.remove(pAccount);
            return pAccount;
        }
        return null;
    }

    public synchronized IUser getUser(String pAccount) throws Exception {
        IUser vResult = (IUser)this.fUsers.get(pAccount);
        if (vResult == null) {
            vResult = this.xLoadUser(pAccount);
        }
        return vResult;
    }

    public IUser getAnonymousUser() throws Exception {
        return this.fAnomyousUserAllowed ? this.getUser("anonymous") : null;
    }

    public synchronized List listAllUsers() throws Exception {
        ArrayList vTmpList = null;
        try {
            if (!this.fAllUsersLoaded) {
                this.xLoadUsers();
            }
            Iterator vCollection = this.fUsers.values().iterator();
            vTmpList = new ArrayList();
            while (vCollection.hasNext()) {
                vTmpList.add(vCollection.next());
            }
            Collections.sort(vTmpList);
        }
        catch (Exception e) {
            LogMgr.removeException(e);
        }
        return vTmpList;
    }

    protected void xLoadUsers() throws Exception {
        assert (Thread.holdsLock(this));
        List<String> vFils = SrcFeaturePaths.findContentByPath(this.fUniverse.hGetEspace(ESPACE_USER), "ac", false).listChildrenNames(null, 2);
        for (int i = 0; i < vFils.size(); ++i) {
            String vID = null;
            try {
                vID = vFils.get(i);
                if (vID.length() <= 0 || vID.charAt(0) == '.') continue;
                this.xLoadUser(vID);
                continue;
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Erreur pour charger le userFS '" + vID + "'.", new String[0]);
            }
        }
        this.fAllUsersLoaded = true;
    }

    public boolean isUserUpdatable(IUser pUser) throws Exception {
        return !pUser.isAnonymous();
    }

    public synchronized boolean updateUser(String pCodeUser, String pPassword, String pLastName, String pFirstName, String pEmail, boolean pIsSuperAdmin) throws Exception {
        boolean vIsUpdated = true;
        try {
            IUser vUser = this.getUser(pCodeUser);
            if (vUser == null || !(vUser instanceof UserFs)) {
                vUser = this.xCreateUser(pCodeUser);
                if (vUser != null) {
                    ((UserFs)vUser).hSet(pCodeUser, pPassword, pLastName, pFirstName, pEmail, pIsSuperAdmin);
                    this.fUsers.put(pCodeUser, vUser);
                }
                vIsUpdated = false;
            } else {
                ((UserFs)vUser).hSet(pCodeUser, pPassword, pLastName, pFirstName, pEmail, pIsSuperAdmin);
                vIsUpdated = true;
            }
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Erreur lors de l'update de l'acteur", new String[0]);
        }
        return vIsUpdated;
    }

    protected IUser xCreateUser(String pCodeActeur) throws Exception {
        return UserFs.wCreate(this.fUniverse, pCodeActeur);
    }

    protected IUser xLoadUser(String pAccount) throws Exception {
        IUser vResult = this.fAnomyousUserAllowed && "anonymous".equals(pAccount) ? UserAnonymous.wLoad(this.fUniverse, this.fAnonymousUserIsSuperAdmin) : UserFs.wLoad(this.fUniverse, pAccount);
        if (vResult != null) {
            this.fUsers.put(pAccount, vResult);
        } else if (this.fUsers.size() == 0) {
            LogMgr.publishTrace("Aucun acteur de code '" + pAccount + "' dans l'espace acteur : " + this.fUniverse.hGetEspace(ESPACE_USER), new String[0]);
        }
        return vResult;
    }
}

