/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.agent.IWAgentLinker;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.IWSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.Function;
import com.scenari.xsldom.xpath.objects.XNull;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public abstract class ZXPath
extends Function {
    public static final QName QNAME_VDIALOG = QName.getQNameFromString("vDialog");
    public static final QName QNAME_VAGENT = QName.getQNameFromString("vAgent");
    public static final QName QNAME_VSERVICE = QName.getQNameFromString("vService");
    public static final QName QNAME_VARGUMENTS = QName.getQNameFromString("vArguments");
    public static final QName QNAME_VCOMP = QName.getQNameFromString("vComp");
    public static final XNumber NUMBER_NAN = new XNumber(Double.NaN);
    public static final XNull XOBJECT_NULL = new XNull();
    private static final long serialVersionUID = -1097989806212570434L;

    public XObject execute(XPathContext pCtx) throws TransformerException {
        try {
            XObject vResult = this.xExecute(pCtx);
            return vResult == null ? XOBJECT_NULL : vResult;
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            XObject vObjDial = pCtx.getVariable(QNAME_VDIALOG);
            if (vObjDial != null) {
                LogMgr.addMessage((Throwable)e, "Echec au calcul d'une fonction XPath dans le dialogue " + vObjDial, new String[0]);
            }
            throw (TransformerException)LogMgr.addMessage(new TransformerException("Echec \u00e0 l'execution d'une fonction XPath (dom) : " + this.getClass().getName(), e), LogMgr.getMessage(e));
        }
    }

    public static final double hGetNodeToNumber(Node pNode) {
        return ZXPath.hGetStringToNumber(ZXPath.hGetNodeToString(pNode));
    }

    public static final String hGetNodeToString(Node pNode) {
        String vResult = null;
        switch (pNode.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuilder vBuf = PoolBuffers.popStringBuilder();
                for (Node vChild = pNode.getFirstChild(); vChild != null; vChild = vChild.getNextSibling()) {
                    ZXPath.xGetNodeToString(vChild, vBuf);
                }
                vResult = vBuf.length() > 0 ? vBuf.substring(0) : "";
                PoolBuffers.freeStringBuilder(vBuf);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                vResult = pNode.getNodeValue();
                break;
            }
        }
        return vResult;
    }

    public static final double hGetStringToNumber(String pString) {
        double vResult = Double.NaN;
        if (null == pString) {
            vResult = 0.0;
        } else {
            try {
                vResult = Double.valueOf(pString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return vResult;
    }

    public IWAgent wGetAgent(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 4: {
                Node vNode = pXObj.nodeset().nextNode();
                if (vNode != null && vNode instanceof IWAgent) {
                    return (IWAgent)((Object)vNode);
                }
                return null;
            }
            case 0: {
                Object vObj = pXObj.object();
                if (!(vObj instanceof IWAgent)) break;
                return (IWAgent)vObj;
            }
        }
        return null;
    }

    public IWAgent wGetRefAgent(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 4: {
                Node vNode = pXObj.nodeset().nextNode();
                if (vNode != null && vNode instanceof IWAgent) {
                    return (IWAgent)((Object)vNode);
                }
                return null;
            }
            case 3: {
                String vPath = pXObj.str();
                return this.wGetAgentFromCtx(pCtx).hGetAgentParRef(vPath);
            }
            case 0: {
                Object vObj = pXObj.object();
                if (vObj instanceof IWAgent) {
                    return (IWAgent)vObj;
                }
                if (vObj instanceof IWADialog) {
                    return ((IWADialog)vObj).hGetAgent();
                }
                if (!(vObj instanceof String)) break;
                return this.wGetAgentFromCtx(pCtx).hGetAgentParRef((String)vObj);
            }
        }
        return null;
    }

    public IWAgent wGetRefAgentDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent = this.wGetRefAgent(pCtx, pXObj);
        if (vAgent == null) {
            vAgent = this.wGetAgentFromCtx(pCtx);
        }
        return vAgent;
    }

    public IWAgentLinker wGetRefAgentAvecLiens(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent;
        for (vAgent = this.wGetRefAgent(pCtx, pXObj); vAgent != null && !(vAgent instanceof IWAgentLinker); vAgent = vAgent.hGetAgentPere()) {
        }
        return (IWAgentLinker)((Object)vAgent);
    }

    public IWAgentComputor wGetRefAgentAvecResultat(XPathContext pCtx, XObject pXObj) throws Exception {
        IWAgent vAgent;
        for (vAgent = this.wGetRefAgent(pCtx, pXObj); vAgent != null && !(vAgent instanceof IWAgentComputor); vAgent = vAgent.hGetAgentPere()) {
        }
        return (IWAgentComputor)((Object)vAgent);
    }

    public IHDialog wGetDialog(XPathContext pCtx, XObject pXObj) throws Exception {
        Object vObj;
        if (pXObj == null) {
            return null;
        }
        if (pXObj.getType() == 0 && (vObj = pXObj.object()) != null && vObj instanceof IHDialog) {
            return (IHDialog)vObj;
        }
        return null;
    }

    public IHDialog wGetRefDialog(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 3: {
                String vPath = pXObj.str();
                return this.wGetDialogFromCtx(pCtx).hGoTo(vPath);
            }
            case 0: {
                Object vObj = pXObj.object();
                if (vObj != null && vObj instanceof IHDialog) {
                    return (IHDialog)vObj;
                }
                return null;
            }
        }
        return null;
    }

    public IHDialog wGetRefDialogDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IHDialog vDialog = this.wGetRefDialog(pCtx, pXObj);
        if (vDialog == null) {
            vDialog = this.wGetDialogFromCtx(pCtx);
        }
        return vDialog;
    }

    public IWService wGetService(XPathContext pCtx, XObject pXObj) throws Exception {
        Object vObj;
        if (pXObj == null) {
            return null;
        }
        if (pXObj.getType() == 0 && (vObj = pXObj.object()) instanceof IWService) {
            return (IWService)vObj;
        }
        return null;
    }

    public IWService wGetRefService(XPathContext pCtx, XObject pXObj) throws Exception {
        if (pXObj == null) {
            return null;
        }
        switch (pXObj.getType()) {
            case 3: {
                String vPath = pXObj.str();
                IHDialog vResDialog = this.wGetDialogFromCtx(pCtx).hGoTo(vPath);
                if (vResDialog != null && vResDialog instanceof IWSDialog) {
                    return ((IWSDialog)vResDialog).hGetService();
                }
            }
            case 0: {
                IHDialog vResDialog;
                Object vObj = pXObj.object();
                if (vObj instanceof IWService) {
                    return (IWService)vObj;
                }
                if (vObj instanceof IWSDialog) {
                    return ((IWSDialog)vObj).hGetService();
                }
                if (!(vObj instanceof String) || (vResDialog = this.wGetDialogFromCtx(pCtx).hGoTo((String)vObj)) == null || !(vResDialog instanceof IWSDialog)) break;
                return ((IWSDialog)vResDialog).hGetService();
            }
        }
        return null;
    }

    public IWService wGetRefServiceDefault(XPathContext pCtx, XObject pXObj) throws Exception {
        IWService vService = this.wGetRefService(pCtx, pXObj);
        if (vService == null) {
            vService = this.wGetServiceFromCtx(pCtx);
        }
        return vService;
    }

    public Node wGetAsNode(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? pCtx.getContextNode() : pXObj.nodeset().nextNode();
    }

    public double wGetAsNumber(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? NUMBER_NAN.num() : pXObj.num();
    }

    public String wGetAsString(XPathContext pCtx, XObject pXObj) throws Exception {
        return pXObj == null ? "" : pXObj.str();
    }

    public IHDialog wGetDialogFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjDial = pCtx.getVariable(QNAME_VDIALOG);
        if (vObjDial == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte de niveau 'dynamique' disposant d'un param\u00e8tre 'vDialog'.", new String[0]);
        }
        return (IHDialog)vObjDial.object();
    }

    public IWAgent wGetAgentFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjAgt = pCtx.getVariable(QNAME_VAGENT);
        if (vObjAgt == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte de niveau 'dynamique' disposant d'un param\u00e8tre 'vAgent'.", new String[0]);
        }
        return (IWAgent)vObjAgt.object();
    }

    public IWService wGetServiceFromCtx(XPathContext pCtx) throws Exception {
        XObject vObjSvc = pCtx.getVariable(QNAME_VSERVICE);
        if (vObjSvc == null) {
            throw LogMgr.newException("Cette fonction XPath doit \u00eatre utilis\u00e9e dans un contexte disposant d'un param\u00e8tre 'vService'.", new String[0]);
        }
        return (IWService)vObjSvc.object();
    }

    public abstract XObject xExecute(XPathContext var1) throws Exception;

    private static final String xGetNodeToString(Node pNode, StringBuilder pBuf) {
        String vResult = null;
        switch (pNode.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                for (Node vChild = pNode.getFirstChild(); vChild != null; vChild = vChild.getNextSibling()) {
                    ZXPath.xGetNodeToString(vChild, pBuf);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                pBuf.append(pNode.getNodeValue());
                break;
            }
        }
        return vResult;
    }
}

