/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.m.co.xpath.dom;

import com.scenari.m.co.xpath.dom.ZXPath;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.xml.transform.TransformerException;

public class ZXPathChaineExtrait
extends ZXPath {
    static FontRenderContext sFrc = new FontRenderContext(null, false, false);
    Expression fArgChaine = null;
    Expression fArgFormat = null;
    Expression fArgLargeur = null;

    public void checkNumberArgs(int pArgNum) throws WrongNumberArgsException {
        if (pArgNum != 3) {
            throw new WrongNumberArgsException("3");
        }
    }

    public void setArg(Expression pArg, int pArgNum) throws WrongNumberArgsException {
        if (0 == pArgNum) {
            this.fArgChaine = pArg;
        } else if (1 == pArgNum) {
            this.fArgFormat = pArg;
        } else if (2 == pArgNum) {
            this.fArgLargeur = pArg;
        } else {
            throw new WrongNumberArgsException("3");
        }
    }

    public XObject xExecute(XPathContext pCtx) throws TransformerException {
        String vResult = "";
        String vChaine = this.fArgChaine.execute(pCtx).str();
        String vFormat = this.fArgFormat.execute(pCtx).str();
        double vLargMax = this.fArgLargeur.execute(pCtx).num();
        if (vLargMax > 0.0) {
            Font vFont = Font.decode(vFormat);
            Rectangle2D vRec = vFont.getStringBounds(vChaine, sFrc);
            double vWidth = vRec.getWidth();
            if (vWidth <= vLargMax) {
                vResult = vChaine;
            } else {
                char[] vExtrait = vChaine.toCharArray();
                int vLength = (int)((double)vExtrait.length * vLargMax / vWidth);
                if (vLength > vExtrait.length - 3) {
                    vLength = vExtrait.length - 3;
                }
                vExtrait[vLength++] = 46;
                vExtrait[vLength++] = 46;
                vExtrait[vLength++] = 46;
                vRec = vFont.getStringBounds(vExtrait, 0, vLength, sFrc);
                if (vRec.getWidth() <= vLargMax) {
                    while (vLength < vExtrait.length && vRec.getWidth() <= vLargMax) {
                        vExtrait[vLength - 3] = vChaine.charAt(vLength - 3);
                        vExtrait[vLength - 2] = 46;
                        vExtrait[vLength - 1] = 46;
                        vExtrait[vLength++] = 46;
                        vRec = vFont.getStringBounds(vExtrait, 0, vLength, sFrc);
                    }
                    if (vLength < vExtrait.length) {
                        vExtrait[vLength - 4] = 46;
                    }
                    vResult = new String(vExtrait, 0, vLength - 1);
                } else {
                    while (vLength > 3 && vRec.getWidth() >= vLargMax) {
                        vExtrait[--vLength - 3] = 46;
                        vRec = vFont.getStringBounds(vExtrait, 0, vLength, sFrc);
                    }
                    vResult = new String(vExtrait, 0, vLength);
                }
            }
        }
        return new XString(vResult);
    }
}

